/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import org.apache.catalina.realm.NestedCredentialHandler;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CredentialHandlerSF
extends StoreFactoryBase {
    private static final Log log = LogFactory.getLog(CredentialHandlerSF.class);

    @Override
    public void store(PrintWriter printWriter, int n, Object object) throws Exception {
        if (object instanceof NestedCredentialHandler) {
            StoreDescription storeDescription = this.getRegistry().findDescription(object.getClass());
            if (storeDescription != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("factory.storeTag", new Object[]{storeDescription.getTag(), object}));
                }
                this.getStoreAppender().printIndent(printWriter, n + 2);
                this.getStoreAppender().printOpenTag(printWriter, n + 2, object, storeDescription);
                this.storeChildren(printWriter, n + 2, object, storeDescription);
                this.getStoreAppender().printIndent(printWriter, n + 2);
                this.getStoreAppender().printCloseTag(printWriter, storeDescription);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{object.getClass()}));
            }
        } else {
            super.store(printWriter, n, object);
        }
    }

    @Override
    public void storeChildren(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        if (object instanceof NestedCredentialHandler) {
            NestedCredentialHandler nestedCredentialHandler = (NestedCredentialHandler)object;
            Object[] objectArray = nestedCredentialHandler.getCredentialHandlers();
            this.storeElementArray(printWriter, n, objectArray);
        }
    }
}

