/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.multitoken;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tools.StringTools;

public class MultitokenSpellerFilter
extends RuleFilter {
    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        List<String> replacements;
        if (Arrays.stream(patternTokens).allMatch(x -> x.isIgnoredBySpeller())) {
            return null;
        }
        String underlinedError = match.getOriginalErrorStr();
        Language lang = ((PatternRule)match.getRule()).getLanguage();
        boolean areTokensAcceptedBySpeller = false;
        if (lang.getShortCode().equals("en") || lang.getShortCode().equals("de") || lang.getShortCode().equals("pt") || lang.getShortCode().equals("nl")) {
            if (lang.getShortCodeWithCountryAndVariant().length() == 2) {
                lang = lang.getDefaultLanguageVariant();
            }
            boolean bl = areTokensAcceptedBySpeller = !this.isMisspelled(underlinedError, lang);
        }
        if ((replacements = lang.getMultitokenSpeller().getSuggestions(underlinedError, areTokensAcceptedBySpeller)).isEmpty()) {
            return null;
        }
        if (underlinedError.length() > 4 && StringTools.isAllUppercase(underlinedError)) {
            ArrayList<String> allupercaseReplacements = new ArrayList<String>();
            for (String replacement : replacements) {
                String newReplacement = replacement.toUpperCase();
                if (allupercaseReplacements.contains(newReplacement) || underlinedError.equals(newReplacement)) continue;
                allupercaseReplacements.add(newReplacement);
            }
            replacements = allupercaseReplacements;
        } else {
            int wordsStartPos;
            AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
            for (wordsStartPos = 1; wordsStartPos < tokens.length && (StringTools.isPunctuationMark(tokens[wordsStartPos].getToken()) || StringTools.isNotWordString(tokens[wordsStartPos].getToken())); ++wordsStartPos) {
            }
            if (patternTokenPos == wordsStartPos) {
                ArrayList<String> capitalizedReplacements = new ArrayList<String>();
                Iterator<String> iterator = replacements.iterator();
                while (iterator.hasNext()) {
                    String replacement;
                    String newReplacement = replacement = iterator.next();
                    if (replacement.equals(replacement.toLowerCase())) {
                        newReplacement = StringTools.uppercaseFirstChar(replacement);
                    }
                    if (capitalizedReplacements.contains(newReplacement) || underlinedError.equals(newReplacement)) continue;
                    capitalizedReplacements.add(newReplacement);
                }
                replacements = capitalizedReplacements;
            }
        }
        if (replacements.isEmpty()) {
            return null;
        }
        match.setSuggestedReplacements(replacements);
        return match;
    }

    public boolean isMisspelled(String s, Language language) throws IOException {
        SpellingCheckRule spellerRule = language.getDefaultSpellingRule();
        if (spellerRule == null) {
            return false;
        }
        List<String> tokens = language.getWordTokenizer().tokenize(s);
        for (String token : tokens) {
            if (!spellerRule.isMisspelled(token)) continue;
            return true;
        }
        return false;
    }
}

