/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.ParameterParser;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.cache.Cache;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeUGIProvider {
    private final ParameterParser params;
    @VisibleForTesting
    static Cache<String, UserGroupInformation> ugiCache;
    public static final Logger LOG;

    DataNodeUGIProvider(ParameterParser params) {
        this.params = params;
    }

    public static synchronized void init(Configuration conf) {
        if (ugiCache == null) {
            ugiCache = CacheBuilder.newBuilder().expireAfterAccess((long)conf.getInt("dfs.webhdfs.ugi.expire.after.access", 600000), TimeUnit.MILLISECONDS).build();
        }
    }

    @VisibleForTesting
    void clearCache() throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            ((DelegationTokenIdentifier)this.params.delegationToken().decodeIdentifier()).clearCache();
        }
    }

    UserGroupInformation ugi() throws IOException {
        UserGroupInformation ugi;
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                final Token<DelegationTokenIdentifier> token = this.params.delegationToken();
                ugi = (UserGroupInformation)ugiCache.get((Object)this.buildTokenCacheKey(token), (Callable)new Callable<UserGroupInformation>(){

                    @Override
                    public UserGroupInformation call() throws Exception {
                        return DataNodeUGIProvider.this.tokenUGI((Token<DelegationTokenIdentifier>)token);
                    }
                });
            } else {
                final String usernameFromQuery = this.params.userName();
                final String doAsUserFromQuery = this.params.doAsUser();
                final String remoteUser = usernameFromQuery == null ? JspHelper.getDefaultWebUserName(this.params.conf()) : usernameFromQuery;
                ugi = (UserGroupInformation)ugiCache.get((Object)this.buildNonTokenCacheKey(doAsUserFromQuery, remoteUser), (Callable)new Callable<UserGroupInformation>(){

                    @Override
                    public UserGroupInformation call() throws Exception {
                        return DataNodeUGIProvider.this.nonTokenUGI(usernameFromQuery, doAsUserFromQuery, remoteUser);
                    }
                });
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        return ugi;
    }

    private String buildTokenCacheKey(Token<DelegationTokenIdentifier> token) {
        return token.buildCacheKey();
    }

    private UserGroupInformation tokenUGI(Token<DelegationTokenIdentifier> token) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        DelegationTokenIdentifier id = new DelegationTokenIdentifier();
        id.readFields((DataInput)in);
        UserGroupInformation ugi = id.getUser();
        ugi.addToken(token);
        return ugi;
    }

    private String buildNonTokenCacheKey(String doAsUserFromQuery, String remoteUser) throws IOException {
        String key = doAsUserFromQuery == null ? String.format("{%s}", remoteUser) : String.format("{%s}:{%s}", remoteUser, doAsUserFromQuery);
        return key;
    }

    private UserGroupInformation nonTokenUGI(String usernameFromQuery, String doAsUserFromQuery, String remoteUser) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)remoteUser);
        JspHelper.checkUsername(ugi.getShortUserName(), usernameFromQuery);
        if (doAsUserFromQuery != null) {
            ugi = UserGroupInformation.createProxyUser((String)doAsUserFromQuery, (UserGroupInformation)ugi);
        }
        return ugi;
    }

    static {
        LOG = LoggerFactory.getLogger(Client.class);
    }
}

