/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.AlterIndexFinalStep;
import org.jooq.AlterIndexStep;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class AlterIndexImpl
extends AbstractQuery
implements AlterIndexStep,
AlterIndexFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_INDEX};
    private final Index index;
    private final boolean ifExists;
    private Index renameTo;

    AlterIndexImpl(Configuration configuration, Index index) {
        this(configuration, index, false);
    }

    AlterIndexImpl(Configuration configuration, Index index, boolean ifExists) {
        super(configuration);
        this.index = index;
        this.ifExists = ifExists;
    }

    @Override
    public final AlterIndexImpl renameTo(String newName) {
        return this.renameTo(DSL.name(newName));
    }

    @Override
    public final AlterIndexImpl renameTo(Name newName) {
        return this.renameTo(DSL.index(newName));
    }

    @Override
    public final AlterIndexImpl renameTo(Index newName) {
        this.renameTo = newName;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !Arrays.asList(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatchIfExists(ctx, DDLStatementType.ALTER_INDEX, this.index);
            this.accept0(ctx);
            Tools.endTryCatchIfExists(ctx, DDLStatementType.ALTER_INDEX, this.index);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean renameIndex = Arrays.asList(SQLDialect.DERBY).contains((Object)ctx.family());
        ctx.start(Clause.ALTER_INDEX_INDEX).visit(renameIndex ? Keywords.K_RENAME_INDEX : Keywords.K_ALTER_INDEX);
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.index).end(Clause.ALTER_INDEX_INDEX).formatIndentStart().formatSeparator();
        if (this.renameTo != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_INDEX_RENAME).qualify(false).visit(renameIndex ? Keywords.K_TO : Keywords.K_RENAME_TO).sql(' ').visit(this.renameTo).qualify(qualify).end(Clause.ALTER_INDEX_RENAME);
        }
        ctx.formatIndentEnd();
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

