/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch.core.search.HighlightBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class HighlightField
extends HighlightBase
implements ToCopyableBuilder<Builder, HighlightField> {
    @Nullable
    private final Analyzer analyzer;
    @Nonnull
    private final List<String> matchedFields;
    public static final JsonpDeserializer<HighlightField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HighlightField::setupHighlightFieldDeserializer);

    private HighlightField(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.matchedFields = ApiTypeHelper.unmodifiable(builder.matchedFields);
    }

    public static HighlightField of(Function<Builder, ObjectBuilder<HighlightField>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Analyzer analyzer() {
        return this.analyzer;
    }

    @Nonnull
    public final List<String> matchedFields() {
        return this.matchedFields;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            this.analyzer.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.matchedFields)) {
            generator.writeKey("matched_fields");
            generator.writeStartArray();
            for (String item0 : this.matchedFields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupHighlightFieldDeserializer(ObjectDeserializer<Builder> op) {
        HighlightField.setupHighlightBaseDeserializer(op);
        op.add(Builder::analyzer, Analyzer._DESERIALIZER, "analyzer");
        op.add(Builder::matchedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "matched_fields");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + Objects.hashCode(this.matchedFields);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HighlightField other = (HighlightField)o;
        return Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.matchedFields, other.matchedFields);
    }

    public static class Builder
    extends HighlightBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, HighlightField> {
        @Nullable
        private Analyzer analyzer;
        @Nullable
        private List<String> matchedFields;

        public Builder() {
        }

        private Builder(HighlightField o) {
            super(o);
            this.analyzer = o.analyzer;
            this.matchedFields = Builder._listCopy(o.matchedFields);
        }

        private Builder(Builder o) {
            super(o);
            this.analyzer = o.analyzer;
            this.matchedFields = Builder._listCopy(o.matchedFields);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder analyzer(@Nullable Analyzer value) {
            this.analyzer = value;
            return this;
        }

        @Nonnull
        public final Builder analyzer(Function<Analyzer.Builder, ObjectBuilder<Analyzer>> fn) {
            return this.analyzer(fn.apply(new Analyzer.Builder()).build());
        }

        @Nonnull
        public final Builder matchedFields(List<String> list) {
            this.matchedFields = Builder._listAddAll(this.matchedFields, list);
            return this;
        }

        @Nonnull
        public final Builder matchedFields(String value, String ... values) {
            this.matchedFields = Builder._listAdd(this.matchedFields, value, values);
            return this;
        }

        @Override
        @Nonnull
        public HighlightField build() {
            this._checkSingleUse();
            return new HighlightField(this);
        }
    }
}

