/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Objects;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.TwitterException;
import twitter4j.v1.UploadedMedia;

final class UploadedMediaImpl
implements UploadedMedia,
Serializable {
    private static final long serialVersionUID = 3375172182790067615L;
    private int imageWidth;
    private int imageHeight;
    private String imageType;
    private long mediaId;
    private long size;
    private String processingState;
    private int processingCheckAfterSecs;
    private int progressPercent;

    UploadedMediaImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    @Override
    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public int getImageHeight() {
        return this.imageHeight;
    }

    @Override
    public String getImageType() {
        return this.imageType;
    }

    @Override
    public long getMediaId() {
        return this.mediaId;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getProcessingState() {
        return this.processingState;
    }

    @Override
    public int getProcessingCheckAfterSecs() {
        return this.processingCheckAfterSecs;
    }

    @Override
    public int getProgressPercent() {
        return this.progressPercent;
    }

    private void init(JSONObject json) throws TwitterException {
        this.mediaId = ParseUtil.getLong("media_id", json);
        this.size = ParseUtil.getLong("size", json);
        try {
            if (!json.isNull("image")) {
                JSONObject image = json.getJSONObject("image");
                this.imageWidth = ParseUtil.getInt("w", image);
                this.imageHeight = ParseUtil.getInt("h", image);
                this.imageType = ParseUtil.getUnescapedString("image_type", image);
            }
            if (!json.isNull("processing_info")) {
                JSONObject processingInfo = json.getJSONObject("processing_info");
                this.processingState = ParseUtil.getUnescapedString("state", processingInfo);
                this.processingCheckAfterSecs = ParseUtil.getInt("check_after_secs", processingInfo);
                this.progressPercent = ParseUtil.getInt("progress_percent", processingInfo);
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadedMediaImpl that = (UploadedMediaImpl)o;
        return this.imageWidth == that.imageWidth && this.imageHeight == that.imageHeight && this.mediaId == that.mediaId && this.size == that.size && this.processingCheckAfterSecs == that.processingCheckAfterSecs && this.progressPercent == that.progressPercent && Objects.equals(this.imageType, that.imageType) && Objects.equals(this.processingState, that.processingState);
    }

    public int hashCode() {
        return Objects.hash(this.imageWidth, this.imageHeight, this.imageType, this.mediaId, this.size, this.processingState, this.processingCheckAfterSecs, this.progressPercent);
    }

    public String toString() {
        return "UploadedMediaImpl{imageWidth=" + this.imageWidth + ", imageHeight=" + this.imageHeight + ", imageType='" + this.imageType + '\'' + ", mediaId=" + this.mediaId + ", size=" + this.size + ", processingState='" + this.processingState + '\'' + ", processingCheckAfterSecs=" + this.processingCheckAfterSecs + ", progressPercent=" + this.progressPercent + '}';
    }
}

