/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.DateRange;
import ch.poole.openinghoursparser.DateWithOffset;
import ch.poole.openinghoursparser.Holiday;
import ch.poole.openinghoursparser.I18n;
import ch.poole.openinghoursparser.Month;
import ch.poole.openinghoursparser.Nth;
import ch.poole.openinghoursparser.OpeningHoursParseException;
import ch.poole.openinghoursparser.OpeningHoursParserConstants;
import ch.poole.openinghoursparser.OpeningHoursParserTokenManager;
import ch.poole.openinghoursparser.ParseException;
import ch.poole.openinghoursparser.Rule;
import ch.poole.openinghoursparser.RuleModifier;
import ch.poole.openinghoursparser.SimpleCharStream;
import ch.poole.openinghoursparser.TimeSpan;
import ch.poole.openinghoursparser.Token;
import ch.poole.openinghoursparser.Util;
import ch.poole.openinghoursparser.VariableTime;
import ch.poole.openinghoursparser.WeekDay;
import ch.poole.openinghoursparser.WeekDayRange;
import ch.poole.openinghoursparser.WeekRange;
import ch.poole.openinghoursparser.YearRange;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class OpeningHoursParser
implements OpeningHoursParserConstants {
    static int TWELVEHOURS = 720;
    boolean strict = false;
    boolean strictTime = false;
    boolean monthOnly = false;
    List<ParseException> exceptions = new ArrayList<ParseException>();
    public OpeningHoursParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[105];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public List<Rule> rules(boolean strict) throws OpeningHoursParseException {
        return this.rules(strict, true);
    }

    public List<Rule> rules(boolean strict, boolean strictTime) throws OpeningHoursParseException {
        try {
            List<Rule> r = this.rules0(strict, strictTime);
            if (this.exceptions.size() > 1) {
                throw new OpeningHoursParseException(this.exceptions);
            }
            if (this.exceptions.size() == 1) {
                ParseException t = this.exceptions.get(0);
                if (t instanceof OpeningHoursParseException) {
                    throw (OpeningHoursParseException)t;
                }
                throw new OpeningHoursParseException(t);
            }
            return r;
        }
        catch (ParseException pex) {
            throw (OpeningHoursParseException)pex;
        }
    }

    void error_skip(ParseException e) throws ParseException {
        Token t;
        this.exceptions.add(e);
        do {
            t = this.getNextToken();
        } while (t.kind != 3 && t.kind != 2 && t.kind != 17 && t.kind != 1 && t.kind != 6 && t.kind != 0);
    }

    boolean precedingWs(Token t) throws ParseException {
        return t.specialToken != null && t.specialToken.kind == 1;
    }

    public final Token one2five() throws ParseException {
        Token n = null;
        if (this.getToken((int)1).kind != 15 || !Util.between(this.getToken((int)1).image, 1, 5)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        n = this.jj_consume_token(15);
        return n;
    }

    public final Token number() throws ParseException {
        Token n = null;
        if (this.getToken((int)1).kind != 15 || !Util.equalsOrMore(this.getToken((int)1).image, 1)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        n = this.jj_consume_token(15);
        return n;
    }

    public final String comment() throws ParseException {
        StringBuilder builder = new StringBuilder();
        this.jj_consume_token(12);
        while (this.jj_2_1(6)) {
            this.getChar(builder);
        }
        this.jj_consume_token(13);
        return builder.toString();
    }

    public final void getChar(StringBuilder builder) throws ParseException {
        Token t = this.jj_consume_token(14);
        if (t.image.length() < 2) {
            builder.append(t.image.charAt(0));
        }
    }

    public final Token hours() throws ParseException {
        Token h = null;
        if (this.getToken((int)1).kind != 15 || !Util.between(this.getToken((int)1).image, 0, 24)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        h = this.jj_consume_token(15);
        return h;
    }

    public final Token minutes() throws ParseException {
        Token delimiter = null;
        Token m = null;
        if (this.jj_2_2(6)) {
            delimiter = this.jj_consume_token(4);
        } else if (this.jj_2_3(6)) {
            delimiter = this.jj_consume_token(8);
        } else if (this.jj_2_4(6)) {
            delimiter = this.jj_consume_token(9);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (this.getToken((int)1).kind != 15 || !Util.between(this.getToken((int)1).image, 0, 59) || this.getToken((int)1).image.length() < 2 && !"0".equals(this.getToken((int)1).image)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        m = this.jj_consume_token(15);
        if (this.strict && (m.image.length() != 2 || delimiter.kind != 4 || this.precedingWs(m) || this.precedingWs(delimiter))) {
            OpeningHoursParseException pex = new OpeningHoursParseException(I18n.tr("invalid_minutes", new Object[0]), this.token.next);
            pex.currentToken = this.token;
            throw pex;
        }
        return m;
    }

    public final int time() throws ParseException {
        Token h = null;
        Token m = null;
        int result = 0;
        AMPM ampm = null;
        h = this.hours();
        if (this.jj_2_5(Integer.MAX_VALUE) && h != null) {
            m = this.minutes();
        }
        if (this.jj_2_6(6)) {
            ampm = this.ampm();
        }
        if (this.strict && m == null) {
            OpeningHoursParseException pex = new OpeningHoursParseException(I18n.tr("hours_without_minutes", new Object[0]));
            pex.currentToken = this.token;
            throw pex;
        }
        if (m != null) {
            result = Integer.parseInt(m.image);
        }
        if (ampm == AMPM.PM && (result += Integer.parseInt(h.image) * 60) < TWELVEHOURS) {
            result += TWELVEHOURS;
        } else if (ampm == AMPM.AM && result >= TWELVEHOURS && result < TWELVEHOURS + 60) {
            result -= TWELVEHOURS;
        }
        return result;
    }

    public final AMPM ampm() throws ParseException {
        Object result = null;
        Token ampm = null;
        if (this.jj_2_7(6)) {
            ampm = this.jj_consume_token(29);
        } else if (this.jj_2_8(6)) {
            ampm = this.jj_consume_token(30);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (ampm != null) {
            if (this.strict) {
                OpeningHoursParseException pex = new OpeningHoursParseException(I18n.tr("found", ampm.image), this.token.next);
                pex.currentToken = this.token;
                throw pex;
            }
            return ampm.kind == 29 ? AMPM.AM : AMPM.PM;
        }
        return null;
    }

    public final int extendedtime() throws ParseException {
        Token h = null;
        Token m = null;
        int result = 0;
        AMPM ampm = null;
        if (this.getToken((int)1).kind != 15 || !Util.between(this.getToken((int)1).image, 0, 48)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        h = this.jj_consume_token(15);
        if (this.jj_2_9(Integer.MAX_VALUE) && h != null) {
            m = this.minutes();
        }
        if (this.jj_2_10(6)) {
            ampm = this.ampm();
        }
        if (this.strict && m == null) {
            OpeningHoursParseException pex = new OpeningHoursParseException(I18n.tr("hours_without_minutes", new Object[0]));
            pex.currentToken = this.token;
            throw pex;
        }
        if (m != null) {
            result = Integer.parseInt(m.image);
        }
        if (ampm == AMPM.PM && (result += Integer.parseInt(h.image) * 60) < TWELVEHOURS) {
            result += TWELVEHOURS;
        } else if (ampm == AMPM.AM && result >= TWELVEHOURS && result < TWELVEHOURS + 60) {
            result -= TWELVEHOURS;
        }
        return result;
    }

    public final VariableTime variabletime() throws ParseException {
        Token event = null;
        Token sign = null;
        int offset = 0;
        VariableTime vt = new VariableTime();
        if (this.jj_2_13(6)) {
            event = this.jj_consume_token(26);
            vt.setEvent(event.image);
            return vt;
        }
        if (this.jj_2_14(6)) {
            this.jj_consume_token(32);
            event = this.jj_consume_token(26);
            if (this.jj_2_11(6)) {
                sign = this.jj_consume_token(5);
            } else if (this.jj_2_12(6)) {
                sign = this.jj_consume_token(6);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            offset = this.time();
            this.jj_consume_token(33);
            vt.setEvent(event.image);
            vt.offset = (sign.image.equals("-") ? -1 : 1) * offset;
            return vt;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int interval() throws ParseException {
        Token number = null;
        Token hours = null;
        int interval = 0;
        this.jj_consume_token(7);
        if (this.jj_2_15(Integer.MAX_VALUE)) {
            hours = this.hours();
            number = this.minutes();
            interval = Integer.parseInt(hours.image) * 60 + Integer.parseInt(number.image);
        } else if (this.jj_2_16(6)) {
            number = this.number();
            interval = Integer.parseInt(number.image);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return interval;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final TimeSpan timespan() throws ParseException {
        int start = 0;
        int end = -1;
        Token startplus = null;
        Token endplus = null;
        Token to = null;
        VariableTime startVT = null;
        VariableTime endVT = null;
        TimeSpan ts = new TimeSpan();
        int inter = 0;
        if (this.jj_2_17(6)) {
            ts.start = start = this.time();
        } else {
            if (!this.jj_2_18(6)) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            ts.startEvent = startVT = this.variabletime();
        }
        if (this.jj_2_28(6)) {
            if (this.jj_2_26(6)) {
                startplus = this.jj_consume_token(5);
            } else {
                if (!this.jj_2_27(6)) {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                if (this.jj_2_19(6)) {
                    this.jj_consume_token(6);
                } else {
                    if (!this.jj_2_20(6)) {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    to = this.jj_consume_token(31);
                }
                if (this.jj_2_21(6)) {
                    end = this.extendedtime();
                    if (end < start) {
                        if (this.strict && this.strictTime) {
                            OpeningHoursParseException pex = new OpeningHoursParseException(I18n.tr("earlier_than_time", new Object[0]), this.token.next);
                            pex.currentToken = this.token;
                            throw pex;
                        }
                        end += 1440;
                    }
                    ts.end = end;
                } else {
                    if (!this.jj_2_22(6)) {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    ts.endEvent = endVT = this.variabletime();
                }
                if (this.strict && to != null) {
                    throw new OpeningHoursParseException(I18n.tr("to_instead_of_dash", new Object[0]), this.token.next);
                }
                if (this.jj_2_25(6)) {
                    if (this.jj_2_23(6)) {
                        endplus = this.jj_consume_token(5);
                    } else {
                        if (!this.jj_2_24(6)) {
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        ts.interval = inter = this.interval();
                    }
                }
            }
        }
        ts.openEnded = startplus != null || endplus != null;
        return ts;
    }

    public final List<TimeSpan> time_selector() throws ParseException {
        ArrayList<TimeSpan> result = new ArrayList<TimeSpan>();
        TimeSpan ts = this.timespan();
        result.add(ts);
        while (this.jj_2_29(6)) {
            this.jj_consume_token(2);
            TimeSpan ts1 = this.timespan();
            result.add(ts1);
        }
        return result;
    }

    public final String weekday() throws ParseException {
        Token w = null;
        if (this.jj_2_32(6)) {
            w = this.jj_consume_token(21);
            return w.image;
        }
        if (this.jj_2_33(6)) {
            if (this.jj_2_30(6)) {
                w = this.jj_consume_token(22);
            } else if (this.jj_2_31(6)) {
                w = this.jj_consume_token(23);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            if (this.strict) {
                String msg = w.kind == 22 ? I18n.tr("invalid_week_day_three", new Object[0]) : I18n.tr("invalid_week_day_german", new Object[0]);
                OpeningHoursParseException e = new OpeningHoursParseException(msg, this.token.next);
                e.currentToken = this.token;
                throw e;
            }
            return w.image;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final WeekDayRange weekday_range() throws ParseException {
        String startDay = null;
        String endDay = null;
        Nth nth = null;
        Nth nth1 = null;
        Token m = null;
        Token n = null;
        Token to = null;
        WeekDayRange wdr = new WeekDayRange();
        startDay = this.weekday();
        if (this.jj_2_42(6)) {
            if (this.jj_2_40(6)) {
                if (this.jj_2_34(6)) {
                    this.jj_consume_token(6);
                } else if (this.jj_2_35(6)) {
                    to = this.jj_consume_token(31);
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                endDay = this.weekday();
                if (this.strict && to != null) {
                    throw new OpeningHoursParseException(I18n.tr("to_instead_of_dash", new Object[0]), this.token.next);
                }
                wdr.setEndDay(endDay);
            } else if (this.jj_2_41(6)) {
                this.jj_consume_token(10);
                nth = this.nth();
                wdr.add(nth);
                while (this.jj_2_36(6)) {
                    this.jj_consume_token(2);
                    nth1 = this.nth();
                    wdr.add(nth1);
                }
                this.jj_consume_token(11);
                if (this.jj_2_39(6)) {
                    if (this.jj_2_37(6)) {
                        m = this.jj_consume_token(6);
                    } else if (this.jj_2_38(6)) {
                        this.jj_consume_token(5);
                    } else {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    n = this.number();
                    this.jj_consume_token(19);
                    wdr.offset = Integer.parseInt(n.image);
                    if (m != null) {
                        wdr.offset *= -1;
                    }
                }
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        wdr.setStartDay(startDay);
        return wdr;
    }

    public final Nth nth() throws ParseException {
        Nth n = new Nth();
        Token t1 = null;
        Token t2 = null;
        Token sign = null;
        Token sign2 = null;
        if (this.jj_2_44(6)) {
            if (this.jj_2_43(6)) {
                sign = this.jj_consume_token(6);
            }
            t1 = this.one2five();
            n.startNth = Integer.parseInt(t1.image);
            if (sign != null) {
                n.startNth *= -1;
            }
        }
        if (this.jj_2_46(6)) {
            this.jj_consume_token(6);
            if (this.jj_2_45(6)) {
                sign2 = this.jj_consume_token(6);
            }
            t2 = this.one2five();
            n.endNth = Integer.parseInt(t2.image);
            if (sign2 != null) {
                n.endNth *= -1;
            }
        }
        return n;
    }

    public final List<WeekDayRange> weekday_selector() throws ParseException {
        ArrayList<WeekDayRange> result = new ArrayList<WeekDayRange>();
        WeekDayRange wdr = this.weekday_range();
        result.add(wdr);
        while (this.jj_2_47(6)) {
            this.jj_consume_token(2);
            WeekDayRange wdr1 = this.weekday_range();
            result.add(wdr1);
        }
        return result;
    }

    public final Holiday holiday() throws ParseException {
        Token h = null;
        Token n = null;
        Token m = null;
        Holiday result = new Holiday();
        h = this.jj_consume_token(25);
        if (this.jj_2_50(6)) {
            if (this.jj_2_48(6)) {
                m = this.jj_consume_token(6);
            } else if (this.jj_2_49(6)) {
                this.jj_consume_token(5);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            n = this.number();
            this.jj_consume_token(19);
            result.offset = Integer.parseInt(n.image);
            if (m != null) {
                result.offset *= -1;
            }
        }
        result.type = Holiday.Type.valueOf(h.image.toUpperCase(Locale.US));
        return result;
    }

    public final List<Holiday> holiday_sequence() throws ParseException {
        Holiday h = null;
        Holiday h1 = null;
        ArrayList<Holiday> result = new ArrayList<Holiday>();
        h = this.holiday();
        result.add(h);
        while (this.jj_2_51(6)) {
            this.jj_consume_token(2);
            h1 = this.holiday();
            result.add(h1);
        }
        return result;
    }

    public final String month() throws ParseException {
        Token m = null;
        m = this.jj_consume_token(24);
        return m.image;
    }

    public final DateRange date_range() throws ParseException {
        DateRange mdr = new DateRange();
        DateWithOffset startDate = null;
        DateWithOffset endDate = null;
        Object plus = null;
        Token to = null;
        startDate = this.datewithoffset(false);
        if (this.strict && startDate.getVarDate() == null && startDate.getMonth() == null) {
            throw new OpeningHoursParseException(I18n.tr("missing_month", new Object[0]), this.token.next);
        }
        mdr.startDate = startDate;
        boolean bl = startDate.openEnded = plus != null;
        if (this.jj_2_57(6)) {
            if (this.jj_2_55(6)) {
                if (this.jj_2_52(6)) {
                    this.jj_consume_token(6);
                } else if (this.jj_2_53(6)) {
                    to = this.jj_consume_token(31);
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                endDate = this.datewithoffset(startDate.undefinedDay());
                if (this.strict && to != null) {
                    throw new OpeningHoursParseException(I18n.tr("to_instead_of_dash", new Object[0]), this.token != null ? this.token.next : null);
                }
                if (startDate.undefinedDay() && !endDate.undefinedDay() || !startDate.undefinedDay() && endDate.undefinedDay()) {
                    if (this.strict) {
                        throw new OpeningHoursParseException(I18n.tr("missing_day_in_range", startDate.toString(), endDate.toString()), this.token != null ? this.token.next : null);
                    }
                    if (startDate.undefinedDay()) {
                        startDate.setDay(1);
                    } else {
                        endDate.setDay(Month.lastDay(endDate.getYear(), endDate.getMonth()));
                    }
                }
                mdr.endDate = endDate;
                if (this.jj_2_54(6)) {
                    mdr.interval = this.interval();
                    if (startDate.day != Integer.MIN_VALUE || endDate.day != Integer.MIN_VALUE || startDate.varDate != null || endDate.varDate != null) {
                        throw new OpeningHoursParseException(I18n.tr("interval_not_allowed_here", new Object[0]), this.token != null ? this.token.next : null);
                    }
                }
            } else if (this.jj_2_56(6)) {
                this.jj_consume_token(5);
                startDate.openEnded = true;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return mdr;
    }

    public final int daynum() throws ParseException {
        Token n = null;
        if (this.getToken((int)1).kind != 15 || !Util.between(this.getToken((int)1).image, 1, 31) || this.getToken((int)2).kind == 4 && this.getToken((int)3).kind == 15 && this.getToken((int)4).kind != 4) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        n = this.jj_consume_token(15);
        if (this.strict && n.image.length() != 2) {
            OpeningHoursParseException pex = new OpeningHoursParseException(I18n.tr("invalid_month_day", n.image), this.token.next);
            pex.currentToken = this.token;
            throw pex;
        }
        return Integer.parseInt(n.image);
    }

    public final int year() throws ParseException {
        Token n = null;
        if (this.getToken((int)1).kind != 15 || !Util.equalsOrMore(this.getToken((int)1).image, 1900)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        n = this.jj_consume_token(15);
        return Integer.parseInt(n.image);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final DateWithOffset datewithoffset(boolean mo) throws ParseException {
        Token m;
        DateWithOffset dwo;
        block15: {
            Token wd;
            Token num;
            Token minus;
            block18: {
                Token v;
                block16: {
                    Token sign;
                    String nthWd;
                    Token nth;
                    block17: {
                        dwo = new DateWithOffset();
                        int y = 0;
                        m = null;
                        Object d = null;
                        Object h = null;
                        Object n = null;
                        v = null;
                        minus = null;
                        num = null;
                        wd = null;
                        nth = null;
                        nthWd = null;
                        sign = null;
                        this.monthOnly = mo;
                        if (this.jj_2_58(6)) {
                            dwo.year = y = this.year();
                        }
                        if (!this.jj_2_71(6)) break block15;
                        if (!this.jj_2_63(6)) break block16;
                        if (!this.jj_2_61(Integer.MAX_VALUE) || (this.monthOnly || this.getToken((int)1).kind != 15 || this.getToken((int)2).kind == 4 && this.getToken((int)2).kind == 8 && this.getToken((int)2).kind == 9) && (this.getToken((int)1).kind != 24 || this.getToken((int)2).kind != 15 || this.getToken((int)3).kind == 4 && this.getToken((int)3).kind == 8 && this.getToken((int)3).kind == 9)) break block17;
                        if (this.jj_2_59(6)) {
                            m = this.jj_consume_token(24);
                            dwo.setMonth(m.image);
                        }
                        dwo.day = this.daynum();
                        break block18;
                    }
                    if (this.jj_2_62(11) && !this.monthOnly && (this.getToken((int)(this.getToken((int)4).kind == 6 ? 9 : 8)).kind == 19 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 10 : 9)).kind != 2 || this.getToken((int)(this.getToken((int)4).kind == 6 ? 9 : 8)).kind != 19 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 7 : 6)).kind != 2 || this.getToken((int)(this.getToken((int)4).kind == 6 ? 9 : 8)).kind == 19 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 10 : 9)).kind == 2 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 11 : 10)).kind != 21 || this.getToken((int)(this.getToken((int)4).kind == 6 ? 9 : 8)).kind != 19 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 7 : 6)).kind == 2 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 8 : 7)).kind != 21)) {
                        m = this.jj_consume_token(24);
                        dwo.setMonth(m.image);
                        nthWd = this.weekday();
                        this.jj_consume_token(10);
                        if (this.jj_2_60(6)) {
                            sign = this.jj_consume_token(6);
                        }
                        nth = this.one2five();
                        this.jj_consume_token(11);
                        dwo.nthWeekDay = WeekDay.getValue(nthWd);
                        dwo.nth = Integer.parseInt(nth.image);
                        if (sign != null) {
                            dwo.nth *= -1;
                        }
                        break block18;
                    } else {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (!this.jj_2_64(6)) {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                v = this.jj_consume_token(27);
                dwo.setVarDate(v.image);
            }
            if (this.jj_2_67(5) && (this.getToken((int)1).kind == 6 || !this.precedingWs(this.getToken(2)) || this.getToken((int)5).kind == 19)) {
                if (this.jj_2_65(6)) {
                    minus = this.jj_consume_token(6);
                } else {
                    if (!this.jj_2_66(6)) {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    this.jj_consume_token(5);
                }
                wd = this.jj_consume_token(21);
                dwo.weekDayOffsetPositive = minus == null;
                dwo.setWeekDayOffset(wd.image);
            }
            if (!this.jj_2_70(6)) return dwo;
            if (this.jj_2_68(6)) {
                minus = this.jj_consume_token(6);
            } else {
                if (!this.jj_2_69(6)) {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(5);
            }
            num = this.number();
            this.jj_consume_token(19);
            dwo.dayOffset = Integer.parseInt(num.image) * (minus != null ? -1 : 1);
            return dwo;
        }
        if (this.jj_2_72(6)) {
            m = this.jj_consume_token(24);
            dwo.setMonth(m.image);
            return dwo;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<DateRange> date_selector() throws ParseException {
        Month lastMonth = null;
        ArrayList<DateRange> result = new ArrayList<DateRange>();
        if ((this.getToken((int)1).kind != 15 || this.getToken((int)2).kind != 24 && this.getToken((int)2).kind != 27) && this.getToken((int)1).kind != 24 && this.getToken((int)1).kind != 27) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        DateRange mdr = this.date_range();
        result.add(mdr);
        while (this.jj_2_73(6)) {
            this.jj_consume_token(2);
            DateRange mdr1 = this.date_range();
            DateWithOffset dwo = mdr1.getStartDate();
            if (dwo.getVarDate() == null) {
                if (dwo.getMonth() == null) {
                    DateWithOffset first;
                    if (this.strict) {
                        throw new OpeningHoursParseException(I18n.tr("missing_month_start", new Object[0]), this.token.next);
                    }
                    if (lastMonth == null && (lastMonth = (first = mdr.getStartDate()).getMonth()) == null) {
                        throw new OpeningHoursParseException(I18n.tr("missing_month_start", new Object[0]), this.token.next);
                    }
                    dwo.setMonth(lastMonth);
                } else if (dwo.getMonth() != null) {
                    lastMonth = dwo.getMonth();
                }
            }
            result.add(mdr1);
        }
        return result;
    }

    public final int weeknum() throws ParseException {
        Token n = null;
        if (this.getToken((int)1).kind != 15 || !Util.between(this.getToken((int)1).image, 1, 54)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        n = this.jj_consume_token(15);
        return Integer.parseInt(n.image);
    }

    public final WeekRange week_range() throws ParseException {
        WeekRange wr = new WeekRange();
        Object w = null;
        Object w1 = null;
        Token to = null;
        wr.startWeek = this.weeknum();
        if (this.jj_2_77(6)) {
            if (this.jj_2_74(6)) {
                this.jj_consume_token(6);
            } else if (this.jj_2_75(6)) {
                to = this.jj_consume_token(31);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            wr.endWeek = this.weeknum();
            if (this.strict && to != null) {
                throw new OpeningHoursParseException(I18n.tr("to_instead_of_dash", new Object[0]), this.token.next);
            }
            if (this.jj_2_76(6)) {
                wr.interval = this.interval();
            }
        }
        return wr;
    }

    public final List<WeekRange> week_selector() throws ParseException {
        ArrayList<WeekRange> result = new ArrayList<WeekRange>();
        this.jj_consume_token(20);
        WeekRange wr = this.week_range();
        result.add(wr);
        while (this.jj_2_78(6)) {
            this.jj_consume_token(2);
            WeekRange wr1 = this.week_range();
            result.add(wr1);
        }
        return result;
    }

    public final YearRange year_range() throws ParseException {
        YearRange yr = new YearRange();
        Object y = null;
        Object y1 = null;
        Token to = null;
        yr.startYear = this.year();
        if (this.jj_2_84(6)) {
            if (this.jj_2_82(6)) {
                if (this.jj_2_79(6)) {
                    this.jj_consume_token(6);
                } else if (this.jj_2_80(6)) {
                    to = this.jj_consume_token(31);
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                yr.endYear = this.year();
                if (this.strict && to != null) {
                    throw new OpeningHoursParseException(I18n.tr("to_instead_of_dash", new Object[0]), this.token.next);
                }
                if (this.jj_2_81(6)) {
                    yr.interval = this.interval();
                }
            } else if (this.jj_2_83(6)) {
                this.jj_consume_token(5);
                yr.openEnded = true;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return yr;
    }

    public final List<YearRange> year_selector() throws ParseException {
        ArrayList<YearRange> result = new ArrayList<YearRange>();
        if (this.getToken((int)2).kind == 24 || this.getToken((int)2).kind == 27) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        YearRange yr = this.year_range();
        result.add(yr);
        while (this.jj_2_85(6)) {
            this.jj_consume_token(2);
            YearRange yr1 = this.year_range();
            result.add(yr1);
        }
        return result;
    }

    public final RuleModifier rule_modifier() throws ParseException {
        RuleModifier rm = new RuleModifier();
        Token m = null;
        String c = null;
        if (this.jj_2_86(6)) {
            m = this.jj_consume_token(28);
            rm.setModifier(m.image);
        }
        if (this.jj_2_87(6)) {
            rm.comment = c = this.comment();
        }
        if (rm.modifier == null && rm.comment == null) {
            return null;
        }
        return rm;
    }

    public final Rule rule() throws ParseException {
        Rule r = null;
        String comment = null;
        boolean always = false;
        List<YearRange> ys = null;
        List<WeekRange> ws = null;
        List<DateRange> ms = null;
        List<Holiday> hs = null;
        List<Holiday> hs2 = null;
        List<WeekDayRange> ds = null;
        List<WeekDayRange> ds2 = null;
        List<Object> ts = null;
        RuleModifier rm = null;
        boolean colonForClarification = false;
        if (this.jj_2_92(Integer.MAX_VALUE)) {
            comment = this.comment();
            this.jj_consume_token(4);
        } else {
            if (this.jj_2_88(6)) {
                ys = this.year_selector();
            }
            if (this.jj_2_89(6)) {
                ws = this.week_selector();
            }
            if (this.jj_2_90(6)) {
                ms = this.date_selector();
            }
            if (this.jj_2_91(6)) {
                this.jj_consume_token(4);
                colonForClarification = true;
            }
        }
        if (this.jj_2_101(6)) {
            this.jj_consume_token(18);
            if (this.strict && (ys != null || ws != null || ms != null)) {
                OpeningHoursParseException e = new OpeningHoursParseException(I18n.tr("24_7_with_other_selectors", new Object[0]));
                e.currentToken = this.token;
                throw e;
            }
            if (ys != null || ws != null || ms != null) {
                ts = new ArrayList();
                TimeSpan t = new TimeSpan();
                t.start = 0;
                t.end = 1440;
                ts.add(t);
            } else {
                always = true;
            }
        } else {
            if (this.jj_2_93(6)) {
                hs = this.holiday_sequence();
            }
            if (this.jj_2_98(6)) {
                if (this.jj_2_94(6)) {
                    this.jj_consume_token(2);
                    ds = this.weekday_selector();
                    if (hs != null) {
                        for (Holiday h : hs) {
                            h.setUseAsWeekDay(true);
                        }
                    }
                } else if (this.jj_2_95(6)) {
                    ds = this.weekday_selector();
                    if (hs != null) {
                        for (Holiday h : hs) {
                            h.setUseAsWeekDay(false);
                        }
                    }
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                while (this.jj_2_96(6)) {
                    this.jj_consume_token(2);
                    hs2 = this.holiday_sequence();
                    if (hs2 != null) {
                        for (Holiday h : hs2) {
                            h.setUseAsWeekDay(true);
                            h.setAfterWeekDays(true);
                        }
                    }
                    if (hs != null) {
                        hs.addAll(hs2);
                    } else {
                        hs = hs2;
                    }
                    while (this.jj_2_97(6)) {
                        this.jj_consume_token(2);
                        ds2 = this.weekday_selector();
                        if (this.strict && hs2 != null) {
                            OpeningHoursParseException e = new OpeningHoursParseException(I18n.tr("holiday_in_weekday_range", new Object[0]), this.token.next);
                            e.currentToken = this.token;
                            throw e;
                        }
                        if (ds != null) {
                            ds.addAll(ds2);
                            continue;
                        }
                        ds = ds2;
                    }
                }
            }
            if (this.jj_2_99(6)) {
                this.jj_consume_token(4);
            }
            if (this.jj_2_100(6)) {
                ts = this.time_selector();
            }
        }
        rm = this.rule_modifier();
        r = new Rule();
        r.comment = comment;
        r.twentyfourseven = always;
        r.years = ys;
        r.weeks = ws;
        r.dates = ms;
        r.holidays = hs;
        r.days = ds;
        r.times = ts;
        r.modifier = rm;
        r.colonForClarification = colonForClarification;
        return r;
    }

    private final List<Rule> rules0(boolean strict, boolean strictTime) throws ParseException {
        this.strict = strict;
        this.strictTime = strictTime;
        ArrayList<Rule> result = new ArrayList<Rule>();
        Rule r = null;
        Rule r1 = null;
        try {
            r = this.rule();
            result.add(r);
        }
        catch (ParseException e) {
            this.error_skip(e);
            return this.rules0(strict, strictTime);
        }
        try {
            while (this.jj_2_102(6)) {
                if (this.jj_2_103(6)) {
                    this.jj_consume_token(2);
                    r1 = this.rule();
                    r1.additive = true;
                    r1.fallBack = false;
                    result.add(r1);
                    continue;
                }
                if (this.jj_2_104(6)) {
                    this.jj_consume_token(3);
                    r1 = this.rule();
                    r1.additive = false;
                    r1.fallBack = false;
                    result.add(r1);
                    continue;
                }
                if (this.jj_2_105(6)) {
                    this.jj_consume_token(17);
                    r1 = this.rule();
                    r1.additive = false;
                    r1.fallBack = true;
                    result.add(r1);
                    continue;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(0);
        }
        catch (ParseException e) {
            this.error_skip(e);
            return this.rules0(strict, strictTime);
        }
        r.additive = false;
        r.fallBack = false;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_69(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_69();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(68, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_70(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_70();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(69, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_71(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_71();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(70, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_72(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_72();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(71, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_73(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_73();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(72, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_74(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_74();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(73, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_75(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_75();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(74, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_76(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_76();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(75, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_77(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_77();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(76, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_78(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_78();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(77, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_79(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_79();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(78, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_80(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_80();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(79, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_81(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_81();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(80, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_82(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_82();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(81, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_83(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_83();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(82, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_84(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_84();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(83, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_85(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_85();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(84, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_86(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_86();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(85, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_87(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_87();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(86, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_88(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_88();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(87, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_89(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_89();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(88, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_90(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_90();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(89, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_91(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_91();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(90, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_92(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_92();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(91, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_93(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_93();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(92, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_94(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_94();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(93, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_95(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_95();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(94, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_96(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_96();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(95, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_97(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_97();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(96, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_98(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_98();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(97, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_99(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_99();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(98, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_100(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_100();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(99, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_101(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_101();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(100, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_102(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_102();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(101, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_103(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_103();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(102, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_104(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_104();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(103, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_105(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_105();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(104, xla);
        }
    }

    private boolean jj_3_38() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(6)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(5)) {
                return true;
            }
        }
        if (this.jj_3R_17()) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_4()) {
                    return true;
                }
            }
        }
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 15 && Util.between(this.getToken((int)1).image, 0, 59) && (this.getToken((int)1).image.length() >= 2 || "0".equals(this.getToken((int)1).image));
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_46()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3_37() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3_104() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        return this.jj_3R_45();
    }

    private boolean jj_3_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_37()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_38()) {
                return true;
            }
        }
        if (this.jj_3R_17()) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_48() {
        return false;
    }

    private boolean jj_3_73() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_34();
    }

    private boolean jj_3_103() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_45();
    }

    private boolean jj_3R_58() {
        return false;
    }

    private boolean jj_3_36() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_22();
    }

    private boolean jj_3_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_103()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_104()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_105()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_16() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 15 && Util.between(this.getToken((int)1).image, 0, 24);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_48()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3_35() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_41() {
        Token xsp;
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 15 && (this.getToken((int)2).kind == 24 || this.getToken((int)2).kind == 27) || this.getToken((int)1).kind == 24 || this.getToken((int)1).kind == 27;
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_58()) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_73());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_41() {
        Token xsp;
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_36());
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(11)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_39()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_34() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_12() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_40()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_41()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_35()) {
                return true;
            }
        }
        return this.jj_3R_23();
    }

    private boolean jj_3_72() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3_69() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_25() {
        if (this.jj_3R_23()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_42()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_68() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3_67() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(6)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(5)) {
                return true;
            }
        }
        return this.jj_scan_token(21);
    }

    private boolean jj_3_1() {
        return this.jj_3R_12();
    }

    private boolean jj_3_70() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_68()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_69()) {
                return true;
            }
        }
        if (this.jj_3R_17()) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private boolean jj_3_31() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_38() {
        Token xsp;
        if (this.jj_scan_token(12)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_1());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(13);
    }

    private boolean jj_3_66() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3_65() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_49() {
        return false;
    }

    private boolean jj_3_100() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_65()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_66()) {
                return true;
            }
        }
        return this.jj_scan_token(21);
    }

    private boolean jj_3_99() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_17() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 15 && Util.equalsOrMore(this.getToken((int)1).image, 1);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_49()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3_30() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3_64() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_53() {
        return false;
    }

    private boolean jj_3_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_31()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_97() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_43();
    }

    private boolean jj_3_60() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3_32() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_33()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_62() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(6)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_24() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 15 && Util.between(this.getToken((int)1).image, 1, 5);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_53()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3_29() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_21();
    }

    private boolean jj_3R_32() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_60()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3_96() {
        Token xsp;
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_42()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_97());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3R_44() {
        Token xsp;
        if (this.jj_3R_21()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_29());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_59() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3_95() {
        return this.jj_3R_43();
    }

    private boolean jj_3R_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_59()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3_63() {
        Token xsp = this.jj_scanpos;
        this.jj_lookingAhead = true;
        this.jj_semLA = !this.monthOnly && this.getToken((int)1).kind == 15 && (this.getToken((int)2).kind != 4 || this.getToken((int)2).kind != 8 || this.getToken((int)2).kind != 9) || this.getToken((int)1).kind == 24 && this.getToken((int)2).kind == 15 && (this.getToken((int)3).kind != 4 || this.getToken((int)3).kind != 8 || this.getToken((int)3).kind != 9);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_31()) {
            this.jj_scanpos = xsp;
            this.jj_lookingAhead = true;
            this.jj_semLA = !this.monthOnly && (this.getToken((int)(this.getToken((int)4).kind == 6 ? 9 : 8)).kind == 19 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 10 : 9)).kind != 2 || this.getToken((int)(this.getToken((int)4).kind == 6 ? 9 : 8)).kind != 19 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 7 : 6)).kind != 2 || this.getToken((int)(this.getToken((int)4).kind == 6 ? 9 : 8)).kind == 19 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 10 : 9)).kind == 2 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 11 : 10)).kind != 21 || this.getToken((int)(this.getToken((int)4).kind == 6 ? 9 : 8)).kind != 19 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 7 : 6)).kind == 2 && this.getToken((int)(this.getToken((int)4).kind == 6 ? 8 : 7)).kind != 21);
            this.jj_lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_32()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_24() {
        return this.jj_3R_20();
    }

    private boolean jj_3_94() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_43();
    }

    private boolean jj_3_23() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_24()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_98() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_94()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_95()) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_96());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_64()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_70()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_93() {
        return this.jj_3R_42();
    }

    private boolean jj_3_58() {
        return this.jj_3R_28();
    }

    private boolean jj_3_22() {
        return this.jj_3R_18();
    }

    private boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_58()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_71()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_72()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_93()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_98()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_99()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_100()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_20() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3_21() {
        return this.jj_3R_19();
    }

    private boolean jj_3R_54() {
        return false;
    }

    private boolean jj_3_19() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_20()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_22()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_26() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_26()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_27()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_28() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 15 && Util.equalsOrMore(this.getToken((int)1).image, 1900);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_54()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3_101() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3_18() {
        return this.jj_3R_18();
    }

    private boolean jj_3_91() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_55() {
        return false;
    }

    private boolean jj_3_17() {
        return this.jj_3R_15();
    }

    private boolean jj_3_90() {
        return this.jj_3R_41();
    }

    private boolean jj_3_89() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_18()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_88() {
        return this.jj_3R_39();
    }

    private boolean jj_3_92() {
        if (this.jj_3R_38()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_60() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_88()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_89()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_90()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_91()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_29() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 15 && Util.between(this.getToken((int)1).image, 1, 31) && (this.getToken((int)2).kind != 4 || this.getToken((int)3).kind != 15 || this.getToken((int)4).kind == 4);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_55()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_59() {
        if (this.jj_3R_38()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_60()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_101()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_61()) {
                return true;
            }
        }
        return this.jj_3R_62();
    }

    private boolean jj_3_56() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3_15() {
        if (this.jj_3R_16()) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3_16() {
        return this.jj_3R_17();
    }

    private boolean jj_3_54() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_52() {
        if (this.jj_3R_16()) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3R_20() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_16()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_53() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3_87() {
        return this.jj_3R_38();
    }

    private boolean jj_3_52() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3_86() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_62() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_86()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_87()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_12() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_55()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_56()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_52()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_53()) {
                return true;
            }
        }
        if (this.jj_3R_27()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_54()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_11() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3_14() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_12()) {
                return true;
            }
        }
        if (this.jj_3R_15()) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_34() {
        if (this.jj_3R_27()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_57()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_57() {
        return false;
    }

    private boolean jj_3_13() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_14()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_85() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_37();
    }

    private boolean jj_3R_39() {
        Token xsp;
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind != 24 && this.getToken((int)2).kind != 27;
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_57()) {
            return true;
        }
        if (this.jj_3R_37()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_85());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_9() {
        return this.jj_3R_13();
    }

    private boolean jj_3_80() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3_51() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3_81() {
        return this.jj_3R_20();
    }

    private boolean jj_3_83() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_50() {
        return false;
    }

    private boolean jj_3_10() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_51() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_42() {
        Token xsp;
        if (this.jj_3R_26()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_51());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_79() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_19() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 15 && Util.between(this.getToken((int)1).image, 0, 48);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_50()) {
            return true;
        }
        if (this.jj_scan_token(15)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_51()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_82() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_79()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_80()) {
                return true;
            }
        }
        if (this.jj_3R_28()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_81()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_82()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_83()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_37() {
        if (this.jj_3R_28()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_84()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_49() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3_48() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_49()) {
                return true;
            }
        }
        if (this.jj_3R_17()) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private boolean jj_3_78() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_36();
    }

    private boolean jj_3R_26() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_50()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_8() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_7() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_40() {
        Token xsp;
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_78());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_8()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_75() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3_47() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3_76() {
        return this.jj_3R_20();
    }

    private boolean jj_3_4() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_43() {
        Token xsp;
        if (this.jj_3R_25()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_47());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_74() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3_5() {
        return this.jj_3R_13();
    }

    private boolean jj_3_77() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_74()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_75()) {
                return true;
            }
        }
        if (this.jj_3R_35()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_76()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_6() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_36() {
        if (this.jj_3R_35()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_77()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_45() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_56() {
        return false;
    }

    private boolean jj_3R_47() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_15() {
        if (this.jj_3R_16()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_46() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_45()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3_3() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3_43() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_35() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 15 && Util.between(this.getToken((int)1).image, 1, 54);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_56()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3_44() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_43()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_44()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_46()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_105() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_3R_45();
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_46() {
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[0];
    }

    public OpeningHoursParser(InputStream stream) {
        this(stream, null);
    }

    public OpeningHoursParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new OpeningHoursParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public OpeningHoursParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new OpeningHoursParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new OpeningHoursParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public OpeningHoursParser(OpeningHoursParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(OpeningHoursParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[35];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 35; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 105; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                            break;
                        }
                        case 52: {
                            this.jj_3_53();
                            break;
                        }
                        case 53: {
                            this.jj_3_54();
                            break;
                        }
                        case 54: {
                            this.jj_3_55();
                            break;
                        }
                        case 55: {
                            this.jj_3_56();
                            break;
                        }
                        case 56: {
                            this.jj_3_57();
                            break;
                        }
                        case 57: {
                            this.jj_3_58();
                            break;
                        }
                        case 58: {
                            this.jj_3_59();
                            break;
                        }
                        case 59: {
                            this.jj_3_60();
                            break;
                        }
                        case 60: {
                            this.jj_3_61();
                            break;
                        }
                        case 61: {
                            this.jj_3_62();
                            break;
                        }
                        case 62: {
                            this.jj_3_63();
                            break;
                        }
                        case 63: {
                            this.jj_3_64();
                            break;
                        }
                        case 64: {
                            this.jj_3_65();
                            break;
                        }
                        case 65: {
                            this.jj_3_66();
                            break;
                        }
                        case 66: {
                            this.jj_3_67();
                            break;
                        }
                        case 67: {
                            this.jj_3_68();
                            break;
                        }
                        case 68: {
                            this.jj_3_69();
                            break;
                        }
                        case 69: {
                            this.jj_3_70();
                            break;
                        }
                        case 70: {
                            this.jj_3_71();
                            break;
                        }
                        case 71: {
                            this.jj_3_72();
                            break;
                        }
                        case 72: {
                            this.jj_3_73();
                            break;
                        }
                        case 73: {
                            this.jj_3_74();
                            break;
                        }
                        case 74: {
                            this.jj_3_75();
                            break;
                        }
                        case 75: {
                            this.jj_3_76();
                            break;
                        }
                        case 76: {
                            this.jj_3_77();
                            break;
                        }
                        case 77: {
                            this.jj_3_78();
                            break;
                        }
                        case 78: {
                            this.jj_3_79();
                            break;
                        }
                        case 79: {
                            this.jj_3_80();
                            break;
                        }
                        case 80: {
                            this.jj_3_81();
                            break;
                        }
                        case 81: {
                            this.jj_3_82();
                            break;
                        }
                        case 82: {
                            this.jj_3_83();
                            break;
                        }
                        case 83: {
                            this.jj_3_84();
                            break;
                        }
                        case 84: {
                            this.jj_3_85();
                            break;
                        }
                        case 85: {
                            this.jj_3_86();
                            break;
                        }
                        case 86: {
                            this.jj_3_87();
                            break;
                        }
                        case 87: {
                            this.jj_3_88();
                            break;
                        }
                        case 88: {
                            this.jj_3_89();
                            break;
                        }
                        case 89: {
                            this.jj_3_90();
                            break;
                        }
                        case 90: {
                            this.jj_3_91();
                            break;
                        }
                        case 91: {
                            this.jj_3_92();
                            break;
                        }
                        case 92: {
                            this.jj_3_93();
                            break;
                        }
                        case 93: {
                            this.jj_3_94();
                            break;
                        }
                        case 94: {
                            this.jj_3_95();
                            break;
                        }
                        case 95: {
                            this.jj_3_96();
                            break;
                        }
                        case 96: {
                            this.jj_3_97();
                            break;
                        }
                        case 97: {
                            this.jj_3_98();
                            break;
                        }
                        case 98: {
                            this.jj_3_99();
                            break;
                        }
                        case 99: {
                            this.jj_3_100();
                            break;
                        }
                        case 100: {
                            this.jj_3_101();
                            break;
                        }
                        case 101: {
                            this.jj_3_102();
                            break;
                        }
                        case 102: {
                            this.jj_3_103();
                            break;
                        }
                        case 103: {
                            this.jj_3_104();
                            break;
                        }
                        case 104: {
                            this.jj_3_105();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        OpeningHoursParser.jj_la1_init_0();
        OpeningHoursParser.jj_la1_init_1();
    }

    static enum AMPM {
        AM,
        PM;

    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

