/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import korlibs.crypto.SecureRandomJvmKt;
import korlibs.crypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lkorlibs/crypto/SecureRandom;", "Lkotlin/random/Random;", "()V", "addSeed", "", "array", "", "getInt", "", "nextBits", "bitCount", "nextBytes", "fromIndex", "toIndex", "krypto"})
public final class SecureRandom
extends Random {
    @NotNull
    public static final SecureRandom INSTANCE = new SecureRandom();

    private SecureRandom() {
    }

    public final void addSeed(@NotNull byte[] array) {
        SecureRandomJvmKt.seedExtraRandomBytes(array);
    }

    private final int getInt() {
        byte[] temp = new byte[4];
        SecureRandomJvmKt.fillRandomBytes(temp);
        int a = temp[0] & 0xFF;
        int b = temp[1] & 0xFF;
        int c = temp[2] & 0xFF;
        int d = temp[3] & 0xFF;
        return a << 24 | b << 16 | c << 8 | d << 0;
    }

    @NotNull
    public byte[] nextBytes(@NotNull byte[] array, int fromIndex, int toIndex) {
        byte[] random = new byte[toIndex - fromIndex];
        SecureRandomJvmKt.fillRandomBytes(random);
        KryptoToolsKt.arraycopy(random, 0, array, fromIndex, random.length);
        return array;
    }

    public int nextBits(int bitCount) {
        return this.getInt() & (1 << bitCount) - 1;
    }
}

