/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiThisExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

class RecursionVisitor
extends GroovyRecursiveElementVisitor {
    private boolean recursive;
    private final GrMethod method;
    private final String methodName;

    RecursionVisitor(@NotNull GrMethod method) {
        if (method == null) {
            RecursionVisitor.$$$reportNull$$$0(0);
        }
        this.recursive = false;
        this.method = method;
        this.methodName = method.getName();
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        if (element == null) {
            RecursionVisitor.$$$reportNull$$$0(1);
        }
        if (!this.recursive) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitMethodCallExpression(@NotNull GrMethodCallExpression call) {
        if (call == null) {
            RecursionVisitor.$$$reportNull$$$0(2);
        }
        if (this.recursive) {
            return;
        }
        super.visitMethodCallExpression(call);
        GrExpression methodExpression = call.getInvokedExpression();
        if (!(methodExpression instanceof GrReferenceExpression)) {
            return;
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)methodExpression;
        String calledMethodName = referenceExpression.getReferenceName();
        if (calledMethodName == null) {
            return;
        }
        if (!calledMethodName.equals(this.methodName)) {
            return;
        }
        PsiMethod calledMethod = call.resolveMethod();
        if (!this.method.equals(calledMethod)) {
            return;
        }
        if (this.method.hasModifierProperty("static") || this.method.hasModifierProperty("private")) {
            this.recursive = true;
            return;
        }
        GrExpression qualifier = referenceExpression.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiThisExpression) {
            this.recursive = true;
        }
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/RecursionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

