/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GradleNameElement {
    @NotNull
    public static final Pattern INDEX_PATTERN = Pattern.compile("\\[(.+?)\\]|(.+?)(?=\\[)");
    @Nullable
    private PsiElement myNameElement;
    @Nullable
    private String myLocalName;
    @Nullable
    private String myFakeName;
    @Nullable
    private String myName;
    @Nullable
    private String myOriginalName;

    @NotNull
    public static GradleNameElement from(@NotNull PsiElement element, GradleDslNameConverter converter) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(0);
        }
        return new GradleNameElement(element, converter);
    }

    @NotNull
    public static GradleNameElement empty() {
        return new GradleNameElement(null, null);
    }

    @NotNull
    public static GradleNameElement create(@NotNull String name2) {
        if (name2 == null) {
            GradleNameElement.$$$reportNull$$$0(1);
        }
        return new GradleNameElement(GradleNameElement.escape(name2), false);
    }

    @NotNull
    public static GradleNameElement fake(@NotNull String name2) {
        if (name2 == null) {
            GradleNameElement.$$$reportNull$$$0(2);
        }
        return new GradleNameElement(name2, true);
    }

    @NotNull
    public static GradleNameElement copy(@NotNull GradleNameElement element) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(3);
        }
        return new GradleNameElement(element);
    }

    private GradleNameElement(@Nullable PsiElement element, GradleDslNameConverter converter) {
        this.myName = null;
        this.setUpFrom(element, converter);
    }

    private GradleNameElement(@NotNull String name2, boolean isFake) {
        if (name2 == null) {
            GradleNameElement.$$$reportNull$$$0(4);
        }
        this.myName = null;
        if (isFake) {
            this.myFakeName = name2;
        } else {
            this.myLocalName = name2;
        }
        this.myOriginalName = name2;
    }

    private GradleNameElement(@NotNull GradleNameElement element) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(5);
        }
        this.myName = null;
        this.myLocalName = element.myLocalName;
        this.myFakeName = element.myFakeName;
        this.myOriginalName = element.myOriginalName;
    }

    public void commitNameChange(@Nullable PsiElement nameElement, GradleDslNameConverter converter, GradleDslElement context) {
        this.setUpFrom(nameElement, converter);
        ModelPropertyDescription property = converter.modelDescriptionForParent(this.fullName(), context);
        if (property == null) {
            this.rename(this.fullNameParts());
        } else {
            this.rename(property.name);
        }
        this.myOriginalName = this.findName();
    }

    @NotNull
    public String fullName() {
        List<String> parts = this.fullNameParts();
        String string = GradleNameElement.createNameFromParts(parts);
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public @Unmodifiable List<String> fullNameParts() {
        String name2 = this.findName();
        if (name2 == null) {
            return new ArrayList<String>();
        }
        List<String> nameSegments = GradleNameElement.split(name2);
        List list = ContainerUtil.map(nameSegments, GradleNameElement::convertNameToKey);
        if (list == null) {
            GradleNameElement.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static String createNameFromParts(@NotNull @Unmodifiable List<String> parts) {
        if (parts == null) {
            GradleNameElement.$$$reportNull$$$0(8);
        }
        return GradleNameElement.join(parts);
    }

    @NotNull
    public @Unmodifiable List<String> qualifyingParts() {
        List<String> parts = this.fullNameParts();
        if (parts.isEmpty()) {
            List<String> list = parts;
            if (list == null) {
                GradleNameElement.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> list = parts.subList(0, parts.size() - 1);
        if (list == null) {
            GradleNameElement.$$$reportNull$$$0(10);
        }
        return list;
    }

    public boolean isQualified() {
        List<String> parts = this.fullNameParts();
        return parts.size() > 1;
    }

    @NotNull
    public String name() {
        List<String> parts = this.fullNameParts();
        if (parts.isEmpty()) {
            return "";
        }
        String string = parts.get(parts.size() - 1);
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public PsiElement getNamedPsiElement() {
        return this.myNameElement;
    }

    @Nullable
    public String getLocalName() {
        return this.myLocalName;
    }

    @Nullable
    public String getOriginalName() {
        return this.myOriginalName;
    }

    private void internalRename(@NotNull String newName) {
        if (newName == null) {
            GradleNameElement.$$$reportNull$$$0(12);
        }
        if (!this.isFake()) {
            this.myLocalName = newName;
        } else {
            this.myFakeName = newName;
        }
        this.myName = null;
    }

    public void rename(@NotNull String newName) {
        if (newName == null) {
            GradleNameElement.$$$reportNull$$$0(13);
        }
        this.internalRename(GradleNameElement.escape(newName));
    }

    public void rename(@NotNull List<String> hierarchicalName) {
        if (hierarchicalName == null) {
            GradleNameElement.$$$reportNull$$$0(14);
        }
        this.internalRename(GradleNameElement.join(hierarchicalName));
    }

    public boolean isEmpty() {
        String name2 = this.findName();
        return name2 == null || name2.isEmpty();
    }

    public boolean isFake() {
        return this.myNameElement == null && this.myFakeName != null;
    }

    @NotNull
    public String toString() {
        String string = this.fullName();
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(15);
        }
        return string;
    }

    public boolean isReferencedIn(@NotNull String propertyReference) {
        String indexName;
        String name2;
        if (propertyReference == null) {
            GradleNameElement.$$$reportNull$$$0(16);
        }
        if (propertyReference.equals(name2 = this.name())) {
            return true;
        }
        Matcher matcher = INDEX_PATTERN.matcher(propertyReference);
        if (matcher.find() && matcher.groupCount() > 0 && (indexName = matcher.group(0)).equals(name2)) {
            return true;
        }
        List<String> parts = GradleNameElement.split(propertyReference);
        if (!parts.isEmpty() && parts.get(0).equals(name2)) {
            return true;
        }
        return parts.size() > 1 && parts.get(0).equals(ExtDslElement.EXT.name) && parts.get(1).equals(name2);
    }

    @Nullable
    private String findName() {
        if (this.myName != null) {
            return this.myName;
        }
        String name2 = null;
        if (this.myLocalName != null) {
            name2 = this.myLocalName;
        }
        if (name2 == null && this.myFakeName != null) {
            name2 = this.myFakeName;
        }
        this.myName = name2;
        return name2;
    }

    @NotNull
    public static String convertNameToKey(@NotNull String str) {
        if (str == null) {
            GradleNameElement.$$$reportNull$$$0(17);
        }
        String string = StringUtil.unquoteString((String)str);
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String escape(@NotNull String part) {
        String result;
        if (part == null) {
            GradleNameElement.$$$reportNull$$$0(19);
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < part.length(); ++i) {
            char c = part.charAt(i);
            if (c == '.' || c == '\\') {
                buf.append('\\');
            }
            buf.append(c);
        }
        String string = result = buf.toString();
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String unescape(@NotNull String part) {
        String result;
        if (part == null) {
            GradleNameElement.$$$reportNull$$$0(21);
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < part.length(); ++i) {
            char c = part.charAt(i);
            if (c == '\\') {
                assert (i < part.length() - 1);
                buf.append(part.charAt(++i));
                continue;
            }
            buf.append(c);
        }
        String string = result = buf.toString();
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull List<String> parts) {
        String result;
        if (parts == null) {
            GradleNameElement.$$$reportNull$$$0(23);
        }
        String string = result = parts.stream().map(GradleNameElement::escape).collect(Collectors.joining("."));
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static List<String> split(@NotNull String name2) {
        if (name2 == null) {
            GradleNameElement.$$$reportNull$$$0(25);
        }
        StringBuilder buf = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < name2.length(); ++i) {
            char c = name2.charAt(i);
            if (c == '\\') {
                assert (i < name2.length() - 1);
                buf.append(name2.charAt(++i));
                continue;
            }
            if (c == '.') {
                result.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(name2.charAt(i));
        }
        result.add(buf.toString());
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            GradleNameElement.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    private void setUpFrom(@Nullable PsiElement element, GradleDslNameConverter converter) {
        this.myNameElement = element;
        this.myFakeName = null;
        if (this.myNameElement instanceof PsiNamedElement) {
            this.myLocalName = GradleNameElement.escape(((PsiNamedElement)this.myNameElement).getName());
        } else if (this.myNameElement != null) {
            this.myLocalName = converter.psiToName(this.myNameElement);
        }
        this.myOriginalName = this.myLocalName;
        this.myName = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 10, 11, 15, 18, 20, 22, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleNameElement";
                break;
            }
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchicalName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyReference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleNameElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fullName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fullNameParts";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifyingParts";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNameToKey";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fake";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNameFromParts";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "internalRename";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedIn";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertNameToKey";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 10, 11, 15, 18, 20, 22, 24, 26 -> new IllegalStateException(string);
        };
    }
}

