/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsFor
extends SourceInfoAwareJsNode
implements JsLoop {
    private JsStatement body;
    private JsExpression condition;
    private JsExpression incrementExpression;
    private JsExpression initExpression;
    private JsVars initVars;

    public JsFor(JsVars initVars, JsExpression condition, JsExpression incrementExpression) {
        this(initVars, condition, incrementExpression, null);
    }

    public JsFor(JsVars initVars, JsExpression condition, JsExpression incrementExpression, JsStatement body) {
        this.initVars = initVars;
        this.incrementExpression = incrementExpression;
        this.condition = condition;
        this.body = body;
        this.initExpression = null;
    }

    public JsFor(JsExpression initExpression, JsExpression condition, JsExpression incrementExpression) {
        this(initExpression, condition, incrementExpression, null);
    }

    public JsFor(JsExpression initExpression, JsExpression condition, JsExpression incrementExpression, JsStatement body) {
        this.initExpression = initExpression;
        this.incrementExpression = incrementExpression;
        this.condition = condition;
        this.body = body;
        this.initVars = null;
    }

    public JsStatement getBody() {
        return this.body;
    }

    public JsExpression getCondition() {
        return this.condition;
    }

    public JsExpression getIncrementExpression() {
        return this.incrementExpression;
    }

    public JsExpression getInitExpression() {
        return this.initExpression;
    }

    public JsVars getInitVars() {
        return this.initVars;
    }

    public void setBody(JsStatement body) {
        this.body = body;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitFor(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        assert (this.initExpression == null || this.initVars == null);
        if (this.initExpression != null) {
            visitor2.accept(this.initExpression);
        } else if (this.initVars != null) {
            visitor2.accept(this.initVars);
        }
        if (this.condition != null) {
            visitor2.accept(this.condition);
        }
        if (this.incrementExpression != null) {
            visitor2.accept(this.incrementExpression);
        }
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            assert (this.initExpression == null || this.initVars == null);
            if (this.initExpression != null) {
                this.initExpression = v.accept(this.initExpression);
            } else if (this.initVars != null) {
                JsVars newInitVars = v.acceptStatement(this.initVars);
                if (newInitVars instanceof JsVars) {
                    this.initVars = newInitVars;
                } else {
                    this.initVars = null;
                    if (newInitVars instanceof JsExpressionStatement) {
                        this.initExpression = ((JsExpressionStatement)((Object)newInitVars)).getExpression();
                    } else if (newInitVars != null) {
                        ctx.addPrevious(newInitVars);
                    }
                }
            }
            if (this.condition != null) {
                this.condition = v.accept(this.condition);
            }
            if (this.incrementExpression != null) {
                this.incrementExpression = v.accept(this.incrementExpression);
            }
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsFor deepCopy() {
        JsStatement bodyCopy = AstUtil.deepCopy(this.body);
        JsExpression conditionCopy = AstUtil.deepCopy(this.condition);
        JsExpression incrementalExprCopy = AstUtil.deepCopy(this.incrementExpression);
        JsFor result = this.initVars != null ? new JsFor(this.initVars.deepCopy(), conditionCopy, incrementalExprCopy, bodyCopy) : new JsFor(this.initExpression != null ? this.initExpression.deepCopy() : null, conditionCopy, incrementalExprCopy, bodyCopy);
        JsFor jsFor = (JsFor)result.withMetadataFrom(this);
        if (jsFor == null) {
            JsFor.$$$reportNull$$$0(0);
        }
        return jsFor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsFor", "deepCopy"));
    }
}

