/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class SuggestionFilter {
    private final Rule rule;
    private final JLanguageTool lt;

    public SuggestionFilter(Rule rule, Language lang) {
        this.rule = Objects.requireNonNull(rule);
        this.lt = lang.createDefaultJLanguageTool();
    }

    public List<String> filter(List<String> replacements, String template) {
        ArrayList<String> newReplacements = new ArrayList<String>();
        for (String repl : replacements) {
            try {
                List<AnalyzedSentence> analyzedSentences = this.lt.analyzeText(template.replace("{}", repl));
                RuleMatch[] matches = this.rule.match(analyzedSentences.get(0));
                if (matches.length != 0) continue;
                newReplacements.add(repl);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return newReplacements;
    }
}

