/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.internal.DefaultPluginDependenciesResolver;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.sisu.Priority;
import org.jetbrains.idea.maven.server.MavenServerGlobals;

@Named
@Singleton
@Priority(value=10)
public class Maven40PluginDependenciesResolver
implements PluginDependenciesResolver {
    private final PluginDependenciesResolver delegate;

    @Inject
    public Maven40PluginDependenciesResolver(DefaultPluginDependenciesResolver delegate) {
        this.delegate = delegate;
    }

    private static PluginDependenciesResolver findDefaultResolver(List<PluginDependenciesResolver> allResolvers) {
        for (PluginDependenciesResolver resolver : allResolvers) {
            if (!(resolver instanceof DefaultPluginDependenciesResolver)) continue;
            return resolver;
        }
        throw new RuntimeException("DefaultPluginDependenciesResolver not found");
    }

    public Artifact resolve(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.delegate.resolve(plugin, repositories, session);
    }

    public DependencyNode resolve(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return Maven40PluginDependenciesResolver.retryResolution(() -> this.delegate.resolve(plugin, pluginArtifact, dependencyFilter, repositories, session));
    }

    public DependencyResult resolvePlugin(Plugin plugin, Artifact artifact, DependencyFilter dependencyFilter, List<RemoteRepository> remotePluginRepositories, RepositorySystemSession repositorySession) throws PluginResolutionException {
        return Maven40PluginDependenciesResolver.retryResolution(() -> this.delegate.resolvePlugin(plugin, artifact, dependencyFilter, remotePluginRepositories, repositorySession));
    }

    private static <T> T retryResolution(ResolverAction<T> action) throws PluginResolutionException {
        try {
            return action.resolve();
        }
        catch (PluginResolutionException firstException) {
            MavenServerGlobals.getLogger().warn("Exception during plugin resolution. Will retry", (Throwable)firstException);
            return action.resolve();
        }
    }

    @FunctionalInterface
    private static interface ResolverAction<T> {
        public T resolve() throws PluginResolutionException;
    }
}

