---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Beamer API token'
---

## Description

The response body contains content that matches the pattern of a Beamer API token was detected. Beamer API tokens can be used to read, write, and delete posts, and "ideas" as well as see NPS analytical reports. This service is used to notify users of changes to your software with email or other methods. A malicious actor with access to this token can call API endpoints and create or delete posts and ideas or view reports.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). To delete your Beamer API token: - Sign in to your Beamer account at: <https://app.getbeamer.com/auth/login> - Select the gear icon ("Settings) in the bottom left corner and then select "API" in the left hand menu, or go to <https://app.getbeamer.com/settings#api> - Find the key that was detected and select the pencil icon "Edit" - Make note of all the permissions and their settings - Select "Delete Key" - Select "Create New API Key" - Apply the same settings as the detected key

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.17 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
