/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormSpecs;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.components.RenderedContentSupplier;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;

public class RadioButtonProperty
extends PropertyBean
implements IPropertyControl,
ActionListener {
    private final ButtonGroup group;
    private final Map<String, JRadioButton> buttonsByValue;
    private Vector<String> possibleValues;

    public RadioButtonProperty(String name, Collection<String> possibles, Collection<?> displayedItems) {
        super(name);
        this.fillPossibleValues(possibles);
        this.group = new ButtonGroup();
        this.buttonsByValue = new LinkedHashMap<String, JRadioButton>();
        List<Object> items = displayedItems instanceof List ? (List<Object>)displayedItems : new ArrayList(displayedItems);
        int index = 0;
        for (String value : this.possibleValues) {
            String display = index < items.size() ? items.get(index) : value;
            JRadioButton radio = this.createRadioButton(display, value);
            this.buttonsByValue.put(value, radio);
            this.group.add(radio);
            ++index;
        }
    }

    public RadioButtonProperty(String name, String[] values) {
        this(name, Arrays.asList(values), ComboProperty.translate(values));
    }

    public static <T extends Enum<T>> RadioButtonProperty of(String name, Class<T> enumClass) {
        return RadioButtonProperty.of(name, enumClass, null);
    }

    public static <T extends Enum<T>> RadioButtonProperty of(String name, Class<T> enumClass, RenderedContentSupplier<T> supplier) {
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        Vector<String> choices = new Vector<String>(constants.length);
        ArrayList<String> displayed = new ArrayList<String>(constants.length);
        for (Enum e : constants) {
            String text;
            String key;
            String choice = e.name();
            choices.add(choice);
            if (supplier != null) {
                key = enumClass.getSimpleName() + "." + choice;
                text = TextUtils.getText("OptionPanel." + key, null);
                Icon icon = ResourceController.getResourceController().getIcon("OptionPanel." + key + ".icon");
                String shown = text != null ? text : TextUtils.getText("OptionPanel." + choice, choice);
                JRadioButton preview = new JRadioButton(shown);
                if (icon != null) {
                    preview.setIcon(icon);
                }
                displayed.add(preview.getText());
                continue;
            }
            key = enumClass.getSimpleName() + "." + choice;
            text = TextUtils.getText("OptionPanel." + key, null);
            String item = text != null ? text : choice;
            displayed.add(item);
        }
        return new RadioButtonProperty(name, choices, displayed);
    }

    private void fillPossibleValues(Collection<String> possibles) {
        this.possibleValues = new Vector();
        this.possibleValues.addAll(possibles);
    }

    private JRadioButton createRadioButton(Object display, String value) {
        JRadioButton radio;
        if (display instanceof String) {
            radio = new JRadioButton((String)display);
        } else if (display instanceof Icon) {
            radio = new JRadioButton();
            radio.setIcon((Icon)display);
        } else {
            radio = display instanceof JRadioButton ? (JRadioButton)display : new JRadioButton(String.valueOf(display));
        }
        radio.setActionCommand(value);
        radio.addActionListener(this);
        return radio;
    }

    @Override
    public String getValue() {
        if (this.group.getSelection() == null) {
            return null;
        }
        return this.group.getSelection().getActionCommand();
    }

    @Override
    public JComponent getValueComponent() {
        return this.buttonsByValue.get(this.getValue());
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        int rowCount = 0;
        for (JRadioButton button : this.buttonsByValue.values()) {
            if (0 == rowCount++) {
                super.appendToForm(builder, button);
                continue;
            }
            builder.append("");
            button.setToolTipText(this.labelComponent.getToolTipText());
            builder.append((Component)button);
            builder.getLayout().setRowSpec(builder.getRowCount() - 1, FormSpecs.NARROW_LINE_GAP_ROWSPEC);
        }
    }

    public Vector<String> getPossibleValues() {
        return this.possibleValues;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (JRadioButton b : this.buttonsByValue.values()) {
            b.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void setValue(String value) {
        JRadioButton b = this.buttonsByValue.get(value);
        if (b != null) {
            b.setSelected(true);
        } else {
            LogUtils.severe("Can't set the value:" + value + " into the radio buttons " + this.getName() + " containing values " + this.possibleValues);
            if (!this.buttonsByValue.isEmpty()) {
                this.buttonsByValue.values().iterator().next().setSelected(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.firePropertyChangeEvent();
    }
}

