/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableColumnVisibilityChanger {
    private final TableColumnModel columnModel;
    private int[] originalColumnWidths;

    public TableColumnVisibilityChanger(TableColumnModel columnModel) {
        this.columnModel = columnModel;
    }

    public JMenu createMenu(String menuTitle) {
        JMenu menu = new JMenu(menuTitle);
        this.addMenuItems(menu);
        return menu;
    }

    public void addMenuItems(JMenu viewMenu) {
        int i = 0;
        while (i < this.columnModel.getColumnCount()) {
            TableColumn column = this.columnModel.getColumn(i);
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(column.getHeaderValue().toString(), this.isColumnVisible(i));
            int columnIndex = i++;
            menuItem.addActionListener(e -> {
                this.toggleColumnVisibility(columnIndex);
                menuItem.setSelected(column.getPreferredWidth() != 0);
            });
            viewMenu.add(menuItem);
        }
    }

    private void toggleColumnVisibility(int columnIndex) {
        this.setColumnVisible(columnIndex, !this.isColumnVisible(columnIndex));
    }

    public void setColumnVisible(int columnIndex, boolean becomesVisible) {
        if (becomesVisible == this.isColumnVisible(columnIndex)) {
            return;
        }
        TableColumn column = this.columnModel.getColumn(columnIndex);
        this.initializeColumnWidths();
        if (becomesVisible) {
            this.showColumn(columnIndex, column);
            this.originalColumnWidths[columnIndex] = 0;
        } else {
            this.originalColumnWidths[columnIndex] = column.getPreferredWidth();
            this.hideColumn(column);
        }
    }

    private void showColumn(int columnIndex, TableColumn column) {
        column.setMinWidth(15);
        column.setMaxWidth(Integer.MAX_VALUE);
        column.setPreferredWidth(this.originalColumnWidths[columnIndex]);
    }

    private void hideColumn(TableColumn column) {
        column.setMinWidth(0);
        column.setMaxWidth(0);
        column.setPreferredWidth(0);
    }

    private void initializeColumnWidths() {
        if (this.originalColumnWidths == null) {
            this.originalColumnWidths = new int[this.columnModel.getColumnCount()];
        }
    }

    public boolean isColumnVisible(int columnIndex) {
        return this.columnModel.getColumn(columnIndex).getPreferredWidth() > 0;
    }

    public String getState() {
        this.initializeColumnWidths();
        return IntStream.of(this.originalColumnWidths).mapToObj(Integer::toString).collect(Collectors.joining(","));
    }

    public void applyState(String state) {
        if (state == null || state.isEmpty()) {
            return;
        }
        String[] split = state.split(",");
        if (split == null || split.length != this.columnModel.getColumnCount()) {
            return;
        }
        this.originalColumnWidths = Stream.of(split).mapToInt(Integer::parseInt).toArray();
        for (int i = 0; i < this.originalColumnWidths.length; ++i) {
            if (this.originalColumnWidths[i] == 0) continue;
            this.hideColumn(this.columnModel.getColumn(i));
        }
    }
}

