/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.tree.jiter.MappingJavaIterator;

public class ExplicitCollection
extends AbstractResourceCollection {
    private List<Resource> resources;
    private SpaceStrippingRule whitespaceRules;

    public ExplicitCollection(Configuration config, String collectionURI, List<Resource> resources) {
        super(config);
        if (collectionURI == null) {
            throw new NullPointerException();
        }
        this.resources = resources;
        this.collectionURI = collectionURI;
    }

    @Override
    public boolean stripWhitespace(SpaceStrippingRule rules) {
        this.whitespaceRules = rules;
        return false;
    }

    @Override
    public Iterator<String> getResourceURIs(XPathContext context) {
        return new MappingJavaIterator<Resource, String>(this.resources.iterator(), r -> r.getResourceURI());
    }

    @Override
    public Iterator<? extends Resource> getResources(XPathContext context) {
        return this.resources.iterator();
    }
}

