/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.refresh.win32;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.WString;

public class Win32Natives {
    public static final long INVALID_HANDLE_VALUE = -1L;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_INVALID_HANDLE = 6;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int MAXIMUM_WAIT_OBJECTS = 64;
    public static final int WAIT_TIMEOUT = 258;
    public static final int WAIT_OBJECT_0 = 0;
    public static final int WAIT_ABANDONED_0 = 128;
    public static final int WAIT_FAILED = -1;
    public static final int FILE_NOTIFY_CHANGE_FILE_NAME = 1;
    public static final int FILE_NOTIFY_CHANGE_DIR_NAME = 2;
    public static final int FILE_NOTIFY_CHANGE_SIZE = 8;
    public static final int FILE_NOTIFY_CHANGE_LAST_WRITE = 16;
    private static final String LONG_PATH_PREFIX = "\\\\?\\";

    public static long FindFirstChangeNotification(String lpPathName, boolean bWatchSubtree, int dwNotifyFilter) {
        WString wPathName = WindowsH.fromString((String)(!lpPathName.startsWith(LONG_PATH_PREFIX) ? LONG_PATH_PREFIX + lpPathName : lpPathName));
        return WindowsH.FindFirstChangeNotificationW(wPathName, WindowsH.fromBoolean(bWatchSubtree), dwNotifyFilter);
    }

    public static boolean FindCloseChangeNotification(long hChangeHandle) {
        return WindowsH.toBoolean(WindowsH.FindCloseChangeNotification(hChangeHandle));
    }

    public static boolean FindNextChangeNotification(long hChangeHandle) {
        return WindowsH.toBoolean(WindowsH.FindNextChangeNotification(hChangeHandle));
    }

    public static int WaitForMultipleObjects(int nCount, long[] lpHandles, boolean bWaitAll, int dwMilliseconds) {
        return WindowsH.WaitForMultipleObjects(nCount, lpHandles, WindowsH.fromBoolean(bWaitAll), dwMilliseconds);
    }

    public static int GetLastError() {
        return Native.getLastError();
    }

    private static class WindowsH {
        static {
            Native.register((NativeLibrary)NativeLibrary.getInstance((String)"Kernel32"));
        }

        private WindowsH() {
        }

        static native long FindFirstChangeNotificationW(WString var0, int var1, int var2);

        static native int FindCloseChangeNotification(long var0);

        static native int FindNextChangeNotification(long var0);

        static native int WaitForMultipleObjects(int var0, long[] var1, int var2, int var3);

        static WString fromString(String value) {
            return new WString(value);
        }

        static int fromBoolean(boolean value) {
            return value ? 1 : 0;
        }

        static boolean toBoolean(int value) {
            return value != 0;
        }
    }
}

