﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock/Bedrock_EXPORTS.h>
#include <aws/bedrock/model/AutomatedReasoningPolicyScenario.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Bedrock {
namespace Model {

/**
 * <p>Contains a comprehensive entity encompassing all the scenarios generated by
 * the build workflow, which can be used to validate an Automated Reasoning
 * policy.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/AutomatedReasoningPolicyScenarios">AWS
 * API Reference</a></p>
 */
class AutomatedReasoningPolicyScenarios {
 public:
  AWS_BEDROCK_API AutomatedReasoningPolicyScenarios() = default;
  AWS_BEDROCK_API AutomatedReasoningPolicyScenarios(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCK_API AutomatedReasoningPolicyScenarios& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCK_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Represents a collection of generated policy scenarios.</p>
   */
  inline const Aws::Vector<AutomatedReasoningPolicyScenario>& GetPolicyScenarios() const { return m_policyScenarios; }
  inline bool PolicyScenariosHasBeenSet() const { return m_policyScenariosHasBeenSet; }
  template <typename PolicyScenariosT = Aws::Vector<AutomatedReasoningPolicyScenario>>
  void SetPolicyScenarios(PolicyScenariosT&& value) {
    m_policyScenariosHasBeenSet = true;
    m_policyScenarios = std::forward<PolicyScenariosT>(value);
  }
  template <typename PolicyScenariosT = Aws::Vector<AutomatedReasoningPolicyScenario>>
  AutomatedReasoningPolicyScenarios& WithPolicyScenarios(PolicyScenariosT&& value) {
    SetPolicyScenarios(std::forward<PolicyScenariosT>(value));
    return *this;
  }
  template <typename PolicyScenariosT = AutomatedReasoningPolicyScenario>
  AutomatedReasoningPolicyScenarios& AddPolicyScenarios(PolicyScenariosT&& value) {
    m_policyScenariosHasBeenSet = true;
    m_policyScenarios.emplace_back(std::forward<PolicyScenariosT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<AutomatedReasoningPolicyScenario> m_policyScenarios;
  bool m_policyScenariosHasBeenSet = false;
};

}  // namespace Model
}  // namespace Bedrock
}  // namespace Aws
