﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/application-autoscaling/ApplicationAutoScaling_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ApplicationAutoScaling {
namespace Model {

/**
 * <p>Represents a CloudWatch alarm associated with a scaling policy.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/Alarm">AWS
 * API Reference</a></p>
 */
class Alarm {
 public:
  AWS_APPLICATIONAUTOSCALING_API Alarm() = default;
  AWS_APPLICATIONAUTOSCALING_API Alarm(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPLICATIONAUTOSCALING_API Alarm& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPLICATIONAUTOSCALING_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the alarm.</p>
   */
  inline const Aws::String& GetAlarmName() const { return m_alarmName; }
  inline bool AlarmNameHasBeenSet() const { return m_alarmNameHasBeenSet; }
  template <typename AlarmNameT = Aws::String>
  void SetAlarmName(AlarmNameT&& value) {
    m_alarmNameHasBeenSet = true;
    m_alarmName = std::forward<AlarmNameT>(value);
  }
  template <typename AlarmNameT = Aws::String>
  Alarm& WithAlarmName(AlarmNameT&& value) {
    SetAlarmName(std::forward<AlarmNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the alarm.</p>
   */
  inline const Aws::String& GetAlarmARN() const { return m_alarmARN; }
  inline bool AlarmARNHasBeenSet() const { return m_alarmARNHasBeenSet; }
  template <typename AlarmARNT = Aws::String>
  void SetAlarmARN(AlarmARNT&& value) {
    m_alarmARNHasBeenSet = true;
    m_alarmARN = std::forward<AlarmARNT>(value);
  }
  template <typename AlarmARNT = Aws::String>
  Alarm& WithAlarmARN(AlarmARNT&& value) {
    SetAlarmARN(std::forward<AlarmARNT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_alarmName;

  Aws::String m_alarmARN;
  bool m_alarmNameHasBeenSet = false;
  bool m_alarmARNHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationAutoScaling
}  // namespace Aws
