/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.segments;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.Region;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.decoder.arithmetic.ArithmeticDecoder;
import org.apache.pdfbox.jbig2.decoder.arithmetic.ArithmeticIntegerDecoder;
import org.apache.pdfbox.jbig2.decoder.arithmetic.CX;
import org.apache.pdfbox.jbig2.decoder.huffman.EncodedTable;
import org.apache.pdfbox.jbig2.decoder.huffman.FixedSizeTable;
import org.apache.pdfbox.jbig2.decoder.huffman.HuffmanTable;
import org.apache.pdfbox.jbig2.decoder.huffman.StandardTables;
import org.apache.pdfbox.jbig2.err.IntegerMaxValueException;
import org.apache.pdfbox.jbig2.err.InvalidHeaderValueException;
import org.apache.pdfbox.jbig2.image.Bitmaps;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.segments.GenericRefinementRegion;
import org.apache.pdfbox.jbig2.segments.RegionSegmentInformation;
import org.apache.pdfbox.jbig2.segments.SymbolDictionary;
import org.apache.pdfbox.jbig2.segments.Table;
import org.apache.pdfbox.jbig2.util.CombinationOperator;

public class TextRegion
implements Region {
    private SubInputStream subInputStream;
    private RegionSegmentInformation regionInfo;
    private short sbrTemplate;
    private short sbdsOffset;
    private short defaultPixel;
    private CombinationOperator combinationOperator;
    private short isTransposed;
    private short referenceCorner;
    private short logSBStrips;
    private boolean useRefinement;
    private boolean isHuffmanEncoded;
    private short sbHuffRSize;
    private short sbHuffRDY;
    private short sbHuffRDX;
    private short sbHuffRDHeight;
    private short sbHuffRDWidth;
    private short sbHuffDT;
    private short sbHuffDS;
    private short sbHuffFS;
    private short[] sbrATX;
    private short[] sbrATY;
    private long amountOfSymbolInstances;
    private long currentS;
    private int sbStrips;
    private int amountOfSymbols;
    private Bitmap regionBitmap;
    private ArrayList<Bitmap> symbols = new ArrayList();
    private ArithmeticDecoder arithmeticDecoder;
    private ArithmeticIntegerDecoder integerDecoder;
    private GenericRefinementRegion genericRefinementRegion;
    private CX cxIADT;
    private CX cxIAFS;
    private CX cxIADS;
    private CX cxIAIT;
    private CX cxIARI;
    private CX cxIARDW;
    private CX cxIARDH;
    private CX cxIAID;
    private CX cxIARDX;
    private CX cxIARDY;
    private CX cx;
    private int symbolCodeLength;
    private FixedSizeTable symbolCodeTable;
    private SegmentHeader segmentHeader;
    private HuffmanTable fsTable;
    private HuffmanTable dsTable;
    private HuffmanTable table;
    private HuffmanTable rdwTable;
    private HuffmanTable rdhTable;
    private HuffmanTable rdxTable;
    private HuffmanTable rdyTable;
    private HuffmanTable rSizeTable;

    public TextRegion() {
    }

    public TextRegion(SubInputStream subInputStream, SegmentHeader segmentHeader) {
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
        this.segmentHeader = segmentHeader;
    }

    private void parseHeader() throws IOException, InvalidHeaderValueException, IntegerMaxValueException {
        this.regionInfo.parseHeader();
        this.readRegionFlags();
        if (this.isHuffmanEncoded) {
            this.readHuffmanFlags();
        }
        this.readUseRefinement();
        this.readAmountOfSymbolInstances();
        this.getSymbols();
        this.computeSymbolCodeLength();
        this.checkInput();
    }

    private void readRegionFlags() throws IOException {
        this.sbrTemplate = (short)this.subInputStream.readBit();
        this.sbdsOffset = (short)this.subInputStream.readBits(5);
        if (this.sbdsOffset > 15) {
            this.sbdsOffset = (short)(this.sbdsOffset - 32);
        }
        this.defaultPixel = (short)this.subInputStream.readBit();
        this.combinationOperator = CombinationOperator.translateOperatorCodeToEnum((short)(this.subInputStream.readBits(2) & 3L));
        this.isTransposed = (short)this.subInputStream.readBit();
        this.referenceCorner = (short)(this.subInputStream.readBits(2) & 3L);
        this.logSBStrips = (short)(this.subInputStream.readBits(2) & 3L);
        this.sbStrips = 1 << this.logSBStrips;
        if (this.subInputStream.readBit() == 1) {
            this.useRefinement = true;
        }
        if (this.subInputStream.readBit() == 1) {
            this.isHuffmanEncoded = true;
        }
    }

    private void readHuffmanFlags() throws IOException {
        this.subInputStream.readBit();
        this.sbHuffRSize = (short)this.subInputStream.readBit();
        this.sbHuffRDY = (short)(this.subInputStream.readBits(2) & 0xFL);
        this.sbHuffRDX = (short)(this.subInputStream.readBits(2) & 0xFL);
        this.sbHuffRDHeight = (short)(this.subInputStream.readBits(2) & 0xFL);
        this.sbHuffRDWidth = (short)(this.subInputStream.readBits(2) & 0xFL);
        this.sbHuffDT = (short)(this.subInputStream.readBits(2) & 0xFL);
        this.sbHuffDS = (short)(this.subInputStream.readBits(2) & 0xFL);
        this.sbHuffFS = (short)(this.subInputStream.readBits(2) & 0xFL);
    }

    private void readUseRefinement() throws IOException {
        if (this.useRefinement && this.sbrTemplate == 0) {
            this.sbrATX = new short[2];
            this.sbrATY = new short[2];
            this.sbrATX[0] = this.subInputStream.readByte();
            this.sbrATY[0] = this.subInputStream.readByte();
            this.sbrATX[1] = this.subInputStream.readByte();
            this.sbrATY[1] = this.subInputStream.readByte();
        }
    }

    private void readAmountOfSymbolInstances() throws IOException {
        this.amountOfSymbolInstances = this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL;
        long l = (long)this.regionInfo.getBitmapWidth() * (long)this.regionInfo.getBitmapHeight();
        if (l < this.amountOfSymbolInstances) {
            this.amountOfSymbolInstances = l;
        }
    }

    private void getSymbols() throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        if (this.segmentHeader.getRtSegments() != null) {
            this.initSymbols();
        }
    }

    private void computeSymbolCodeLength() throws IOException {
        if (this.isHuffmanEncoded) {
            this.symbolIDCodeLengths();
        } else {
            this.symbolCodeLength = (int)Math.ceil(Math.log(this.amountOfSymbols) / Math.log(2.0));
        }
    }

    private void checkInput() throws InvalidHeaderValueException {
        if (!this.useRefinement && this.sbrTemplate != 0) {
            this.sbrTemplate = 0;
        }
        if (this.sbHuffFS == 2 || this.sbHuffRDWidth == 2 || this.sbHuffRDHeight == 2 || this.sbHuffRDX == 2 || this.sbHuffRDY == 2) {
            throw new InvalidHeaderValueException("Huffman flag value of text region segment is not permitted");
        }
        if (!this.useRefinement) {
            if (this.sbHuffRSize != 0) {
                this.sbHuffRSize = 0;
            }
            if (this.sbHuffRDY != 0) {
                this.sbHuffRDY = 0;
            }
            if (this.sbHuffRDX != 0) {
                this.sbHuffRDX = 0;
            }
            if (this.sbHuffRDWidth != 0) {
                this.sbHuffRDWidth = 0;
            }
            if (this.sbHuffRDHeight != 0) {
                this.sbHuffRDHeight = 0;
            }
        }
    }

    @Override
    public Bitmap getRegionBitmap() throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        if (!this.isHuffmanEncoded) {
            this.setCodingStatistics();
        }
        this.createRegionBitmap();
        this.decodeSymbolInstances();
        return this.regionBitmap;
    }

    private void setCodingStatistics() throws IOException {
        if (this.cxIADT == null) {
            this.cxIADT = new CX(512, 1);
        }
        if (this.cxIAFS == null) {
            this.cxIAFS = new CX(512, 1);
        }
        if (this.cxIADS == null) {
            this.cxIADS = new CX(512, 1);
        }
        if (this.cxIAIT == null) {
            this.cxIAIT = new CX(512, 1);
        }
        if (this.cxIARI == null) {
            this.cxIARI = new CX(512, 1);
        }
        if (this.cxIARDW == null) {
            this.cxIARDW = new CX(512, 1);
        }
        if (this.cxIARDH == null) {
            this.cxIARDH = new CX(512, 1);
        }
        if (this.cxIAID == null) {
            this.cxIAID = new CX(1 << this.symbolCodeLength, 1);
        }
        if (this.cxIARDX == null) {
            this.cxIARDX = new CX(512, 1);
        }
        if (this.cxIARDY == null) {
            this.cxIARDY = new CX(512, 1);
        }
        if (this.arithmeticDecoder == null) {
            this.arithmeticDecoder = new ArithmeticDecoder(this.subInputStream);
        }
        if (this.integerDecoder == null) {
            this.integerDecoder = new ArithmeticIntegerDecoder(this.arithmeticDecoder);
        }
    }

    private void createRegionBitmap() {
        int n = this.regionInfo.getBitmapWidth();
        int n2 = this.regionInfo.getBitmapHeight();
        this.regionBitmap = new Bitmap(n, n2);
        if (this.defaultPixel != 0) {
            this.regionBitmap.fillBitmap((byte)-1);
        }
    }

    private final long decodeStripT() throws IOException, InvalidHeaderValueException {
        long l = 0L;
        if (this.isHuffmanEncoded) {
            if (this.sbHuffDT == 3) {
                if (this.table == null) {
                    int n = 0;
                    if (this.sbHuffFS == 3) {
                        ++n;
                    }
                    if (this.sbHuffDS == 3) {
                        ++n;
                    }
                    this.table = this.getUserTable(n);
                }
                l = this.table.decode(this.subInputStream);
            } else {
                l = StandardTables.getTable(11 + this.sbHuffDT).decode(this.subInputStream);
            }
        } else {
            l = this.integerDecoder.decode(this.cxIADT);
        }
        return l * (long)(-this.sbStrips);
    }

    private void decodeSymbolInstances() throws IOException, InvalidHeaderValueException, IntegerMaxValueException {
        long l = this.decodeStripT();
        long l2 = 0L;
        long l3 = 0L;
        block0: while (l3 < this.amountOfSymbolInstances) {
            long l4 = this.decodeDT();
            l += l4;
            long l5 = 0L;
            boolean bl = true;
            this.currentS = 0L;
            while (true) {
                long l6;
                if (bl) {
                    l5 = this.decodeDfS();
                    this.currentS = l2 += l5;
                    bl = false;
                } else {
                    l6 = this.decodeIdS();
                    if (l6 == Long.MAX_VALUE || l3 >= this.amountOfSymbolInstances) continue block0;
                    this.currentS += l6 + (long)this.sbdsOffset;
                }
                l6 = this.decodeCurrentT();
                long l7 = l + l6;
                long l8 = this.decodeID();
                long l9 = this.decodeRI();
                Bitmap bitmap = this.decodeIb(l9, l8);
                this.blit(bitmap, l7);
                ++l3;
            }
        }
    }

    private final long decodeDT() throws IOException {
        long l = this.isHuffmanEncoded ? (this.sbHuffDT == 3 ? this.table.decode(this.subInputStream) : StandardTables.getTable(11 + this.sbHuffDT).decode(this.subInputStream)) : this.integerDecoder.decode(this.cxIADT);
        return l * (long)this.sbStrips;
    }

    private final long decodeDfS() throws IOException, InvalidHeaderValueException {
        if (this.isHuffmanEncoded) {
            if (this.sbHuffFS == 3) {
                if (this.fsTable == null) {
                    this.fsTable = this.getUserTable(0);
                }
                return this.fsTable.decode(this.subInputStream);
            }
            return StandardTables.getTable(6 + this.sbHuffFS).decode(this.subInputStream);
        }
        return this.integerDecoder.decode(this.cxIAFS);
    }

    private final long decodeIdS() throws IOException, InvalidHeaderValueException {
        if (this.isHuffmanEncoded) {
            if (this.sbHuffDS == 3) {
                if (this.dsTable == null) {
                    int n = 0;
                    if (this.sbHuffFS == 3) {
                        ++n;
                    }
                    this.dsTable = this.getUserTable(n);
                }
                return this.dsTable.decode(this.subInputStream);
            }
            return StandardTables.getTable(8 + this.sbHuffDS).decode(this.subInputStream);
        }
        return this.integerDecoder.decode(this.cxIADS);
    }

    private final long decodeCurrentT() throws IOException {
        if (this.sbStrips != 1) {
            if (this.isHuffmanEncoded) {
                return this.subInputStream.readBits(this.logSBStrips);
            }
            return this.integerDecoder.decode(this.cxIAIT);
        }
        return 0L;
    }

    private final long decodeID() throws IOException {
        if (this.isHuffmanEncoded) {
            if (this.symbolCodeTable == null) {
                return this.subInputStream.readBits(this.symbolCodeLength);
            }
            return this.symbolCodeTable.decode(this.subInputStream);
        }
        return this.integerDecoder.decodeIAID(this.cxIAID, this.symbolCodeLength);
    }

    private final long decodeRI() throws IOException {
        if (this.useRefinement) {
            if (this.isHuffmanEncoded) {
                return this.subInputStream.readBit();
            }
            return this.integerDecoder.decode(this.cxIARI);
        }
        return 0L;
    }

    private final Bitmap decodeIb(long l, long l2) throws IOException, InvalidHeaderValueException, IntegerMaxValueException {
        Bitmap bitmap;
        if (l == 0L) {
            bitmap = this.symbols.get((int)l2);
        } else {
            long l3 = this.decodeRdw();
            long l4 = this.decodeRdh();
            long l5 = this.decodeRdx();
            long l6 = this.decodeRdy();
            if (this.isHuffmanEncoded) {
                this.decodeSymInRefSize();
                this.subInputStream.skipBits();
            }
            Bitmap bitmap2 = this.symbols.get((int)l2);
            int n = bitmap2.getWidth();
            int n2 = bitmap2.getHeight();
            int n3 = (int)((l3 >> 1) + l5);
            int n4 = (int)((l4 >> 1) + l6);
            if (this.genericRefinementRegion == null) {
                this.genericRefinementRegion = new GenericRefinementRegion(this.subInputStream);
            }
            this.genericRefinementRegion.setParameters(this.cx, this.arithmeticDecoder, this.sbrTemplate, (int)((long)n + l3), (int)((long)n2 + l4), bitmap2, n3, n4, false, this.sbrATX, this.sbrATY);
            bitmap = this.genericRefinementRegion.getRegionBitmap();
            if (this.isHuffmanEncoded) {
                this.subInputStream.skipBits();
            }
        }
        return bitmap;
    }

    private final long decodeRdw() throws IOException, InvalidHeaderValueException {
        if (this.isHuffmanEncoded) {
            if (this.sbHuffRDWidth == 3) {
                if (this.rdwTable == null) {
                    int n = 0;
                    if (this.sbHuffFS == 3) {
                        ++n;
                    }
                    if (this.sbHuffDS == 3) {
                        ++n;
                    }
                    if (this.sbHuffDT == 3) {
                        ++n;
                    }
                    this.rdwTable = this.getUserTable(n);
                }
                return this.rdwTable.decode(this.subInputStream);
            }
            return StandardTables.getTable(14 + this.sbHuffRDWidth).decode(this.subInputStream);
        }
        return this.integerDecoder.decode(this.cxIARDW);
    }

    private final long decodeRdh() throws IOException, InvalidHeaderValueException {
        if (this.isHuffmanEncoded) {
            if (this.sbHuffRDHeight == 3) {
                if (this.rdhTable == null) {
                    int n = 0;
                    if (this.sbHuffFS == 3) {
                        ++n;
                    }
                    if (this.sbHuffDS == 3) {
                        ++n;
                    }
                    if (this.sbHuffDT == 3) {
                        ++n;
                    }
                    if (this.sbHuffRDWidth == 3) {
                        ++n;
                    }
                    this.rdhTable = this.getUserTable(n);
                }
                return this.rdhTable.decode(this.subInputStream);
            }
            return StandardTables.getTable(14 + this.sbHuffRDHeight).decode(this.subInputStream);
        }
        return this.integerDecoder.decode(this.cxIARDH);
    }

    private final long decodeRdx() throws IOException, InvalidHeaderValueException {
        if (this.isHuffmanEncoded) {
            if (this.sbHuffRDX == 3) {
                if (this.rdxTable == null) {
                    int n = 0;
                    if (this.sbHuffFS == 3) {
                        ++n;
                    }
                    if (this.sbHuffDS == 3) {
                        ++n;
                    }
                    if (this.sbHuffDT == 3) {
                        ++n;
                    }
                    if (this.sbHuffRDWidth == 3) {
                        ++n;
                    }
                    if (this.sbHuffRDHeight == 3) {
                        ++n;
                    }
                    this.rdxTable = this.getUserTable(n);
                }
                return this.rdxTable.decode(this.subInputStream);
            }
            return StandardTables.getTable(14 + this.sbHuffRDX).decode(this.subInputStream);
        }
        return this.integerDecoder.decode(this.cxIARDX);
    }

    private final long decodeRdy() throws IOException, InvalidHeaderValueException {
        if (this.isHuffmanEncoded) {
            if (this.sbHuffRDY == 3) {
                if (this.rdyTable == null) {
                    int n = 0;
                    if (this.sbHuffFS == 3) {
                        ++n;
                    }
                    if (this.sbHuffDS == 3) {
                        ++n;
                    }
                    if (this.sbHuffDT == 3) {
                        ++n;
                    }
                    if (this.sbHuffRDWidth == 3) {
                        ++n;
                    }
                    if (this.sbHuffRDHeight == 3) {
                        ++n;
                    }
                    if (this.sbHuffRDX == 3) {
                        ++n;
                    }
                    this.rdyTable = this.getUserTable(n);
                }
                return this.rdyTable.decode(this.subInputStream);
            }
            return StandardTables.getTable(14 + this.sbHuffRDY).decode(this.subInputStream);
        }
        return this.integerDecoder.decode(this.cxIARDY);
    }

    private final long decodeSymInRefSize() throws IOException, InvalidHeaderValueException {
        if (this.sbHuffRSize == 0) {
            return StandardTables.getTable(1).decode(this.subInputStream);
        }
        if (this.rSizeTable == null) {
            int n = 0;
            if (this.sbHuffFS == 3) {
                ++n;
            }
            if (this.sbHuffDS == 3) {
                ++n;
            }
            if (this.sbHuffDT == 3) {
                ++n;
            }
            if (this.sbHuffRDWidth == 3) {
                ++n;
            }
            if (this.sbHuffRDHeight == 3) {
                ++n;
            }
            if (this.sbHuffRDX == 3) {
                ++n;
            }
            if (this.sbHuffRDY == 3) {
                ++n;
            }
            this.rSizeTable = this.getUserTable(n);
        }
        return this.rSizeTable.decode(this.subInputStream);
    }

    private final void blit(Bitmap bitmap, long l) {
        if (this.isTransposed == 0 && (this.referenceCorner == 2 || this.referenceCorner == 3)) {
            this.currentS += (long)(bitmap.getWidth() - 1);
        } else if (this.isTransposed == 1 && (this.referenceCorner == 0 || this.referenceCorner == 2)) {
            this.currentS += (long)(bitmap.getHeight() - 1);
        }
        long l2 = this.currentS;
        if (this.isTransposed == 1) {
            long l3 = l;
            l = l2;
            l2 = l3;
        }
        if (this.referenceCorner != 1) {
            if (this.referenceCorner == 0) {
                l -= (long)(bitmap.getHeight() - 1);
            } else if (this.referenceCorner == 2) {
                l -= (long)(bitmap.getHeight() - 1);
                l2 -= (long)(bitmap.getWidth() - 1);
            } else if (this.referenceCorner == 3) {
                l2 -= (long)(bitmap.getWidth() - 1);
            }
        }
        Bitmaps.blit(bitmap, this.regionBitmap, (int)l2, (int)l, this.combinationOperator);
        if (this.isTransposed == 0 && (this.referenceCorner == 0 || this.referenceCorner == 1)) {
            this.currentS += (long)(bitmap.getWidth() - 1);
        }
        if (this.isTransposed == 1 && (this.referenceCorner == 1 || this.referenceCorner == 3)) {
            this.currentS += (long)(bitmap.getHeight() - 1);
        }
    }

    private void initSymbols() throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        for (SegmentHeader segmentHeader : this.segmentHeader.getRtSegments()) {
            if (segmentHeader.getSegmentType() != 0) continue;
            SymbolDictionary symbolDictionary = (SymbolDictionary)segmentHeader.getSegmentData();
            symbolDictionary.cxIAID = this.cxIAID;
            this.symbols.addAll(symbolDictionary.getDictionary());
        }
        this.amountOfSymbols = this.symbols.size();
    }

    private HuffmanTable getUserTable(int n) throws InvalidHeaderValueException, IOException {
        int n2 = 0;
        for (SegmentHeader segmentHeader : this.segmentHeader.getRtSegments()) {
            if (segmentHeader.getSegmentType() != 53) continue;
            if (n2 == n) {
                Table table = (Table)segmentHeader.getSegmentData();
                return new EncodedTable(table);
            }
            ++n2;
        }
        return null;
    }

    private void symbolIDCodeLengths() throws IOException {
        ArrayList<HuffmanTable.Code> arrayList = new ArrayList<HuffmanTable.Code>();
        for (int i = 0; i < 35; ++i) {
            int n = (int)(this.subInputStream.readBits(4) & 0xFL);
            if (n <= 0) continue;
            arrayList.add(new HuffmanTable.Code(n, 0, i, false));
        }
        FixedSizeTable fixedSizeTable = new FixedSizeTable(arrayList);
        long l = 0L;
        int n = 0;
        ArrayList<HuffmanTable.Code> arrayList2 = new ArrayList<HuffmanTable.Code>();
        while (n < this.amountOfSymbols) {
            long l2 = fixedSizeTable.decode(this.subInputStream);
            if (l2 < 32L) {
                if (l2 > 0L) {
                    arrayList2.add(new HuffmanTable.Code((int)l2, 0, n, false));
                }
                l = l2;
                ++n;
                continue;
            }
            long l3 = 0L;
            long l4 = 0L;
            if (l2 == 32L) {
                l3 = 3L + this.subInputStream.readBits(2);
                if (n > 0) {
                    l4 = l;
                }
            } else if (l2 == 33L) {
                l3 = 3L + this.subInputStream.readBits(3);
            } else if (l2 == 34L) {
                l3 = 11L + this.subInputStream.readBits(7);
            }
            int n2 = 0;
            while ((long)n2 < l3) {
                if (l4 > 0L) {
                    arrayList2.add(new HuffmanTable.Code((int)l4, 0, n, false));
                }
                ++n;
                ++n2;
            }
        }
        this.subInputStream.skipBits();
        this.symbolCodeTable = new FixedSizeTable(arrayList2);
    }

    @Override
    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws InvalidHeaderValueException, IntegerMaxValueException, IOException {
        this.segmentHeader = segmentHeader;
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(this.subInputStream);
        this.parseHeader();
    }

    protected void setContexts(CX cX, CX cX2, CX cX3, CX cX4, CX cX5, CX cX6, CX cX7, CX cX8, CX cX9, CX cX10) {
        this.cx = cX;
        this.cxIADT = cX2;
        this.cxIAFS = cX3;
        this.cxIADS = cX4;
        this.cxIAIT = cX5;
        this.cxIAID = cX6;
        this.cxIARDW = cX7;
        this.cxIARDH = cX8;
        this.cxIARDX = cX9;
        this.cxIARDY = cX10;
    }

    protected void setParameters(ArithmeticDecoder arithmeticDecoder, ArithmeticIntegerDecoder arithmeticIntegerDecoder, boolean bl, boolean bl2, int n, int n2, long l, int n3, int n4, short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9, short s10, short s11, short s12, short s13, short s14, short[] sArray, short[] sArray2, ArrayList<Bitmap> arrayList, int n5) {
        this.arithmeticDecoder = arithmeticDecoder;
        this.integerDecoder = arithmeticIntegerDecoder;
        this.isHuffmanEncoded = bl;
        this.useRefinement = bl2;
        this.regionInfo.setBitmapWidth(n);
        this.regionInfo.setBitmapHeight(n2);
        this.amountOfSymbolInstances = l;
        this.sbStrips = n3;
        this.amountOfSymbols = n4;
        this.defaultPixel = s;
        this.combinationOperator = CombinationOperator.translateOperatorCodeToEnum(s2);
        this.isTransposed = s3;
        this.referenceCorner = s4;
        this.sbdsOffset = s5;
        this.sbHuffFS = s6;
        this.sbHuffDS = s7;
        this.sbHuffDT = s8;
        this.sbHuffRDWidth = s9;
        this.sbHuffRDHeight = s10;
        this.sbHuffRDX = s11;
        this.sbHuffRDY = s12;
        this.sbHuffRSize = s13;
        this.sbrTemplate = s14;
        this.sbrATX = sArray;
        this.sbrATY = sArray2;
        this.symbols = arrayList;
        this.symbolCodeLength = n5;
    }

    @Override
    public RegionSegmentInformation getRegionInfo() {
        return this.regionInfo;
    }
}

