/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version11;

import java.sql.SQLException;
import java.util.function.Function;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ng.AbstractFbBlob;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.wire.AbstractFbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.version10.V10OutputBlob;

public class V11OutputBlob
extends V10OutputBlob {
    public V11OutputBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer) throws SQLException {
        super(database, transaction, blobParameterBuffer);
    }

    @Override
    public void open() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobClosed();
            this.clearDeferredException();
            if (this.getBlobId() != 0L) {
                throw FbExceptionBuilder.toNonTransientException(335544368);
            }
            this.setHandle(65535);
            this.setState(AbstractFbBlob.BlobState.DELAYED_OPEN);
            this.resetEof();
        }
    }

    @Override
    protected void checkBlobOpen() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            super.checkBlobOpen();
            if (this.getState() == AbstractFbBlob.BlobState.DELAYED_OPEN) {
                this.setState(AbstractFbBlob.BlobState.PENDING_OPEN);
                this.sendOpen(AbstractFbWireBlob.BlobOpenOperation.OUTPUT_BLOB, false);
                this.getDatabase().enqueueDeferredAction(this.wrapDeferredResponse(new DeferredResponse<Response>(){

                    @Override
                    public void onResponse(Response response) {
                        if (response instanceof GenericResponse) {
                            GenericResponse genericResponse = (GenericResponse)response;
                            try {
                                V11OutputBlob.this.processOpenResponse(genericResponse);
                            }
                            catch (SQLException e) {
                                V11OutputBlob.this.registerDeferredException(e);
                            }
                        } else {
                            System.getLogger(this.getClass().getName()).log(System.Logger.Level.DEBUG, "Expected response of type GenericResponse for blob create, but received a {0}", response != null ? response.getClass().getName() : "(null)");
                        }
                    }
                }, Function.identity()));
            }
        }
    }
}

