/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.style.ConcatIterator;
import net.sourceforge.plantuml.style.MergeStrategy;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleKey;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class StyleStorage {
    private final Map<StyleSignatureBasic, Style> legacy = new LinkedHashMap<StyleSignatureBasic, Style>();
    private final Map<StyleKey, Style> plain = new LinkedHashMap<StyleKey, Style>();

    public void printMe() {
        for (Map.Entry<StyleSignatureBasic, Style> ent : this.legacy.entrySet()) {
            ent.getValue().printMe();
        }
    }

    public void putAll(StyleStorage other) {
        this.legacy.putAll(other.legacy);
        this.plain.putAll(other.plain);
    }

    public Style get(StyleSignatureBasic signature) {
        if (signature.getStereotypes().size() == 0) {
            return this.plain.get(signature.getKey());
        }
        return this.legacy.get(signature);
    }

    public void put(Style modifiedStyle) {
        StyleSignatureBasic signature = modifiedStyle.getSignature();
        if (signature.getStereotypes().size() == 0) {
            this.plain.put(signature.getKey(), modifiedStyle);
        } else {
            this.legacy.put(signature, modifiedStyle);
        }
    }

    public Collection<Style> getStyles() {
        return new AbstractCollection<Style>(){

            @Override
            public Iterator<Style> iterator() {
                return new ConcatIterator<Style>(StyleStorage.this.legacy.values().iterator(), StyleStorage.this.plain.values().iterator());
            }

            @Override
            public int size() {
                return StyleStorage.this.legacy.size() + StyleStorage.this.plain.size();
            }
        };
    }

    public Style computeMergedStyle(StyleSignatureBasic signature) {
        Style mergedStyle = null;
        for (Style style : this.getStyles()) {
            StyleSignatureBasic key = style.getSignature();
            if (!key.matchAll(signature)) continue;
            if (mergedStyle == null) {
                mergedStyle = style;
                continue;
            }
            mergedStyle = mergedStyle.mergeWith(style, MergeStrategy.OVERWRITE_EXISTING_VALUE);
        }
        return mergedStyle;
    }
}

