/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.props;

import java.io.Reader;
import java.util.Properties;
import java.util.Set;
import org.ldaptive.ConnectionFactoryManager;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.BindAuthenticationHandler;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.PooledConnectionFactoryManager;
import org.ldaptive.props.AbstractPropertySource;
import org.ldaptive.props.AuthenticatorPropertyInvoker;
import org.ldaptive.props.BindAuthenticationHandlerPropertySource;
import org.ldaptive.props.DefaultConnectionFactoryPropertySource;
import org.ldaptive.props.PooledConnectionFactoryPropertySource;
import org.ldaptive.props.PropertySource;
import org.ldaptive.props.SearchDnResolverPropertySource;
import org.ldaptive.props.SimplePropertySource;

public final class AuthenticatorPropertySource
extends AbstractPropertySource<Authenticator> {
    private static final AuthenticatorPropertyInvoker INVOKER = new AuthenticatorPropertyInvoker(Authenticator.class);

    public AuthenticatorPropertySource(Authenticator a) {
        this(a, "classpath:/org/ldaptive/ldap.properties");
    }

    public AuthenticatorPropertySource(Authenticator a, String ... paths) {
        this(a, AuthenticatorPropertySource.loadProperties(paths));
    }

    public AuthenticatorPropertySource(Authenticator a, Reader ... readers) {
        this(a, AuthenticatorPropertySource.loadProperties(readers));
    }

    public AuthenticatorPropertySource(Authenticator a, Properties props) {
        this(a, PropertySource.PropertyDomain.AUTH, props);
    }

    public AuthenticatorPropertySource(Authenticator a, PropertySource.PropertyDomain domain, Properties props) {
        super(a, domain, props);
    }

    @Override
    public void initialize() {
        Object cfm;
        AuthenticationHandler authHandler;
        Object cfm2;
        this.initializeObject(INVOKER);
        DnResolver dnResolver = ((Authenticator)this.object).getDnResolver();
        if (dnResolver == null) {
            dnResolver = new SearchDnResolver();
            SearchDnResolverPropertySource dnPropSource = new SearchDnResolverPropertySource((SearchDnResolver)dnResolver, this.propertiesDomain, this.properties);
            dnPropSource.initialize();
            ((Authenticator)this.object).setDnResolver(dnResolver);
        } else {
            SimplePropertySource<DnResolver> sPropSource = new SimplePropertySource<DnResolver>(dnResolver, this.propertiesDomain, this.properties);
            sPropSource.initialize();
        }
        if (dnResolver instanceof PooledConnectionFactoryManager && (cfm2 = (PooledConnectionFactoryManager)((Object)dnResolver)).getConnectionFactory() == null) {
            this.initPooledConnectionFactoryManager((PooledConnectionFactoryManager)cfm2);
        }
        if (dnResolver instanceof ConnectionFactoryManager && (cfm2 = (ConnectionFactoryManager)((Object)dnResolver)).getConnectionFactory() == null) {
            this.initConnectionFactoryManager((ConnectionFactoryManager)cfm2);
        }
        if ((authHandler = ((Authenticator)this.object).getAuthenticationHandler()) == null) {
            authHandler = new BindAuthenticationHandler();
            BindAuthenticationHandlerPropertySource ahPropSource = new BindAuthenticationHandlerPropertySource((BindAuthenticationHandler)authHandler, this.propertiesDomain, this.properties);
            ahPropSource.initialize();
            ((Authenticator)this.object).setAuthenticationHandler(authHandler);
        } else {
            SimplePropertySource<AuthenticationHandler> sPropSource = new SimplePropertySource<AuthenticationHandler>(authHandler, this.propertiesDomain, this.properties);
            sPropSource.initialize();
        }
        if (authHandler instanceof PooledConnectionFactoryManager && (cfm = (PooledConnectionFactoryManager)((Object)authHandler)).getConnectionFactory() == null) {
            this.initPooledConnectionFactoryManager((PooledConnectionFactoryManager)cfm);
        }
        if (authHandler instanceof ConnectionFactoryManager && (cfm = (ConnectionFactoryManager)((Object)authHandler)).getConnectionFactory() == null) {
            this.initConnectionFactoryManager((ConnectionFactoryManager)cfm);
        }
    }

    private void initConnectionFactoryManager(ConnectionFactoryManager cfm) {
        DefaultConnectionFactory cf = new DefaultConnectionFactory();
        DefaultConnectionFactoryPropertySource cfPropSource = new DefaultConnectionFactoryPropertySource(cf, this.propertiesDomain, this.properties);
        cfPropSource.initialize();
        cfm.setConnectionFactory(cf);
    }

    private void initPooledConnectionFactoryManager(PooledConnectionFactoryManager cfm) {
        PooledConnectionFactory cf = new PooledConnectionFactory();
        PooledConnectionFactoryPropertySource cfPropSource = new PooledConnectionFactoryPropertySource(cf, this.propertiesDomain, this.properties);
        cfPropSource.initialize();
        cfm.setConnectionFactory(cf);
    }

    public static Set<String> getProperties() {
        return INVOKER.getProperties();
    }
}

