/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.processors.field;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.tribuo.data.columnar.ColumnarFeature;
import org.tribuo.data.columnar.FieldProcessor;

public class DoubleFieldProcessor
implements FieldProcessor {
    private static final Logger logger = Logger.getLogger(DoubleFieldProcessor.class.getName());
    @Config(mandatory=true, description="The field name to read.")
    private String fieldName;
    @Config(description="Emit a feature using just the field name.")
    private boolean onlyFieldName;
    @Config(description="Throw NumberFormatException if the value failed to parse.")
    private boolean throwOnInvalid;

    private DoubleFieldProcessor() {
    }

    public DoubleFieldProcessor(String fieldName) {
        this(fieldName, false);
    }

    public DoubleFieldProcessor(String fieldName, boolean onlyFieldName) {
        this(fieldName, onlyFieldName, false);
    }

    public DoubleFieldProcessor(String fieldName, boolean onlyFieldName, boolean throwOnInvalid) {
        this.fieldName = fieldName;
        this.onlyFieldName = onlyFieldName;
        this.throwOnInvalid = throwOnInvalid;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<ColumnarFeature> process(String value) {
        try {
            double parsedValue = Double.parseDouble(value);
            if (this.onlyFieldName) {
                return Collections.singletonList(new ColumnarFeature(this.fieldName, parsedValue));
            }
            return Collections.singletonList(new ColumnarFeature(this.fieldName, "value", parsedValue));
        }
        catch (NumberFormatException ex) {
            if (this.throwOnInvalid) {
                throw ex;
            }
            if (!value.trim().isEmpty()) {
                logger.warning(String.format("Non-double value %s in %s", value, this.fieldName));
            }
            return Collections.emptyList();
        }
    }

    @Override
    public FieldProcessor.GeneratedFeatureType getFeatureType() {
        return FieldProcessor.GeneratedFeatureType.REAL;
    }

    @Override
    public DoubleFieldProcessor copy(String newFieldName) {
        return new DoubleFieldProcessor(newFieldName, this.onlyFieldName, this.throwOnInvalid);
    }

    public String toString() {
        return "DoubleFieldProcessor(fieldName=" + this.getFieldName() + ",onlyFieldName=" + this.onlyFieldName + ",throwOnInvalid=" + this.throwOnInvalid + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FieldProcessor");
    }
}

