/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import lombok.Generated;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;

public abstract class Parameter<T> {
    private final String name;
    private final T defaultValue;
    protected BiFunction<T, KNNMethodConfigContext, Boolean> validator;

    public Parameter(String name, T defaultValue, BiFunction<T, KNNMethodConfigContext, Boolean> validator) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.validator = validator;
    }

    public abstract ValidationException validate(Object var1, KNNMethodConfigContext var2);

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public static class MethodComponentContextParameter
    extends Parameter<MethodComponentContext> {
        private final Map<String, MethodComponent> methodComponents;

        public MethodComponentContextParameter(String name, MethodComponentContext defaultValue, Map<String, MethodComponent> methodComponents) {
            super(name, defaultValue, (T methodComponentContext, KNNMethodConfigContext knnMethodConfigContext) -> {
                if (!methodComponents.containsKey(methodComponentContext.getName())) {
                    return false;
                }
                return ((MethodComponent)methodComponents.get(methodComponentContext.getName())).validate((MethodComponentContext)methodComponentContext, (KNNMethodConfigContext)knnMethodConfigContext) == null;
            });
            this.methodComponents = methodComponents;
        }

        @Override
        public ValidationException validate(Object value, KNNMethodConfigContext knnMethodConfigContext) {
            ValidationException validationException = null;
            if (!(value instanceof MethodComponentContext)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("value is not an instance of for MethodComponentContext parameter [%s].", this.getName()));
                return validationException;
            }
            if (!((Boolean)this.validator.apply((MethodComponentContext)value, knnMethodConfigContext)).booleanValue()) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("parameter validation failed for MethodComponentContext parameter [%s].", this.getName()));
            }
            return validationException;
        }

        public MethodComponent getMethodComponent(String name) {
            return this.methodComponents.get(name);
        }
    }

    public static class StringParameter
    extends Parameter<String> {
        public StringParameter(String name, String defaultValue, BiFunction<String, KNNMethodConfigContext, Boolean> validator) {
            super(name, defaultValue, validator);
        }

        @Override
        public ValidationException validate(Object value, KNNMethodConfigContext knnMethodConfigContext) {
            ValidationException validationException = null;
            if (!(value instanceof String)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("value is not an instance of String for String parameter [%s].", this.getName()));
                return validationException;
            }
            if (!((Boolean)this.validator.apply((String)value, knnMethodConfigContext)).booleanValue()) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("parameter validation failed for String parameter [%s].", this.getName()));
            }
            return validationException;
        }
    }

    public static class DoubleParameter
    extends Parameter<Double> {
        public DoubleParameter(String name, Double defaultValue, BiFunction<Double, KNNMethodConfigContext, Boolean> validator) {
            super(name, defaultValue, validator);
        }

        @Override
        public ValidationException validate(Object value, KNNMethodConfigContext knnMethodConfigContext) {
            if (Objects.isNull(value)) {
                String validationErrorMsg = String.format(Locale.ROOT, "Null value provided for Double parameter \"%s\".", this.getName());
                return this.getValidationException(validationErrorMsg);
            }
            if (value.equals(0)) {
                value = 0.0;
            }
            if (!(value instanceof Double)) {
                String validationErrorMsg = String.format(Locale.ROOT, "value is not an instance of Double for Double parameter [%s].", this.getName());
                return this.getValidationException(validationErrorMsg);
            }
            if (!((Boolean)this.validator.apply((Double)value, knnMethodConfigContext)).booleanValue()) {
                String validationErrorMsg = String.format(Locale.ROOT, "parameter validation failed for Double parameter [%s].", this.getName());
                return this.getValidationException(validationErrorMsg);
            }
            return null;
        }

        private ValidationException getValidationException(String validationErrorMsg) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError(validationErrorMsg);
            return validationException;
        }
    }

    public static class IntegerParameter
    extends Parameter<Integer> {
        public IntegerParameter(String name, Integer defaultValue, BiFunction<Integer, KNNMethodConfigContext, Boolean> validator) {
            super(name, defaultValue, validator);
        }

        @Override
        public ValidationException validate(Object value, KNNMethodConfigContext knnMethodConfigContext) {
            ValidationException validationException = null;
            if (!(value instanceof Integer)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("value is not an instance of Integer for Integer parameter [%s].", this.getName()));
                return validationException;
            }
            if (!((Boolean)this.validator.apply((Integer)value, knnMethodConfigContext)).booleanValue()) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("parameter validation failed for Integer parameter [%s].", this.getName()));
            }
            return validationException;
        }
    }

    public static class BooleanParameter
    extends Parameter<Boolean> {
        public BooleanParameter(String name, Boolean defaultValue, BiFunction<Boolean, KNNMethodConfigContext, Boolean> validator) {
            super(name, defaultValue, validator);
        }

        @Override
        public ValidationException validate(Object value, KNNMethodConfigContext knnMethodConfigContext) {
            ValidationException validationException = null;
            if (!(value instanceof Boolean)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("value is not an instance of Boolean for Boolean parameter [%s].", this.getName()));
                return validationException;
            }
            if (!((Boolean)this.validator.apply((Boolean)value, knnMethodConfigContext)).booleanValue()) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("parameter validation failed for Boolean parameter [%s].", this.getName()));
            }
            return validationException;
        }
    }
}

