/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Apply a colormap to the contours (outlines) of each object in a label
map and superimpose it on top of the feature image.


The feature image is typically the image from which the labeling was
produced. Use the SetInput function to set the LabelMap , and the SetFeatureImage function to set the feature image.

Apply a colormap to a label map and put it on top of the input image.
The set of colors is a good selection of distinct colors. The opacity
of the label map can be defined by the user. A background label
produce a gray pixel with the same intensity than the input one.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


See:
 LabelMapOverlayImageFilter , LabelOverlayImageFilter , LabelOverlayFunctor

 LabelMapToBinaryImageFilter , LabelMapToLabelImageFilter ,

 itk::simple::LabelMapContourOverlay for the procedural interface

 itk::LabelMapContourOverlayImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelMapContourOverlayImageFilter.h
*/
public class LabelMapContourOverlayImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelMapContourOverlayImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelMapContourOverlayImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelMapContourOverlayImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelMapContourOverlayImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelMapContourOverlayImageFilter::~LabelMapContourOverlayImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelMapContourOverlayImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelMapContourOverlayImageFilter::LabelMapContourOverlayImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelMapContourOverlayImageFilter() {
    this(SimpleITKJNI.new_LabelMapContourOverlayImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelMapContourOverlayImageFilter::SetOpacity(double Opacity)

Set/Get the opacity of the colored label image. The value must be
between 0 and 1

*/
public  void setOpacity(double Opacity) {
    SimpleITKJNI.LabelMapContourOverlayImageFilter_setOpacity(swigCPtr, this, Opacity);
  }

  /**
double itk::simple::LabelMapContourOverlayImageFilter::GetOpacity() const

Set/Get the opacity of the colored label image. The value must be
between 0 and 1

*/
public  double getOpacity() {
    return SimpleITKJNI.LabelMapContourOverlayImageFilter_getOpacity(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelMapContourOverlayImageFilter::SetDilationRadius(unsigned int value)

Set the values of the DilationRadius vector all to value

*/
public  void setDilationRadius(VectorUInt32 DilationRadius) {
    SimpleITKJNI.LabelMapContourOverlayImageFilter_setDilationRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(DilationRadius), DilationRadius);
  }

  /**
Self&amp; itk::simple::LabelMapContourOverlayImageFilter::SetDilationRadius(unsigned int value)

Set the values of the DilationRadius vector all to value

*/
public  void setDilationRadius(long value) {
    SimpleITKJNI.LabelMapContourOverlayImageFilter_setDilationRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::LabelMapContourOverlayImageFilter::GetDilationRadius() const

Set/Get the object dilation radius - 0 by default.

*/
public  VectorUInt32 getDilationRadius() {
    return new VectorUInt32(SimpleITKJNI.LabelMapContourOverlayImageFilter_getDilationRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::LabelMapContourOverlayImageFilter::SetContourThickness(std::vector&lt; unsigned int &gt; ContourThickness)

Set/Get the contour thickness - 1 by default.

*/
public  void setContourThickness(VectorUInt32 ContourThickness) {
    SimpleITKJNI.LabelMapContourOverlayImageFilter_setContourThickness(swigCPtr, this, VectorUInt32.getCPtr(ContourThickness), ContourThickness);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::LabelMapContourOverlayImageFilter::GetContourThickness() const

Set/Get the contour thickness - 1 by default.

*/
public  VectorUInt32 getContourThickness() {
    return new VectorUInt32(SimpleITKJNI.LabelMapContourOverlayImageFilter_getContourThickness(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::LabelMapContourOverlayImageFilter::SetSliceDimension(unsigned int SliceDimension)

Set/Get the slice dimension - defaults to image dimension - 1.

*/
public  void setSliceDimension(long SliceDimension) {
    SimpleITKJNI.LabelMapContourOverlayImageFilter_setSliceDimension(swigCPtr, this, SliceDimension);
  }

  /**
unsigned int itk::simple::LabelMapContourOverlayImageFilter::GetSliceDimension() const

Set/Get the slice dimension - defaults to image dimension - 1.

*/
public  long getSliceDimension() {
    return SimpleITKJNI.LabelMapContourOverlayImageFilter_getSliceDimension(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelMapContourOverlayImageFilter::SetContourType(ContourTypeType ContourType)

Set/Get the overlay type - CONTOUR is used by default.

*/
public  void setContourType(LabelMapContourOverlayImageFilter.ContourTypeType ContourType) {
    SimpleITKJNI.LabelMapContourOverlayImageFilter_setContourType(swigCPtr, this, ContourType.swigValue());
  }

  /**
ContourTypeType itk::simple::LabelMapContourOverlayImageFilter::GetContourType() const

Set/Get the overlay type - CONTOUR is used by default.

*/
public  LabelMapContourOverlayImageFilter.ContourTypeType getContourType() {
    return LabelMapContourOverlayImageFilter.ContourTypeType.swigToEnum(SimpleITKJNI.LabelMapContourOverlayImageFilter_getContourType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::LabelMapContourOverlayImageFilter::SetPriority(PriorityType Priority)

Set/Get the object priority - HIGH_LABEL_ON_TOP by default.

*/
public  void setPriority(LabelMapContourOverlayImageFilter.PriorityType Priority) {
    SimpleITKJNI.LabelMapContourOverlayImageFilter_setPriority(swigCPtr, this, Priority.swigValue());
  }

  /**
PriorityType itk::simple::LabelMapContourOverlayImageFilter::GetPriority() const

Set/Get the object priority - HIGH_LABEL_ON_TOP by default.

*/
public  LabelMapContourOverlayImageFilter.PriorityType getPriority() {
    return LabelMapContourOverlayImageFilter.PriorityType.swigToEnum(SimpleITKJNI.LabelMapContourOverlayImageFilter_getPriority(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::LabelMapContourOverlayImageFilter::SetColormap(std::vector&lt; uint8_t &gt; Colormap)
*/
public  void setColormap(VectorUInt8 Colormap) {
    SimpleITKJNI.LabelMapContourOverlayImageFilter_setColormap(swigCPtr, this, VectorUInt8.getCPtr(Colormap), Colormap);
  }

  /**
std::vector&lt;uint8_t&gt; itk::simple::LabelMapContourOverlayImageFilter::GetColormap() const
*/
public  VectorUInt8 getColormap() {
    return new VectorUInt8(SimpleITKJNI.LabelMapContourOverlayImageFilter_getColormap(swigCPtr, this), true);
  }

  /**
std::string itk::simple::LabelMapContourOverlayImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelMapContourOverlayImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelMapContourOverlayImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelMapContourOverlayImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LabelMapContourOverlayImageFilter::Execute(const Image &amp;labelMapImage, const Image &amp;featureImage)

Execute the filter on the input image

*/
public  Image execute(Image labelMapImage, Image featureImage) {
    return new Image(SimpleITKJNI.LabelMapContourOverlayImageFilter_execute(swigCPtr, this, Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public final static class ContourTypeType {
    public final static LabelMapContourOverlayImageFilter.ContourTypeType PLAIN = new LabelMapContourOverlayImageFilter.ContourTypeType("PLAIN");
    public final static LabelMapContourOverlayImageFilter.ContourTypeType CONTOUR = new LabelMapContourOverlayImageFilter.ContourTypeType("CONTOUR");
    public final static LabelMapContourOverlayImageFilter.ContourTypeType SLICE_CONTOUR = new LabelMapContourOverlayImageFilter.ContourTypeType("SLICE_CONTOUR");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static ContourTypeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + ContourTypeType.class + " with value " + swigValue);
    }

    private ContourTypeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private ContourTypeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private ContourTypeType(String swigName, ContourTypeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static ContourTypeType[] swigValues = { PLAIN, CONTOUR, SLICE_CONTOUR };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

  public final static class PriorityType {
    public final static LabelMapContourOverlayImageFilter.PriorityType HIGH_LABEL_ON_TOP = new LabelMapContourOverlayImageFilter.PriorityType("HIGH_LABEL_ON_TOP");
    public final static LabelMapContourOverlayImageFilter.PriorityType LOW_LABEL_ON_TOP = new LabelMapContourOverlayImageFilter.PriorityType("LOW_LABEL_ON_TOP");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static PriorityType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + PriorityType.class + " with value " + swigValue);
    }

    private PriorityType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private PriorityType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private PriorityType(String swigName, PriorityType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static PriorityType[] swigValues = { HIGH_LABEL_ON_TOP, LOW_LABEL_ON_TOP };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
