/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.history.ActivityId;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.LoadingCommittedChangeListPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsImplUtil;
import git4idea.GitActivity;
import git4idea.GitCommit;
import git4idea.GitStashUsageCollector;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashUtils;
import git4idea.stash.UnstashConflictResolver;
import git4idea.stash.ui.GitStashUIHandler;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0005H\u0007JF\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0007J2\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0007JL\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00190!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u0005H\u0007J \u0010(\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J2\u0010)\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020$0#H\u0007J$\u0010,\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010.\u001a\u00020\u0005J+\u0010/\u001a\u00070\u001d\u00a2\u0006\u0002\b02\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010.\u001a\u00020\u0005H\u0002J#\u00101\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0000\u00a2\u0006\u0002\b2\u00a8\u00063"}, d2={"Lgit4idea/stash/GitStashOperations;", "", "<init>", "()V", "dropStashWithConfirmation", "", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "stash", "Lgit4idea/ui/StashInfo;", "clearStashesWithConfirmation", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "viewStash", "", "compareWithLocal", "loadStashChanges", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vcs/changes/Change;", "", "Lgit4idea/GitCommit;", "hash", "Lcom/intellij/vcs/log/Hash;", "parentHashes", "unstash", "branch", "", "popStash", "reinstateIndex", "rootAndRevisions", "", "handlerProvider", "Lkotlin/Function1;", "Lgit4idea/commands/GitLineHandler;", "conflictResolver", "Lgit4idea/merge/GitConflictResolver;", "reportToLocalHistory", "refreshUnstashedChanges", "runStashInBackground", "roots", "createHandler", "showSuccessNotification", "successfulRoots", "hasErrors", "getSuccessMessage", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "getRootsText", "getRootsText$intellij_vcs_git", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStashUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashUtils.kt\ngit4idea/stash/GitStashOperations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,454:1\n1563#2:455\n1634#2,3:456\n1374#2:459\n1460#2,5:460\n30#3,2:465\n37#4:467\n36#4,3:468\n*S KotlinDebug\n*F\n+ 1 GitStashUtils.kt\ngit4idea/stash/GitStashOperations\n*L\n145#1:455\n145#1:456,3\n247#1:459\n247#1:460,5\n292#1:465,2\n294#1:467\n294#1:468,3\n*E\n"})
public final class GitStashOperations {
    @NotNull
    public static final GitStashOperations INSTANCE = new GitStashOperations();

    private GitStashOperations() {
    }

    @JvmStatic
    public static final boolean dropStashWithConfirmation(@NotNull Project project, @Nullable Component parentComponent, @NotNull StashInfo stash) {
        boolean confirmed;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        Object[] objectArray = new Object[]{stash.getStash()};
        String string = GitBundle.message("unstash.drop.confirmation.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray = new Object[]{stash.getStash(), stash.getMessage()};
        String string2 = GitBundle.message("unstash.drop.confirmation.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        MessageDialogBuilder.YesNo dialogBuilder = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(Messages.getQuestionIcon());
        Component component2 = parentComponent;
        boolean bl = confirmed = component2 != null ? dialogBuilder.ask(component2) : dialogBuilder.ask(project);
        if (!confirmed) {
            return false;
        }
        GitLineHandler h = new GitLineHandler(project, stash.getRoot(), GitCommand.STASH);
        Object[] objectArray2 = new String[]{"drop", stash.getStash()};
        h.addParameters((String[])objectArray2);
        try {
            objectArray2 = new Object[]{stash.getStash()};
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitStashOperations.dropStashWithConfirmation$lambda$0(h), GitBundle.message("unstash.dialog.remove.stash.progress.indicator.title", objectArray2), true, project);
            return true;
        }
        catch (VcsException ex) {
            GitUIUtil.showOperationError(project, ex, h.printableCommandLine());
            return false;
        }
    }

    @JvmStatic
    public static final boolean clearStashesWithConfirmation(@NotNull Project project, @NotNull VirtualFile root, @Nullable Component parentComponent) {
        boolean confirmed;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        String string = GitBundle.message("unstash.clear.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = GitBundle.message("unstash.clear.confirmation.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        MessageDialogBuilder.YesNo dialogBuilder = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(Messages.getWarningIcon());
        Component component2 = parentComponent;
        boolean bl = confirmed = component2 != null ? dialogBuilder.ask(component2) : dialogBuilder.ask(project);
        if (!confirmed) {
            return false;
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.STASH);
        String[] stringArray = new String[]{"clear"};
        h.addParameters(stringArray);
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitStashOperations.clearStashesWithConfirmation$lambda$1(h, project, root), GitBundle.message("unstash.clearing.stashes", new Object[0]), false, project);
            return true;
        }
        catch (VcsException ex) {
            GitUIUtil.showOperationError(project, ex, h.printableCommandLine());
            return false;
        }
    }

    @JvmStatic
    public static final void viewStash(@NotNull Project project, @NotNull StashInfo stash, boolean compareWithLocal) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        LoadingCommittedChangeListPanel panel2 = new LoadingCommittedChangeListPanel(project);
        panel2.loadChangesInBackground(() -> GitStashOperations.viewStash$lambda$2(project, stash, compareWithLocal));
        Object[] objectArray = new Object[]{stash.getStash()};
        ChangeListViewerDialog.show((Project)project, (String)GitBundle.message("unstash.view.dialog.title", objectArray), (LoadingCommittedChangeListPanel)panel2, null, (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public final Pair<Collection<Change>, List<GitCommit>> loadStashChanges(@NotNull Project project, @NotNull VirtualFile root, @NotNull Hash hash, @NotNull List<? extends Hash> parentHashes) throws VcsException {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter(parentHashes, (String)"parentHashes");
        List stashCommits = new ArrayList();
        Object[] objectArray = (Object[])parentHashes;
        Collection collection2 = CollectionsKt.listOf((Object)hash.asString());
        VirtualFile virtualFile = root;
        Project project2 = project;
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Hash hash2 = (Hash)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        collection = (List)destination$iv$iv;
        GitLogUtil.readFullDetailsForHashes(project2, virtualFile, CollectionsKt.plus((Collection)collection2, (Iterable)collection), new GitCommitRequirements(true, null, GitCommitRequirements.DiffInMergeCommits.FIRST_PARENT, 2, null), (Consumer<? super GitCommit>)((Consumer)arg_0 -> GitStashOperations.loadStashChanges$lambda$4(stashCommits, arg_0)));
        if (stashCommits.isEmpty()) {
            objectArray = new Object[]{root.getName(), hash.asString()};
            throw new VcsException(GitBundle.message("stash.load.changes.error", objectArray));
        }
        return new Pair((Object)((GitCommit)((Object)CollectionsKt.first((List)stashCommits))).getChanges(0), (Object)CollectionsKt.drop((Iterable)stashCommits, (int)1));
    }

    @JvmStatic
    public static final boolean unstash(@NotNull Project project, @NotNull StashInfo stash, @Nullable String branch, boolean popStash, boolean reinstateIndex) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        Boolean completed = (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitStashOperations.unstash$lambda$6(project, stash, branch, popStash, reinstateIndex), GitBundle.message("unstash.unstashing", new Object[0]), true, project);
        if (!completed.booleanValue()) {
            return false;
        }
        VcsNotifier.getInstance((Project)project).notifySuccess("git.unstash.patch.applied", "", GitBundle.message("unstash.stash.applied", new Object[0]));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final boolean unstash(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Hash> rootAndRevisions, @NotNull Function1<? super VirtualFile, ? extends GitLineHandler> handlerProvider, @NotNull GitConflictResolver conflictResolver, boolean reportToLocalHistory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(rootAndRevisions, (String)"rootAndRevisions");
        Intrinsics.checkNotNullParameter(handlerProvider, (String)"handlerProvider");
        Intrinsics.checkNotNullParameter((Object)conflictResolver, (String)"conflictResolver");
        AutoCloseable autoCloseable = (AutoCloseable)DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitBundle.message("activity.name.unstash", new Object[0]), (ActivityId)(reportToLocalHistory ? GitActivity.INSTANCE.getUnstash() : null));
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            for (Map.Entry<VirtualFile, ? extends Hash> entry : rootAndRevisions.entrySet()) {
                GitCommandResult result2;
                Object object;
                VirtualFile root = entry.getKey();
                Hash hash = entry.getValue();
                GitLineHandler handler = (GitLineHandler)handlerProvider.invoke((Object)root);
                GitSimpleEventDetector indexConflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.INDEX_CONFLICT_ON_UNSTASH);
                GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT_ON_UNSTASH);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                handler.addLineListener(indexConflictDetector);
                handler.addLineListener(conflictDetector);
                handler.addLineListener(untrackedFilesDetector);
                handler.addLineListener(localChangesDetector);
                StructuredIdeActivity activity = GitStashUsageCollector.logStashPop(project);
                Intrinsics.checkNotNullExpressionValue((Object)Git.getInstance().runCommand(handler), (String)"runCommand(...)");
                StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
                if (hash != null) {
                    INSTANCE.refreshUnstashedChanges(project, hash, root);
                }
                if ((object = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(root)) != null && (object = object.getRepositoryFiles()) != null) {
                    ((GitRepositoryFiles)object).refreshIndexFile();
                }
                if (indexConflictDetector.isDetected()) {
                    VcsNotifier.getInstance((Project)project).notifyError("git.unstash.failed", GitBundle.message("notification.title.unstash.failed.index.conflict", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
                    boolean bl2 = false;
                    return bl2;
                }
                if (conflictDetector.isDetected()) {
                    boolean bl3 = conflictResolver.merge();
                    return bl3;
                }
                if (untrackedFilesDetector.isDetected()) {
                    GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, root, (Collection<String>)untrackedFilesDetector.getRelativeFilePaths(), GitBundle.message("unstash.operation.name", new Object[0]), null);
                    boolean bl4 = false;
                    return bl4;
                }
                if (localChangesDetector.isDetected()) {
                    LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, "git.stash.local.changes.detected", root, GitBundle.message("unstash.operation.name", new Object[0]), (Collection<String>)localChangesDetector.getRelativeFilePaths());
                    boolean bl5 = false;
                    return bl5;
                }
                if (result2.success()) continue;
                VcsNotifier.getInstance((Project)project).notifyError("git.unstash.failed", GitBundle.message("notification.title.unstash.failed", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
                boolean bl6 = false;
                return bl6;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return true;
    }

    public static /* synthetic */ boolean unstash$default(Project project, Map map2, Function1 function1, GitConflictResolver gitConflictResolver, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return GitStashOperations.unstash(project, map2, (Function1<? super VirtualFile, ? extends GitLineHandler>)function1, gitConflictResolver, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshUnstashedChanges(Project project, Hash hash, VirtualFile root) {
        try {
            void $this$flatMapTo$iv$iv;
            CollectConsumer consumer = new CollectConsumer();
            GitLogUtil.readFullDetailsForHashes(project, root, CollectionsKt.listOf((Object)hash.asString()), new GitCommitRequirements(false, GitCommitRequirements.DiffRenames.NoRenames.INSTANCE, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS), (Consumer<? super GitCommit>)((Consumer)consumer));
            Collection collection = consumer.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResult(...)");
            GitCommit stashCommit = (GitCommit)((Object)CollectionsKt.first((Iterable)collection));
            Iterable $this$flatMap$iv = (Iterable)RangesKt.until((int)0, (int)stashCommit.getParents().size());
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv$iv;
                int it = element$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Collection collection2 = stashCommit.getChanges(it);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getChanges(...)");
                Iterable list$iv$iv = collection2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List changesInStash = (List)destination$iv$iv;
            GitUtil.refreshVfs(root, changesInStash);
        }
        catch (Exception e) {
            GitStashUtils.access$getLOG$p().warn("Couldn't load changes in root [" + root + "] in stash resolved to [" + hash + "]", (Throwable)e);
        }
    }

    @JvmStatic
    public static final void runStashInBackground(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots, @NotNull Function1<? super VirtualFile, ? extends GitLineHandler> createHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter(createHandler, (String)"createHandler");
        String string = GitBundle.message("stashing.progress.title", new Object[0]);
        new Task.Backgroundable(project, roots, createHandler, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection<VirtualFile> $roots;
            final /* synthetic */ Function1<VirtualFile, GitLineHandler> $createHandler;
            {
                this.$project = $project;
                this.$roots = $roots;
                this.$createHandler = $createHandler;
                super($project, $super_call_param$1, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                AutoCloseable autoCloseable = (AutoCloseable)DvcsUtil.workingTreeChangeStarted((Project)this.$project, (String)GitBundle.message("activity.name.stash", new Object[0]), (ActivityId)GitActivity.Stash);
                Collection<VirtualFile> collection = this.$roots;
                Project project = this.$project;
                Function1<VirtualFile, GitLineHandler> function1 = this.$createHandler;
                Throwable throwable = null;
                try {
                    Iterable result2;
                    AccessToken cfr_ignored_0 = (AccessToken)autoCloseable;
                    boolean bl = false;
                    LinkedHashSet<VirtualFile> successfulRoots = new LinkedHashSet<VirtualFile>();
                    LinkedHashMap<K, V> failedRoots = new LinkedHashMap<K, V>();
                    for (VirtualFile root : collection) {
                        StructuredIdeActivity activity = GitStashUsageCollector.logStashPush(project);
                        Intrinsics.checkNotNullExpressionValue((Object)Git.getInstance().runCommand((GitLineHandler)function1.invoke((Object)root)), (String)"runCommand(...)");
                        StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
                        if (((GitCommandResult)((Object)result2)).success()) {
                            successfulRoots.add(root);
                            continue;
                        }
                        ((Map)failedRoots).put(root, ((GitCommandResult)((Object)result2)).getErrorOutputAsHtmlString());
                    }
                    if (!successfulRoots.isEmpty()) {
                        GitUtil.refreshVfsInRoots((Collection<VirtualFile>)successfulRoots);
                        GitStashOperations.INSTANCE.showSuccessNotification(project, (Collection<? extends VirtualFile>)successfulRoots, !((Map)failedRoots).isEmpty());
                    }
                    if (!failedRoots.isEmpty()) {
                        Collection<HtmlChunk> collection2;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object object = new Object[1];
                        Set<K> set = failedRoots.keySet();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
                        object[0] = GitStashOperations.INSTANCE.getRootsText$intellij_vcs_git(project, (Collection<? extends VirtualFile>)set);
                        String string = GitBundle.message("stash.error", object);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        String errorTitle = string;
                        HtmlBuilder htmlBuilder = new HtmlBuilder();
                        HtmlChunk htmlChunk = (HtmlChunk)HtmlChunk.br();
                        Collection<V> collection3 = failedRoots.values();
                        Intrinsics.checkNotNullExpressionValue(collection3, (String)"<get-values>(...)");
                        result2 = collection3;
                        HtmlChunk htmlChunk2 = htmlChunk;
                        HtmlBuilder htmlBuilder2 = htmlBuilder;
                        boolean $i$f$map = false;
                        void var18_19 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string2 = (String)item$iv$iv;
                            collection2 = destination$iv$iv;
                            boolean bl2 = false;
                            collection2.add(HtmlChunk.raw((String)it));
                        }
                        collection2 = (List)destination$iv$iv;
                        object = htmlBuilder2.appendWithSeparators(htmlChunk2, (Iterable)collection2).toString();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toString(...)");
                        Object errorMessage = object;
                        VcsNotifier.getInstance((Project)project).notifyError("git.stash.failed", errorTitle, (String)errorMessage, true);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
        }.queue();
    }

    public final void showSuccessNotification(@NotNull Project project, @NotNull Collection<? extends VirtualFile> successfulRoots, boolean hasErrors) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(successfulRoots, (String)"successfulRoots");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitStashUIHandler> serviceClass$iv = GitStashUIHandler.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        List<NotificationAction> actions2 = ((GitStashUIHandler)object).showStashesNotificationActions(successfulRoots);
        String message = this.getSuccessMessage(project, successfulRoots, hasErrors);
        Collection $this$toTypedArray$iv = actions2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        NotificationAction[] notificationActionArray = thisCollection$iv.toArray(new NotificationAction[0]);
        VcsNotifier.getInstance((Project)project).notifyMinorInfo("git.stash.successful", "", message, Arrays.copyOf(notificationActionArray, notificationActionArray.length));
    }

    private final String getSuccessMessage(Project project, Collection<? extends VirtualFile> successfulRoots, boolean hasErrors) {
        if (!hasErrors) {
            String string = GitBundle.message("stash.files.success", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String rootsText = this.getRootsText$intellij_vcs_git(project, successfulRoots);
        Object[] objectArray = new Object[]{rootsText};
        String string = GitBundle.message("stash.files.in.roots.success", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public final String getRootsText$intellij_vcs_git(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        String rootsText = CollectionsKt.joinToString$default((Iterable)roots, (CharSequence)", ", null, null, (int)0, null, arg_0 -> GitStashOperations.getRootsText$lambda$9(project, arg_0), (int)30, null);
        String string = StringUtil.shortenTextWithEllipsis((String)rootsText, (int)100, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        return string;
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean unstash(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Hash> rootAndRevisions, @NotNull Function1<? super VirtualFile, ? extends GitLineHandler> handlerProvider, @NotNull GitConflictResolver conflictResolver) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(rootAndRevisions, (String)"rootAndRevisions");
        Intrinsics.checkNotNullParameter(handlerProvider, (String)"handlerProvider");
        Intrinsics.checkNotNullParameter((Object)conflictResolver, (String)"conflictResolver");
        return GitStashOperations.unstash$default(project, rootAndRevisions, handlerProvider, conflictResolver, false, 16, null);
    }

    private static final Unit dropStashWithConfirmation$lambda$0(GitLineHandler $h) {
        Git.getInstance().runCommand($h).throwOnError(new int[0]);
        return Unit.INSTANCE;
    }

    private static final Unit clearStashesWithConfirmation$lambda$1(GitLineHandler $h, Project $project, VirtualFile $root) {
        Git.getInstance().runCommand($h).throwOnError(new int[0]);
        GitStashUtils.refreshStash($project, $root);
        return Unit.INSTANCE;
    }

    private static final LoadingCommittedChangeListPanel.ChangelistData viewStash$lambda$2(Project $project, StashInfo $stash, boolean $compareWithLocal) {
        GitCommittedChangeList changes = GitChangeUtils.getRevisionChanges($project, GitUtil.getRootForFile($project, $stash.getRoot()), $stash.getHash().asString(), true, $compareWithLocal, false);
        return new LoadingCommittedChangeListPanel.ChangelistData((CommittedChangeList)changes, null);
    }

    private static final void loadStashChanges$lambda$4(List $stashCommits, GitCommit it) {
        Intrinsics.checkNotNull((Object)((Object)it));
        $stashCommits.add(it);
    }

    private static final GitLineHandler unstash$lambda$6$lambda$5(Project $project, StashInfo $stash, String $branch, boolean $popStash, boolean $reinstateIndex, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GitStashUtils.access$createUnstashHandler($project, $stash, $branch, $popStash, $reinstateIndex);
    }

    private static final Boolean unstash$lambda$6(Project $project, StashInfo $stash, String $branch, boolean $popStash, boolean $reinstateIndex) {
        return GitStashOperations.unstash$default($project, MapsKt.mapOf((Pair)new Pair((Object)$stash.getRoot(), (Object)$stash.getHash())), arg_0 -> GitStashOperations.unstash$lambda$6$lambda$5($project, $stash, $branch, $popStash, $reinstateIndex, arg_0), new UnstashConflictResolver($project, $stash), false, 16, null);
    }

    private static final CharSequence getRootsText$lambda$9(Project $project, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + VcsImplUtil.getShortVcsRootName((Project)$project, (VirtualFile)it) + "'";
    }
}

