/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.bc;

import java.util.Date;
import org.bouncycastle.openpgp.api.OpenPGPV6KeyGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcAEADSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcCFBSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPairGeneratorProvider;

public class BcOpenPGPV6KeyGenerator
extends OpenPGPV6KeyGenerator {
    public BcOpenPGPV6KeyGenerator() {
        this(new Date());
    }

    public BcOpenPGPV6KeyGenerator(Date date) {
        this(14, date, true);
    }

    public BcOpenPGPV6KeyGenerator(int n) {
        this(n, new Date(), true);
    }

    public BcOpenPGPV6KeyGenerator(int n, Date date, boolean bl) {
        super(new BcPGPKeyPairGeneratorProvider(), new BcPGPContentSignerBuilderProvider(n), new BcPGPDigestCalculatorProvider(), BcOpenPGPV6KeyGenerator.keyEncryptorFactory(bl), new BcKeyFingerprintCalculator(), date);
    }

    private static PBESecretKeyEncryptorFactory keyEncryptorFactory(boolean bl) {
        if (bl) {
            return new BcAEADSecretKeyEncryptorFactory();
        }
        return new BcCFBSecretKeyEncryptorFactory();
    }
}

