/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ReflectionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b'\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0017\u001a\u00020\rH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixActionBase;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "", "element", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getElement", "()Lcom/intellij/psi/PsiElement;", "isCrossLanguageFix", "", "()Z", "isAvailableImpl", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "startInWriteAction", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "clone", "", "kotlin.code-insight.api"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nQuickFixActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuickFixActionBase.kt\norg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixActionBase\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,99:1\n73#2:100\n*S KotlinDebug\n*F\n+ 1 QuickFixActionBase.kt\norg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixActionBase\n*L\n39#1:100\n*E\n"})
public abstract class QuickFixActionBase<T extends PsiElement>
implements IntentionAction,
Cloneable {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiElementPointer<T> elementPointer;
    private final boolean isCrossLanguageFix;

    public QuickFixActionBase(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.elementPointer = SmartPointersKt.createSmartPointer(element);
    }

    @Nullable
    public final T getElement() {
        return (T)this.elementPointer.getElement();
    }

    public boolean isCrossLanguageFix() {
        return this.isCrossLanguageFix;
    }

    protected boolean isAvailableImpl(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            CreateByPatternKt.setCREATE_BY_PATTERN_MAY_NOT_REFORMAT((boolean)true);
        }
        try {
            T t;
            if (this.getElement() == null) {
                boolean bl = false;
                return bl;
            }
            T element = t;
            boolean bl = element.isValid() && !element.getProject().isDisposed() && (file.getManager().isInProject((PsiElement)file) || file instanceof KtCodeFragment || file instanceof KtFile && ((KtFile)file).isScript()) && (file instanceof KtFile || this.isCrossLanguageFix()) && this.isAvailableImpl(project, editor, file);
            return bl;
        }
        finally {
            CreateByPatternKt.setCREATE_BY_PATTERN_MAY_NOT_REFORMAT((boolean)false);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        QuickFixActionBase quickFixActionBase;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (super.getFileModifierForPreview(target) != this) {
            return null;
        }
        T oldElement = this.getElement();
        if (oldElement == null) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)IntentionPreviewUtils.getOriginalFile((PsiFile)target), (Object)oldElement.getContainingFile())) {
            throw new IllegalStateException("Intention action " + Reflection.getOrCreateKotlinClass(this.getClass()) + " (" + this.getFamilyName() + ") refers to the element from another source file. It's likely that it's going to modify a file not opened in the editor, so default preview strategy won't work. Also, if another file is modified, getElementToMakeWritable() must be properly implemented to denote the actual file to be modified.");
        }
        PsiElement newElement2 = PsiTreeUtil.findSameElementInCopy(oldElement, (PsiFile)target);
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixActionBase<*>");
            quickFixActionBase = (QuickFixActionBase)object;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        QuickFixActionBase clone2 = quickFixActionBase;
        if (!ReflectionUtil.setField(QuickFixActionBase.class, (Object)clone2, SmartPsiElementPointer.class, (String)"elementPointer", (Object)SmartPointersKt.createSmartPointer((PsiElement)newElement2))) {
            return null;
        }
        return (FileModifier)clone2;
    }

    @NotNull
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

