/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.model.CalculatedValue;
import org.jspecify.annotations.Nullable;

public class DefaultResolvedArtifact
implements ResolvedArtifact {
    private final ComponentArtifactIdentifier id;
    private final CalculatedValue<File> fileSource;
    private final ModuleVersionIdentifier owner;
    private final IvyArtifactName artifactName;

    public DefaultResolvedArtifact(ComponentArtifactIdentifier id, CalculatedValue<File> fileSource, @Nullable ModuleVersionIdentifier owner, IvyArtifactName artifactName) {
        this.id = id;
        this.fileSource = fileSource;
        this.owner = owner;
        this.artifactName = artifactName;
    }

    public File getFile() {
        this.fileSource.finalizeIfNotAlready();
        return (File)this.fileSource.get();
    }

    public ComponentArtifactIdentifier getId() {
        return this.id;
    }

    public String toString() {
        return this.id.getDisplayName();
    }

    public ResolvedModuleVersion getModuleVersion() {
        if (this.owner == null) {
            throw new UnsupportedOperationException();
        }
        return new DefaultResolvedModuleVersion(this.owner);
    }

    public String getName() {
        return this.artifactName.getName();
    }

    public String getType() {
        return this.artifactName.getType();
    }

    public @Nullable String getExtension() {
        return this.artifactName.getExtension();
    }

    public @Nullable String getClassifier() {
        return this.artifactName.getClassifier();
    }
}

