/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.ColourUtils;
import tim.prune.config.TimezoneHelper;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FileInfo;
import tim.prune.data.FileType;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.gui.DialogCloser;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.WholeNumberField;
import tim.prune.gui.colour.ColourChooser;
import tim.prune.gui.colour.ColourPatch;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.PointTypeSelector;
import tim.prune.save.VersionCombiner;
import tim.prune.save.xml.KmlExportOptions;
import tim.prune.save.xml.KmlWriter;
import tim.prune.save.xml.KmlWriter22;
import tim.prune.save.xml.KmlWriter23;

public class KmlExporter
extends GenericFunction {
    private final TrackInfo _trackInfo;
    private final Track _track;
    private JDialog _dialog = null;
    private JComboBox<String> _titleField = null;
    private JComboBox<String> _versionField = null;
    private PointTypeSelector _pointTypeSelector = null;
    private JCheckBox _altitudesCheckbox = null;
    private JCheckBox _kmzCheckbox = null;
    private JCheckBox _exportImagesCheckbox = null;
    private JLabel _imageSizeLabel = null;
    private WholeNumberField _imageSizeField = null;
    private ColourPatch _colourPatch = null;
    private KmlWriter _kmlWriter = null;
    private JLabel _progressLabel = null;
    private JProgressBar _progressBar = null;
    private JFileChooser _fileChooser = null;
    private File _exportFile = null;
    private JButton _okButton = null;
    private ColourChooser _colourChooser = null;
    private static final String KML_FILENAME_IN_KMZ = "doc.kml";
    private static final int DEFAULT_THUMBNAIL_WIDTH = 240;
    private static final Color DEFAULT_TRACK_COLOUR = new Color(204, 0, 0);

    public KmlExporter(App app) {
        super(app);
        this._trackInfo = app.getTrackInfo();
        this._track = this._trackInfo.getTrack();
    }

    @Override
    public String getNameKey() {
        return "function.exportkml";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
            this._colourChooser = new ColourChooser(this._dialog);
        }
        this._imageSizeField.setValue(this.getConfig().getConfigInt("prune.kmzimagewidth"));
        this.enableCheckboxes();
        this.populateTitles();
        this._okButton.setEnabled(true);
        this._progressLabel.setText("");
        this._progressBar.setVisible(false);
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setAlignmentX(0.5f);
        double[] dArray = new double[]{0.2, 0.8};
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = blArray;
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel3, dArray, blArray2);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.exportkml.title")));
        this._titleField = new JComboBox();
        this._titleField.setPrototypeDisplayValue("Long enough for a reasonable description");
        this._titleField.setEditable(true);
        this._titleField.addKeyListener(new DialogCloser(this._dialog));
        guiGridLayout.add(this._titleField);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.exportxml.version")));
        this._versionField = new JComboBox();
        this._versionField.addItem(I18nManager.getText("dialog.exportkml.version22"));
        this._versionField.addItem(I18nManager.getText("dialog.exportkml.version23"));
        this._versionField.setPrototypeDisplayValue("Long enough for a reasonable description");
        this._versionField.setEditable(false);
        guiGridLayout.add(this._versionField);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(15));
        jPanel.add((Component)jPanel2, "Center");
        this._pointTypeSelector = new PointTypeSelector();
        this._pointTypeSelector.setAlignmentX(0.5f);
        jPanel2.add(this._pointTypeSelector);
        Color color = ColourUtils.colourFromHex(this.getConfig().getConfigString("prune.kmltrackcolour"));
        if (color == null) {
            color = DEFAULT_TRACK_COLOUR;
        }
        this._colourPatch = new ColourPatch(color);
        this._colourPatch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                KmlExporter.this._colourChooser.showDialog(KmlExporter.this._colourPatch);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel(I18nManager.getText("dialog.exportkml.trackcolour")));
        jPanel4.add(this._colourPatch);
        jPanel2.add(jPanel4);
        this._altitudesCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.altitude"));
        this._altitudesCheckbox.setHorizontalTextPosition(2);
        this._altitudesCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._altitudesCheckbox);
        this._kmzCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.kmz"));
        this._kmzCheckbox.setHorizontalTextPosition(2);
        this._kmzCheckbox.setAlignmentX(0.5f);
        this._kmzCheckbox.addActionListener(actionEvent -> this.enableCheckboxes());
        jPanel2.add(this._kmzCheckbox);
        this._exportImagesCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.exportimages"));
        this._exportImagesCheckbox.setHorizontalTextPosition(2);
        this._exportImagesCheckbox.setAlignmentX(0.5f);
        this._exportImagesCheckbox.addActionListener(actionEvent -> this.enableImageSizeFields());
        jPanel2.add(this._exportImagesCheckbox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        this._imageSizeLabel = new JLabel(I18nManager.getText("dialog.exportkml.imagesize"));
        this._imageSizeLabel.setAlignmentX(1.0f);
        jPanel5.add(this._imageSizeLabel);
        this._imageSizeField = new WholeNumberField(4);
        jPanel5.add(this._imageSizeField);
        jPanel2.add(jPanel5);
        jPanel2.add(Box.createVerticalStrut(10));
        this._progressLabel = new JLabel("...");
        this._progressLabel.setAlignmentX(0.5f);
        jPanel2.add(this._progressLabel);
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setVisible(false);
        this._progressBar.setAlignmentX(0.5f);
        jPanel2.add(this._progressBar);
        jPanel2.add(Box.createVerticalStrut(10));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = actionEvent -> this.startExport();
        this._okButton.addActionListener(actionListener);
        jPanel6.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> {
            if (this._kmlWriter != null) {
                this._kmlWriter.cancelExport();
            }
            this._dialog.dispose();
        });
        jPanel6.add(jButton);
        jPanel.add((Component)jPanel6, "South");
        return jPanel;
    }

    private void enableCheckboxes() {
        boolean bl;
        this._pointTypeSelector.init(this._trackInfo);
        boolean bl2 = this._track.hasData(Field.ALTITUDE);
        if (!bl2) {
            this._altitudesCheckbox.setSelected(false);
        }
        this._exportImagesCheckbox.setSelected((bl = this._trackInfo.getPhotoList().hasAny()) && this._kmzCheckbox.isSelected());
        this._exportImagesCheckbox.setEnabled(bl && this._kmzCheckbox.isSelected());
        this.enableImageSizeFields();
    }

    private void populateTitles() {
        String string = this.getEnteredTitle();
        this._titleField.removeAllItems();
        for (String object2 : this._app.getTrackInfo().getFileInfo().getAllTitles()) {
            this._titleField.addItem(object2);
        }
        if (string.isEmpty() && this._titleField.getItemCount() > 0) {
            this._titleField.setSelectedIndex(0);
        } else {
            this._titleField.setSelectedItem(string);
        }
        FileInfo fileInfo = this._app.getTrackInfo().getFileInfo();
        boolean bl = this.shouldExportKml22(fileInfo);
        this._versionField.setSelectedIndex(bl ? 0 : 1);
    }

    private boolean shouldExportKml22(FileInfo fileInfo) {
        VersionCombiner versionCombiner = new VersionCombiner(List.of("2.2", "2.3"));
        for (String string : fileInfo.getVersions(FileType.KML)) {
            versionCombiner.addVersion(string);
        }
        return versionCombiner.getBestVersion().equals("2.2");
    }

    private void enableImageSizeFields() {
        boolean bl = this._exportImagesCheckbox.isEnabled() && this._exportImagesCheckbox.isSelected();
        this._imageSizeField.setEnabled(bl);
        this._imageSizeLabel.setEnabled(bl);
    }

    private void startExport() {
        String string;
        String string2;
        if (!this._pointTypeSelector.getAnythingSelected()) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.save.notypesselected"), I18nManager.getText("dialog.saveoptions.title"), 2);
            return;
        }
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.setFileFilter(new GenericFileFilter("filetypefilter.kmlkmz", new String[]{"kml", "kmz"}));
            string2 = this.getConfig().getConfigString("prune.trackdirectory");
            if (string2 != null) {
                this._fileChooser.setCurrentDirectory(new File(string2));
            }
        }
        if (this._kmzCheckbox.isSelected()) {
            string2 = ".kmz";
            string = ".kml";
        } else {
            string2 = ".kml";
            string = ".kmz";
        }
        this._fileChooser.setAcceptAllFileFilterUsed(false);
        boolean bl = false;
        do {
            Object[] objectArray;
            bl = false;
            if (this._fileChooser.showSaveDialog(this._parentFrame) != 0) continue;
            File file = this._fileChooser.getSelectedFile();
            if (file.getName().toLowerCase().endsWith(string)) {
                objectArray = file.getAbsolutePath();
                file = new File(String.valueOf(objectArray.substring(0, objectArray.length() - string.length())) + string2);
            } else if (!file.getName().toLowerCase().endsWith(string2)) {
                file = new File(String.valueOf(file.getAbsolutePath()) + string2);
            }
            objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file.exists() || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                this._exportFile = file;
                new Thread(this::run).start();
                continue;
            }
            bl = true;
        } while (bl);
    }

    public void run() {
        this._okButton.setEnabled(false);
        this._progressLabel.setText(I18nManager.getText("confirm.running"));
        this._progressBar.setVisible(true);
        this._progressBar.setValue(0);
        boolean bl = this._kmzCheckbox.isSelected();
        boolean bl2 = bl && this._exportImagesCheckbox.isSelected();
        this._progressBar.setMaximum(bl2 ? this.getNumPhotosToExport() : 1);
        TimeZone timeZone = TimezoneHelper.getSelectedTimezone(this.getConfig());
        KmlExportOptions kmlExportOptions = new KmlExportOptions().setExportTrackPoints(this._pointTypeSelector.getTrackpointsSelected()).setExportWaypoints(this._pointTypeSelector.getWaypointsSelected()).setExportPhotos(this._pointTypeSelector.getPhotopointsSelected()).setExportAudios(this._pointTypeSelector.getAudiopointsSelected()).setExportJustSelection(this._pointTypeSelector.getJustSelection()).setAbsoluteAltitudes(this._altitudesCheckbox.isSelected()).setTitle(this.getEnteredTitle()).setTrackColour(this._colourPatch.getBackground()).setTimezone(timeZone);
        this._kmlWriter = this._versionField.getSelectedIndex() == 0 ? new KmlWriter22(this._trackInfo, kmlExportOptions, n -> this._progressBar.setValue(n)) : new KmlWriter23(this._trackInfo, kmlExportOptions, n -> this._progressBar.setValue(n));
        OutputStreamWriter outputStreamWriter = null;
        ZipOutputStream zipOutputStream = null;
        try {
            if (!this._kmzCheckbox.isSelected()) {
                outputStreamWriter = new OutputStreamWriter(new FileOutputStream(this._exportFile));
            } else {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(this._exportFile));
                if (bl2) {
                    int n2 = Math.max(240, this._imageSizeField.getValue());
                    this.getConfig().setConfigInt("prune.kmzimagewidth", n2);
                    this._kmlWriter.exportThumbnails(zipOutputStream, n2);
                }
                outputStreamWriter = new OutputStreamWriter(zipOutputStream);
                ZipEntry zipEntry = new ZipEntry(KML_FILENAME_IN_KMZ);
                zipOutputStream.putNextEntry(zipEntry);
            }
            int n3 = this._kmlWriter.exportData(outputStreamWriter, bl2);
            this.getConfig().setConfigString("prune.kmltrackcolour", ColourUtils.makeHexCode(this._colourPatch.getBackground()));
            this._progressBar.setValue(1);
            if (zipOutputStream != null) {
                outputStreamWriter.flush();
                zipOutputStream.closeEntry();
            }
            outputStreamWriter.close();
            this.getConfig().setConfigString("prune.trackdirectory", this._exportFile.getParentFile().getAbsolutePath());
            this._app.addRecentFile(this._exportFile, true);
            UpdateMessageBroker.informSubscribers();
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n3 + " " + I18nManager.getText("confirm.save.ok2") + " " + this._exportFile.getAbsolutePath());
            this._dialog.dispose();
            return;
        }
        catch (IOException iOException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException2) {}
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            this.startExport();
            return;
        }
    }

    private String getEnteredTitle() {
        Object object = this._titleField == null ? null : this._titleField.getSelectedItem();
        return object == null ? "" : object.toString();
    }

    private int getNumPhotosToExport() {
        int n = this._track.getNumPoints();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint = this._track.getPoint(n3);
            if (dataPoint.getPhoto() != null) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }
}

