/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13FileChecksum;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileChecksumsC13Section
extends C13Section {
    private List<C13FileChecksum> fileChecksums = new ArrayList<C13FileChecksum>();
    private Map<Integer, C13FileChecksum> fileChecksumsByOffset = new HashMap<Integer, C13FileChecksum>();

    static FileChecksumsC13Section parse(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        return new FileChecksumsC13Section(reader, ignore, monitor);
    }

    private FileChecksumsC13Section(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws CancelledException, PdbException {
        super(ignore);
        while (reader.numRemaining() >= C13FileChecksum.getBaseRecordSize()) {
            monitor.checkCancelled();
            int offset = reader.getIndex();
            C13FileChecksum fileChecksum = new C13FileChecksum(reader);
            this.fileChecksums.add(fileChecksum);
            this.fileChecksumsByOffset.put(offset, fileChecksum);
        }
        if (reader.hasMore()) {
            Msg.debug(FileChecksumsC13Section.class, (Object)String.format("Num Extra C13FileChecksums bytes: %d", reader.numRemaining()));
        }
    }

    public List<C13FileChecksum> getFileChecksums() {
        return this.fileChecksums;
    }

    public C13FileChecksum getFileChecksumByOffset(int offset) {
        return this.fileChecksumsByOffset.get(offset);
    }

    public String toString() {
        return String.format("%s: num checksums = %d", this.getClass().getSimpleName(), this.fileChecksums.size());
    }

    @Override
    protected void dumpInternal(Writer writer, TaskMonitor monitor) throws IOException, CancelledException {
        for (C13FileChecksum checksum : this.fileChecksums) {
            monitor.checkCancelled();
            writer.write(checksum.toString());
            writer.write(10);
        }
    }
}

