/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.MenuData;
import ghidra.app.cmd.function.SetFunctionVarArgsCommand;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;

public class DeleteVarArgsAction
extends ListingContextAction {
    private static final long serialVersionUID = 1L;
    FunctionPlugin functionPlugin;

    DeleteVarArgsAction(FunctionPlugin plugin) {
        super("Delete VarArgs", plugin.getName());
        this.functionPlugin = plugin;
        this.updatePopupMenu(true);
        this.setHelpLocation(new HelpLocation("FunctionPlugin", "Delete_VarArgs"));
    }

    private void updatePopupMenu(boolean isSignatureAction) {
        if (isSignatureAction) {
            this.setPopupMenuData(new MenuData(new String[]{"Function", "Delete VarArgs"}, null, "Function"));
        } else {
            this.setPopupMenuData(new MenuData(new String[]{"Function Variables", "Delete VarArgs"}, null, "FunctionVariable"));
        }
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Function function = this.functionPlugin.getFunction(context);
        if (function != null && function.hasVarArgs()) {
            Program program;
            SetFunctionVarArgsCommand command = new SetFunctionVarArgsCommand(function, false);
            PluginTool tool = this.functionPlugin.getTool();
            if (!tool.execute((Command)command, (DomainObject)(program = context.getProgram()))) {
                tool.setStatusInfo("Unable to delete function varArgs on function: " + function.getName());
            }
        }
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        if (!(location instanceof VariableLocation) && !(location instanceof FunctionSignatureFieldLocation)) {
            return false;
        }
        if (location instanceof FunctionSignatureFieldLocation) {
            this.updatePopupMenu(true);
        } else {
            this.updatePopupMenu(false);
        }
        Function function = this.functionPlugin.getFunction(context);
        return function != null && function.hasVarArgs();
    }
}

