/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datapreview;

import ghidra.app.plugin.core.datapreview.Preview;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;

class DataTypeComponentPreview
implements Preview {
    private DataTypeComponentPreview parentPreview;
    private Composite composite;
    private DataTypeComponent dtc;

    DataTypeComponentPreview(Composite composite, DataTypeComponent dtc) {
        this.composite = composite;
        this.dtc = dtc;
    }

    DataTypeComponentPreview getParent() {
        return this.parentPreview;
    }

    DataTypeComponentPreview getRoot() {
        DataTypeComponentPreview parent = this.parentPreview;
        if (parent == null) {
            return null;
        }
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    void setParent(DataTypeComponentPreview parent) {
        this.parentPreview = parent;
    }

    @Override
    public String getName() {
        String fieldName = this.dtc.getFieldName();
        if (fieldName == null) {
            fieldName = this.dtc.getDefaultFieldName();
        }
        if (this.parentPreview == null) {
            return this.composite.getName() + "." + fieldName;
        }
        return this.parentPreview.getName() + "." + fieldName;
    }

    @Override
    public String getPreview(Memory memory, Address addr) {
        try {
            if (this.parentPreview != null) {
                addr = addr.add((long)this.parentPreview.dtc.getOffset());
            }
            addr = addr.add((long)this.dtc.getOffset());
            DumbMemBufferImpl mb = new DumbMemBufferImpl(memory, addr);
            DataType dt = this.dtc.getDataType();
            return dt.getRepresentation((MemBuffer)mb, this.dtc.getDefaultSettings(), this.dtc.getLength());
        }
        catch (Exception e) {
            return "ERROR: unable to create preview";
        }
    }

    @Override
    public DataType getDataType() {
        if (this.parentPreview != null) {
            return this.parentPreview.getDataType();
        }
        return this.composite;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Preview p) {
        if (p instanceof DataTypeComponentPreview) {
            int value;
            DataTypeComponentPreview that = (DataTypeComponentPreview)p;
            if (this.parentPreview != null && that.parentPreview == null) {
                return this.parentPreview.compareTo(that);
            }
            if (this.parentPreview == null && that.parentPreview != null) {
                return this.compareTo(that.parentPreview);
            }
            if (this.parentPreview != null && that.parentPreview != null && (value = this.parentPreview.compareTo(that.parentPreview)) != 0) {
                return value;
            }
            if (this.composite.equals((Object)that.composite)) {
                if (this.dtc.getOffset() < that.dtc.getOffset()) {
                    return -1;
                }
                if (this.dtc.getOffset() > that.dtc.getOffset()) {
                    return 1;
                }
                return 0;
            }
            return this.composite.getName().compareTo(that.composite.getName());
        }
        return this.toString().compareToIgnoreCase(p.toString());
    }
}

