/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.markuptype.DataTypeMarkupType;
import ghidra.feature.vt.api.markuptype.EolCommentMarkupType;
import ghidra.feature.vt.api.markuptype.FunctionNameMarkupType;
import ghidra.feature.vt.api.markuptype.FunctionSignatureMarkupType;
import ghidra.feature.vt.api.markuptype.LabelMarkupType;
import ghidra.feature.vt.api.markuptype.PlateCommentMarkupType;
import ghidra.feature.vt.api.markuptype.PostCommentMarkupType;
import ghidra.feature.vt.api.markuptype.PreCommentMarkupType;
import ghidra.feature.vt.api.markuptype.RepeatableCommentMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.gui.plugin.AddressCorrelatorManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.AddressCorrelationRange;
import ghidra.program.util.AutomaticCommentFieldLocation;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.EolCommentFieldLocation;
import ghidra.program.util.FunctionCallingConventionFieldLocation;
import ghidra.program.util.FunctionInlineFieldLocation;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.FunctionNoReturnFieldLocation;
import ghidra.program.util.FunctionParameterFieldLocation;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.PostCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.RepeatableCommentFieldLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.program.util.VariableLocFieldLocation;
import ghidra.program.util.VariableLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.program.util.VariableTypeFieldLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CachingSwingWorker;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MatchInfo {
    private final VTMatch match;
    private final Program sourceProgram;
    private final Program destinationProgram;
    private final Function sourceFunction;
    private final Function destinationFunction;
    private final Data sourceData;
    private final Data destinationData;
    private final AddressSetView sourceAddressSet;
    private final AddressSetView destinationAddressSet;
    private MarkupItemsCache markupItemsCache;
    private AddressCorrelation correlationCache;
    private boolean initCorrelationCache = true;
    private final AddressCorrelatorManager correlator;

    MatchInfo(VTMatch match, AddressCorrelatorManager correlator) {
        this.match = match;
        this.correlator = correlator;
        VTAssociation association = match.getAssociation();
        VTSession session = association.getSession();
        this.sourceProgram = session.getSourceProgram();
        this.destinationProgram = session.getDestinationProgram();
        this.markupItemsCache = new MarkupItemsCache();
        VTAssociationType type = association.getType();
        Address sourceAddress = association.getSourceAddress();
        Function function = this.sourceFunction = this.sourceProgram != null ? this.sourceProgram.getFunctionManager().getFunctionAt(sourceAddress) : null;
        if (type == VTAssociationType.FUNCTION && this.sourceFunction != null) {
            this.sourceData = null;
            this.sourceAddressSet = this.sourceFunction.getBody();
        } else {
            Listing sourceListing = this.sourceProgram.getListing();
            this.sourceData = sourceListing.getDataAt(sourceAddress);
            CodeUnit codeUnit = sourceListing.getCodeUnitAt(sourceAddress);
            this.sourceAddressSet = codeUnit == null ? new AddressSet(sourceAddress) : new AddressSet(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
        }
        Address destinationAddress = association.getDestinationAddress();
        Function function2 = this.destinationFunction = this.destinationProgram != null ? this.destinationProgram.getFunctionManager().getFunctionAt(destinationAddress) : null;
        if (type == VTAssociationType.FUNCTION && this.destinationFunction != null) {
            this.destinationData = null;
            this.destinationAddressSet = this.destinationFunction.getBody();
        } else {
            Listing destinationListing = this.destinationProgram.getListing();
            this.destinationData = destinationListing.getDataAt(destinationAddress);
            CodeUnit codeUnit = destinationListing.getCodeUnitAt(destinationAddress);
            if (codeUnit == null) {
                this.destinationAddressSet = new AddressSet(destinationAddress);
            } else {
                int destinationLength;
                int sourceLength;
                Address minAddress = codeUnit.getMinAddress();
                Address maxAddress = codeUnit.getMaxAddress();
                if (this.destinationData != null && (sourceLength = this.sourceData != null ? this.sourceData.getLength() : 0) > (destinationLength = this.destinationData.getLength())) {
                    maxAddress = minAddress.add((long)(sourceLength - 1));
                }
                AddressSet tempDestinationAddressSet = new AddressSet(minAddress, maxAddress);
                this.destinationAddressSet = tempDestinationAddressSet.intersect((AddressSetView)this.destinationProgram.getMemory());
            }
        }
    }

    public void clearCache() {
        this.markupItemsCache.clear();
    }

    public VTMatch getMatch() {
        return this.match;
    }

    public Function getSourceFunction() {
        return this.sourceFunction;
    }

    public Function getDestinationFunction() {
        return this.destinationFunction;
    }

    public Data getSourceData() {
        return this.sourceData;
    }

    public Data getDestinationData() {
        return this.destinationData;
    }

    public AddressSetView getSourceAddressSet() {
        return this.sourceAddressSet;
    }

    public AddressSetView getDestinationAddressSet() {
        return this.destinationAddressSet;
    }

    public Collection<VTMarkupItem> getAppliableMarkupItems(TaskMonitor monitor) {
        return (Collection)this.markupItemsCache.get(monitor);
    }

    private void setDefaultDestination(VTMarkupItem markupItem, AddressCorrelation correlation, TaskMonitor monitor) throws CancelledException {
        AddressCorrelationRange range;
        Address destinationAddress = this.getDestinationAddress(markupItem);
        Address sourceAddress = markupItem.getSourceAddress();
        if (destinationAddress != null) {
            return;
        }
        String destinationAddressSource = null;
        if (correlation != null && (range = correlation.getCorrelatedDestinationRange(sourceAddress, monitor)) != null) {
            destinationAddress = range.getMinAddress();
            destinationAddressSource = range.getCorrelatorName();
        }
        if (destinationAddress != null) {
            markupItem.setDefaultDestinationAddress(destinationAddress, destinationAddressSource);
        }
    }

    private Address getDestinationAddress(VTMarkupItem markupItem) {
        ProgramLocation loc = markupItem.getDestinationLocation();
        return loc == null ? null : loc.getAddress();
    }

    private AddressCorrelation getAddressTranslator(AddressCorrelatorManager correlatorMgr) {
        if (this.initCorrelationCache) {
            VTAssociation association = this.match.getAssociation();
            VTAssociationType type = association.getType();
            if (type == VTAssociationType.FUNCTION) {
                if (this.sourceFunction != null && this.destinationFunction != null) {
                    this.correlationCache = correlatorMgr.getCorrelator(this.sourceFunction, this.destinationFunction);
                }
            } else if (type == VTAssociationType.DATA && this.sourceData != null && this.destinationData != null) {
                this.correlationCache = correlatorMgr.getCorrelator(this.sourceData, this.destinationData);
            }
            this.initCorrelationCache = false;
        }
        return this.correlationCache;
    }

    public Address getDestinationAddress(Address sourceAddress, AddressCorrelatorManager correlatorMgr) {
        if (sourceAddress == null) {
            return null;
        }
        AddressCorrelation correlation = this.getAddressTranslator(correlatorMgr);
        if (correlation == null) {
            return null;
        }
        AddressCorrelationRange range = null;
        try {
            range = correlation.getCorrelatedDestinationRange(sourceAddress, TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        if (range == null) {
            return null;
        }
        return range.getMinAddress();
    }

    public VTMarkupItem getCurrentMarkupForLocation(ProgramLocation programLocation, Program program) {
        VTMarkupType markupType = MatchInfo.getMarkupTypeForLocation(programLocation, program);
        if (markupType == null) {
            return null;
        }
        Address markupAddress = MatchInfo.getMarkupAddressForLocation(programLocation, program);
        return this.getMarkupItem(markupAddress, program == this.sourceProgram, markupType);
    }

    private VTMarkupItem getMarkupItem(Address address, boolean isSourceAddress, VTMarkupType markupType) {
        if (address == null) {
            return null;
        }
        List list = (List)this.markupItemsCache.getCachedValue();
        if (list == null) {
            return null;
        }
        for (VTMarkupItem markupItem : list) {
            Address markupItemAddress;
            ProgramLocation location = isSourceAddress ? markupItem.getSourceLocation() : markupItem.getDestinationLocation();
            if (location == null || !address.equals((Object)(markupItemAddress = MatchInfo.getMarkupAddressForLocation(location, isSourceAddress ? this.sourceProgram : this.destinationProgram))) || markupItem.getMarkupType() != markupType) continue;
            return markupItem;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + String.valueOf(this.match);
    }

    public static VTMarkupType getMarkupTypeForLocation(ProgramLocation programLocation, Program program) {
        VariableLocation variableLocation;
        Variable variable;
        FunctionSignatureFieldLocation functionSignatureLocation;
        String signature;
        if (programLocation instanceof FunctionNameFieldLocation) {
            return FunctionNameMarkupType.INSTANCE;
        }
        if (programLocation instanceof FunctionReturnTypeFieldLocation) {
            return FunctionSignatureMarkupType.INSTANCE;
        }
        if (programLocation instanceof FunctionCallingConventionFieldLocation) {
            return FunctionSignatureMarkupType.INSTANCE;
        }
        if (programLocation instanceof FunctionInlineFieldLocation) {
            return FunctionSignatureMarkupType.INSTANCE;
        }
        if (programLocation instanceof FunctionNoReturnFieldLocation) {
            return FunctionSignatureMarkupType.INSTANCE;
        }
        if (programLocation instanceof FunctionSignatureFieldLocation && (signature = (functionSignatureLocation = (FunctionSignatureFieldLocation)programLocation).getSignature()).endsWith("...)")) {
            int index = functionSignatureLocation.getCharOffset();
            int startVarArgs = signature.length() - 4;
            int endVarArgs = startVarArgs + 2;
            if (index >= startVarArgs && index <= endVarArgs) {
                return FunctionSignatureMarkupType.INSTANCE;
            }
        }
        if (programLocation instanceof FunctionParameterFieldLocation) {
            return FunctionSignatureMarkupType.INSTANCE;
        }
        if (programLocation instanceof LabelFieldLocation) {
            return LabelMarkupType.INSTANCE;
        }
        if (programLocation instanceof FunctionNameFieldLocation) {
            return FunctionNameMarkupType.INSTANCE;
        }
        if (programLocation instanceof EolCommentFieldLocation || programLocation instanceof AutomaticCommentFieldLocation) {
            return EolCommentMarkupType.INSTANCE;
        }
        if (programLocation instanceof PlateFieldLocation) {
            return PlateCommentMarkupType.INSTANCE;
        }
        if (programLocation instanceof PostCommentFieldLocation) {
            return PostCommentMarkupType.INSTANCE;
        }
        if (programLocation instanceof RepeatableCommentFieldLocation) {
            return RepeatableCommentMarkupType.INSTANCE;
        }
        if (programLocation instanceof CommentFieldLocation) {
            return PreCommentMarkupType.INSTANCE;
        }
        if (programLocation instanceof MnemonicFieldLocation) {
            return DataTypeMarkupType.INSTANCE;
        }
        if (programLocation instanceof VariableLocation && (variable = (variableLocation = (VariableLocation)programLocation).getVariable()) instanceof Parameter) {
            VariableNameFieldLocation nameLoc;
            if (programLocation instanceof VariableNameFieldLocation && !(nameLoc = (VariableNameFieldLocation)programLocation).isReturn()) {
                return FunctionSignatureMarkupType.INSTANCE;
            }
            if (programLocation instanceof VariableCommentFieldLocation) {
                return FunctionSignatureMarkupType.INSTANCE;
            }
            if (programLocation instanceof VariableTypeFieldLocation) {
                return FunctionSignatureMarkupType.INSTANCE;
            }
            if (programLocation instanceof VariableLocFieldLocation) {
                return FunctionSignatureMarkupType.INSTANCE;
            }
        }
        return null;
    }

    public static Address getMarkupAddressForLocation(ProgramLocation programLocation, Program program) {
        return programLocation.getAddress();
    }

    class MarkupItemsCache
    extends CachingSwingWorker<List<VTMarkupItem>> {
        public MarkupItemsCache() {
            super("Generating Markup Items", true);
        }

        protected List<VTMarkupItem> runInBackground(TaskMonitor monitor) {
            ArrayList<VTMarkupItem> list = new ArrayList<VTMarkupItem>();
            VTAssociation association = MatchInfo.this.match.getAssociation();
            try {
                Collection<VTMarkupItem> markupItems = association.getMarkupItems(monitor);
                AddressCorrelation addressTranslator = MatchInfo.this.getAddressTranslator(MatchInfo.this.correlator);
                for (VTMarkupItem markupItem : markupItems) {
                    Address destinationAddress = markupItem.getDestinationAddress();
                    if (destinationAddress == null) {
                        MatchInfo.this.setDefaultDestination(markupItem, addressTranslator, monitor);
                    }
                    list.add(markupItem);
                }
                return list;
            }
            catch (CancelledException e) {
                return new ArrayList<VTMarkupItem>();
            }
        }
    }
}

