/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.navigation;

import ghidra.app.services.QueryData;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.UserSearchUtils;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SymbolMatcher {
    private String symbolName;
    private Pattern pattern;
    private boolean caseSensitive;
    private boolean isRelativePath;
    private boolean isPossibleMemoryBlockPattern;

    public SymbolMatcher(String queryString, boolean caseSensitive) {
        queryString = queryString.replaceAll("\\s", "");
        this.caseSensitive = caseSensitive;
        this.isRelativePath = !queryString.startsWith("::");
        this.symbolName = this.getSymbolName(queryString);
        this.pattern = this.createPattern(queryString);
        this.isPossibleMemoryBlockPattern = this.checkIfPossibleMemoryBlockPattern(queryString);
    }

    private boolean checkIfPossibleMemoryBlockPattern(String queryString) {
        int lastIndexOf = queryString.lastIndexOf("::");
        if (lastIndexOf < 1) {
            return false;
        }
        String qualifierPart = queryString.substring(0, lastIndexOf);
        if (qualifierPart.indexOf("::") >= 0) {
            return false;
        }
        return !qualifierPart.contains("*") && !qualifierPart.contains("?");
    }

    private String getSymbolName(String queryString) {
        int index = queryString.lastIndexOf("::");
        if (index < 0) {
            return queryString;
        }
        return queryString.substring(index + "::".length());
    }

    private Pattern createPattern(String userInput) {
        String s = UserSearchUtils.escapeNonGlobbingRegexCharacters((String)userInput);
        s = this.replaceNamespaceDelimiters(s);
        s = this.removeExcessStars(s);
        s = this.convertNameGlobingToRegEx(s);
        s = this.convertPathGlobingToRegEx(s);
        s = this.convertRelativePathToRegEx(s);
        return Pattern.compile(s, this.createRegexOptions());
    }

    private String removeExcessStars(String s) {
        int start = ((String)s).indexOf("***");
        while (start >= 0) {
            int end = this.findFirstNonStar((String)s, start);
            s = ((String)s).substring(0, start + 2) + ((String)s).substring(end);
            start = ((String)s).indexOf("***");
        }
        return s;
    }

    private int findFirstNonStar(String query, int index) {
        while (index < query.length() && query.charAt(index) == '*') {
            ++index;
        }
        return index;
    }

    private String replaceNamespaceDelimiters(String s) {
        if (!this.isRelativePath) {
            s = s.substring("::".length());
        }
        return s.replaceAll("::", " ");
    }

    private String convertPathGlobingToRegEx(String s) {
        s = s.replaceAll(" \\*\\* ", "( .* | )");
        s = s.replaceAll("^\\*\\* ", "(.* |)");
        s = s.replaceAll(" \\*\\*$", " .*");
        s = s.replaceAll("\\*\\*", "[^ ]*");
        return s;
    }

    private String convertNameGlobingToRegEx(String s) {
        s = s.replaceAll("(?<!\\*)\\*(?!\\*)", "[^ ]*");
        s = s.replaceAll("\\?", ".");
        return s;
    }

    private String convertRelativePathToRegEx(String s) {
        if (!((String)s).isBlank() && this.isRelativePath) {
            s = ".*" + (String)s;
        }
        return s;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    private int createRegexOptions() {
        if (!this.caseSensitive) {
            return 2;
        }
        return 0;
    }

    public boolean hasFullySpecifiedName() {
        return !QueryData.hasWildCards(this.symbolName) && this.caseSensitive;
    }

    public boolean hasWildCardsInSymbolName() {
        return QueryData.hasWildCards(this.symbolName);
    }

    public boolean matches(Symbol symbol) {
        String path = this.createSymbolPathWithSpaces(symbol);
        if (this.pattern.matcher(path).matches()) {
            return true;
        }
        return this.checkMemoryBlockName(symbol);
    }

    private String createSymbolPathWithSpaces(Symbol symbol) {
        String[] path = symbol.getPath();
        return Arrays.stream(path).collect(Collectors.joining(" "));
    }

    private boolean checkMemoryBlockName(Symbol symbol) {
        if (!this.isPossibleMemoryBlockPattern) {
            return false;
        }
        Program program = symbol.getProgram();
        MemoryBlock block = program.getMemory().getBlock(symbol.getAddress());
        if (block != null) {
            String blockNamePath = block.getName() + " " + symbol.getName();
            return this.pattern.matcher(blockNamePath).matches();
        }
        return false;
    }
}

