/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemanglerUtil;
import org.apache.commons.lang3.StringUtils;

public class DemangledNamespaceNode
implements Demangled {
    protected String mangled;
    private String originalDemangled;
    private String demangledName;
    private String name;
    protected Demangled namespace;

    public DemangledNamespaceNode(String mangled, String originalDemangled, String name) {
        this.mangled = mangled;
        this.originalDemangled = originalDemangled;
        this.setName(name);
    }

    @Override
    public void setName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        this.demangledName = name;
        this.name = DemanglerUtil.stripSuperfluousSignatureSpaces(name).replace(' ', '_');
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMangledString() {
        return this.mangled;
    }

    @Override
    public String getOriginalDemangled() {
        return this.originalDemangled;
    }

    @Override
    public String getDemangledName() {
        return this.demangledName;
    }

    @Override
    public void setNamespace(Demangled ns) {
        this.namespace = ns;
    }

    @Override
    public Demangled getNamespace() {
        return this.namespace;
    }

    @Override
    public String getNamespaceString() {
        return this.getName(true);
    }

    @Override
    public String getNamespaceName() {
        return this.name;
    }

    @Override
    public String getSignature() {
        return this.getNamespaceName();
    }

    private String getName(boolean includeNamespace) {
        StringBuilder builder = new StringBuilder();
        if (includeNamespace && this.namespace != null) {
            builder.append(this.namespace.getNamespaceString());
            builder.append("::");
        }
        builder.append(this.demangledName);
        return builder.toString();
    }

    public String toString() {
        return this.getNamespaceString();
    }
}

