/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfIndex;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.app.util.bin.format.omf.omf.OmfSymbol;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OmfExternalSymbol
extends OmfRecord {
    private boolean isStatic;
    protected List<OmfSymbol> symbols = new ArrayList<OmfSymbol>();
    private List<Reference> refs = new ArrayList<Reference>();

    public OmfExternalSymbol(BinaryReader reader, boolean isStatic) throws IOException {
        super(reader);
        this.isStatic = isStatic;
    }

    @Override
    public void parseData() throws IOException, OmfException {
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            OmfString name = OmfUtils.readString(this.dataReader);
            OmfIndex typeIndex = OmfUtils.readIndex(this.dataReader);
            this.refs.add(new Reference(name, typeIndex));
            this.symbols.add(new OmfSymbol(name.str(), typeIndex.value(), 0L, 0, 0));
        }
    }

    public List<OmfSymbol> getSymbols() {
        return this.symbols;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(OmfRecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        for (Reference ref : this.refs) {
            struct.add(ref.name.toDataType(), ref.name.getDataTypeSize(), "external_name", null);
            struct.add(ref.typeIndex.toDataType(), "type_index", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    private record Reference(OmfString name, OmfIndex typeIndex) {
    }
}

