/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataTypePath;
import org.apache.commons.lang3.StringUtils;

public class ClassTypeUtils {
    private static final String INTERNALS = "!internals";

    private ClassTypeUtils() {
    }

    public static CategoryPath getInternalsCategoryPath(Composite composite) {
        DataTypePath dtp = composite.getDataTypePath();
        return dtp.getCategoryPath().extend(new String[]{dtp.getDataTypeName(), INTERNALS});
    }

    public static CategoryPath getInternalsCategoryPath(CategoryPath categoryPath) {
        return categoryPath.extend(new String[]{INTERNALS});
    }

    public static DataTypePath getInternalsDataTypePath(Composite composite, String name) {
        CategoryPath cp = ClassTypeUtils.getInternalsCategoryPath(composite);
        if (cp == null || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{name})) {
            return null;
        }
        return new DataTypePath(cp, name);
    }
}

