/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph;

import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FGEdgeImpl;
import ghidra.app.plugin.core.functiongraph.graph.FGVertexType;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayout;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AbstractFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.DummyListingFGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupHistoryInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupListener;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.ListingFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphVertexAttributes;
import ghidra.app.plugin.core.functiongraph.mvc.LazyGraphGroupSaveableXML;
import ghidra.app.plugin.core.functiongraph.mvc.LazyGraphRegroupSaveableXML;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.VisualGraph;
import ghidra.graph.graphs.GroupingVisualGraph;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.LayoutListener;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.RefType;
import ghidra.program.util.ProgramSelection;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;

public class FunctionGraph
extends GroupingVisualGraph<FGVertex, FGEdge> {
    private Set<FGEdge> ungroupedEdges = new HashSet<FGEdge>();
    private Set<GroupHistoryInfo> groupHistorySet = new HashSet<GroupHistoryInfo>();
    private Function function;
    private FGVertex rootVertex;
    private FunctionGraphVertexAttributes settings;
    private FunctionGraphOptions options;
    private FGLayout graphLayout;
    private GroupListener groupListener = new GroupListener(){

        @Override
        public void groupDescriptionChanged(String oldText, String newText) {
            this.updateGroupHistory(oldText, newText);
        }

        private void updateGroupHistory(String oldText, String newText) {
            for (GroupHistoryInfo info : FunctionGraph.this.groupHistorySet) {
                String currentDescription = info.getGroupDescription();
                if (!currentDescription.equals(oldText)) continue;
                info.setGroupDescription(newText);
            }
        }
    };

    FunctionGraph(Function function, FunctionGraphVertexAttributes settings, Collection<FGVertex> vertices, Collection<FGEdge> edges) {
        this(function, settings);
        vertices.forEach(v -> this.addVertex((VisualVertex)v));
        edges.forEach(e -> this.addEdge((GEdge)e));
        this.restoreSettings();
    }

    private FunctionGraph(Function function, FunctionGraphVertexAttributes settings) {
        this.function = function;
        this.settings = settings;
    }

    public FGVertex findMatchingVertex(FGVertex v) {
        FGVertex matching = this.getVertexForAddress(v.getVertexAddress());
        return matching;
    }

    public FGVertex findMatchingVertex(FGVertex v, Collection<FGVertex> ignore) {
        FGVertex matching = this.getVertexForAddress(v.getVertexAddress(), ignore);
        return matching;
    }

    public Function getFunction() {
        return this.function;
    }

    public void restoreSettings() {
        for (FGVertex vertex : this.getVertices()) {
            vertex.readSettings(this.settings);
        }
    }

    public void saveSettings() {
        this.saveVertexSettings();
        this.settings.save();
    }

    private void saveVertexSettings() {
        for (FGVertex vertex : this.getVertices()) {
            vertex.writeSettings(this.settings);
        }
    }

    public void clearVertexColor(FGVertex vertex) {
        this.settings.clearVertexColor(vertex.getVertexAddress());
    }

    public FunctionGraphVertexAttributes getSettings() {
        return this.settings;
    }

    public Element getSavedGroupedVertexSettings() {
        return this.settings.getGroupedVertexSettings(this);
    }

    public Element getSavedGroupHistory() {
        return this.settings.getRegroupVertexSettings(this);
    }

    public Map<FGVertex, Point> getSavedVertexLocations() {
        return this.settings.getVertexLocations(this);
    }

    private void clearSavedVertexLocation(FGVertex vertex) {
        this.settings.clearVertexLocation(vertex);
    }

    public void clearSavedVertexLocations() {
        this.settings.clearVertexLocations(this);
    }

    public void clearAllUserLayoutSettings() {
        this.clearSavedVertexLocations();
        this.settings.clearGroupSettings(this);
        this.settings.clearRegroupSettings(this);
    }

    public void vertexLocationChanged(FGVertex v, Point point, LayoutListener.ChangeType changeType) {
        if (changeType == LayoutListener.ChangeType.USER) {
            this.settings.putVertexLocation(v, point);
        }
    }

    public FunctionGraphOptions getOptions() {
        return this.options;
    }

    public void setOptions(FunctionGraphOptions options) {
        this.options = options;
    }

    public void setGraphLayout(FGLayout layout) {
        this.graphLayout = layout;
    }

    public FGLayout getLayout() {
        return this.graphLayout;
    }

    public FGVertex getVertexForAddress(Address address) {
        return this.getVertexForAddress(address, Collections.emptySet());
    }

    public FGVertex getVertexForAddress(Address address, Collection<FGVertex> ignore) {
        for (FGVertex v : this.getVertices()) {
            if (!v.containsAddress(address) || ignore.contains(v)) continue;
            return v;
        }
        return null;
    }

    public void setProgramSelection(ProgramSelection selection) {
        for (FGVertex vertex : this.getVertices()) {
            vertex.setProgramSelection(selection);
        }
    }

    public void setProgramHighlight(ProgramSelection highlight) {
        for (FGVertex vertex : this.getVertices()) {
            vertex.setProgramHighlight(highlight);
        }
    }

    public Set<FGVertex> getUngroupedVertices() {
        return this.generateUngroupedVertices();
    }

    private Set<FGVertex> generateUngroupedVertices() {
        HashSet<FGVertex> ungrouped = new HashSet<FGVertex>();
        for (FGVertex v : this.getVertices()) {
            this.accumulateUngroupedVertices(v, ungrouped);
        }
        return ungrouped;
    }

    private void accumulateUngroupedVertices(FGVertex v, Set<FGVertex> ungrouped) {
        if (!(v instanceof GroupedFunctionGraphVertex)) {
            ungrouped.add(v);
            return;
        }
        GroupedFunctionGraphVertex gv = (GroupedFunctionGraphVertex)v;
        Set<FGVertex> grouped = gv.getVertices();
        for (FGVertex child : grouped) {
            this.accumulateUngroupedVertices(child, ungrouped);
        }
    }

    public Set<FGEdge> getUngroupedEdges() {
        return this.generateUngroupedEdges();
    }

    private Set<FGEdge> generateUngroupedEdges() {
        HashSet<FGEdge> ungrouped = new HashSet<FGEdge>();
        for (FGVertex v : this.getVertices()) {
            this.accumulateUngroupedEdges(v, ungrouped);
        }
        ungrouped.addAll(this.getCurrentUngroupedEdges());
        return ungrouped;
    }

    private Collection<FGEdge> getCurrentUngroupedEdges() {
        HashSet<FGEdge> result = new HashSet<FGEdge>(this.getEdges());
        result.removeIf(e -> e.getStart() instanceof GroupedFunctionGraphVertex || e.getEnd() instanceof GroupedFunctionGraphVertex);
        return result;
    }

    private void accumulateUngroupedEdges(FGVertex v, Set<FGEdge> ungrouped) {
        if (!(v instanceof GroupedFunctionGraphVertex)) {
            return;
        }
        GroupedFunctionGraphVertex gv = (GroupedFunctionGraphVertex)v;
        Set<FGEdge> gvEdges = gv.getUngroupedEdges();
        ungrouped.addAll(gvEdges);
        Set<FGVertex> grouped = gv.getVertices();
        for (FGVertex child : grouped) {
            this.accumulateUngroupedEdges(child, ungrouped);
        }
    }

    public GroupHistoryInfo getGroupHistory(FGVertex vertex) {
        return vertex.getGroupInfo();
    }

    public Collection<GroupHistoryInfo> getGroupHistory() {
        return Collections.unmodifiableSet(this.groupHistorySet);
    }

    public void setGroupHistory(Collection<GroupHistoryInfo> history) {
        this.groupHistorySet = new HashSet<GroupHistoryInfo>(history);
        for (GroupHistoryInfo info : history) {
            Set<FGVertex> infoVertices = info.getVertices();
            this.notifyVerticesOfGroupAssociation(infoVertices, info);
        }
    }

    public void removeFromGroupHistory(FGVertex vertex) {
        this.removeFromAllHistory(vertex);
    }

    public void groupRestored(GroupedFunctionGraphVertex group) {
        group.addGroupListener(this.groupListener);
    }

    public void groupAdded(GroupedFunctionGraphVertex group) {
        group.addGroupListener(this.groupListener);
        this.removeAssociatedGroups(group.getVertices());
    }

    public void groupRemoved(GroupedFunctionGraphVertex group) {
        group.removeGroupListener(this.groupListener);
        Set<FGVertex> groupVertices = group.getVertices();
        if (this.hasExistingGroupInfo(groupVertices)) {
            return;
        }
        GroupHistoryInfo info = new GroupHistoryInfo(this, group);
        this.notifyVerticesOfGroupAssociation(groupVertices, info);
        this.groupHistorySet.add(info);
    }

    private boolean hasExistingGroupInfo(Set<FGVertex> groupVertices) {
        Iterator<FGVertex> iterator = groupVertices.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        return iterator.next().getGroupInfo() != null;
    }

    private void removeAssociatedGroups(Collection<FGVertex> groupVertices) {
        for (FGVertex vertex : groupVertices) {
            Iterator<GroupHistoryInfo> iterator = this.groupHistorySet.iterator();
            while (iterator.hasNext()) {
                GroupHistoryInfo info = iterator.next();
                if (!info.contains(vertex)) continue;
                this.notifyVerticesOfGroupAssociation(info.getVertices(), null);
                iterator.remove();
            }
        }
    }

    private void removeFromAllHistory(FGVertex vertex) {
        boolean didRemove = false;
        for (GroupHistoryInfo info : this.groupHistorySet) {
            if (!info.contains(vertex)) continue;
            info.removeVertex(vertex);
            didRemove = true;
            this.notifyVerticesOfGroupAssociation(info.getVertices(), info);
        }
        if (didRemove) {
            this.notifyVerticesOfGroupAssociation(Arrays.asList(vertex), null);
        }
    }

    private void notifyVerticesOfGroupAssociation(Collection<FGVertex> groupVertices, GroupHistoryInfo groupInfo) {
        for (FGVertex vertex : groupVertices) {
            vertex.updateGroupAssociationStatus(groupInfo);
        }
    }

    public FGVertex getRootVertex() {
        return this.rootVertex;
    }

    public void setRootVertex(FGVertex rootVertex) {
        if (this.rootVertex != null) {
            this.rootVertex = rootVertex;
            return;
        }
        this.rootVertex = rootVertex;
        this.settings.putGroupedVertexSettings(this, new LazyGraphGroupSaveableXML(this));
        this.settings.putRegroupSettings(this, new LazyGraphRegroupSaveableXML(this));
    }

    public ProgramSelection getProgramSelectionForAllVertices() {
        AddressSet addresses = new AddressSet();
        for (FGVertex vertex : this.getVertices()) {
            ProgramSelection programSelection = vertex.getProgramSelection();
            if (programSelection == null) continue;
            addresses.add((AddressSetView)programSelection);
        }
        return new ProgramSelection((AddressSetView)addresses);
    }

    public Set<FGVertex> getEntryPoints() {
        LinkedHashSet<FGVertex> result = new LinkedHashSet<FGVertex>();
        for (FGVertex vertex : this.getVertices()) {
            FGVertexType vertexType = vertex.getVertexType();
            if (vertex.isEntry()) {
                result.add(vertex);
                continue;
            }
            if (vertexType != FGVertexType.GROUP || !this.groupContainsEntry((GroupedFunctionGraphVertex)vertex)) continue;
            result.add(vertex);
        }
        return result;
    }

    private boolean groupContainsEntry(GroupedFunctionGraphVertex vertex) {
        Set<FGVertex> groupVertices = vertex.getVertices();
        for (FGVertex groupedVertex : groupVertices) {
            FGVertexType vertexType = groupedVertex.getVertexType();
            if (vertex.isEntry()) {
                return true;
            }
            if (vertexType != FGVertexType.GROUP) continue;
            return this.groupContainsEntry((GroupedFunctionGraphVertex)groupedVertex);
        }
        return false;
    }

    private boolean groupContainsExit(GroupedFunctionGraphVertex vertex) {
        Set<FGVertex> groupVertices = vertex.getVertices();
        for (FGVertex groupedVertex : groupVertices) {
            FGVertexType vertexType = groupedVertex.getVertexType();
            if (vertexType.isExit()) {
                return true;
            }
            if (vertexType != FGVertexType.GROUP) continue;
            return this.groupContainsExit((GroupedFunctionGraphVertex)groupedVertex);
        }
        return false;
    }

    public Set<FGVertex> getExitPoints() {
        LinkedHashSet<FGVertex> result = new LinkedHashSet<FGVertex>();
        for (FGVertex vertex : this.getVertices()) {
            if (vertex.getVertexType().isExit()) {
                result.add(vertex);
                continue;
            }
            if (vertex.getVertexType() != FGVertexType.GROUP || !this.groupContainsExit((GroupedFunctionGraphVertex)vertex)) continue;
            result.add(vertex);
        }
        return result;
    }

    public void dispose() {
        for (FGVertex vertex : this.getVertices()) {
            vertex.dispose();
        }
        this.vertices.clear();
        this.edges.clear();
        this.ungroupedEdges.clear();
        this.groupHistorySet.clear();
        this.ungroupedEdges = null;
        this.groupHistorySet = null;
        this.focusedVertex = null;
        this.rootVertex = null;
        this.settings = null;
        this.graphLayout.dispose();
        this.graphLayout = null;
        super.dispose();
    }

    protected void verticesRemoved(Collection<FGVertex> removed) {
        removed.forEach(v -> this.clearSavedVertexLocation((FGVertex)v));
        super.fireVerticesRemoved(removed);
    }

    public FunctionGraph copy() {
        Collection v = this.getVertices();
        Collection e = this.getEdges();
        FunctionGraph newGraph = new FunctionGraph(this.getFunction(), this.getSettings(), v, e);
        FGLayout originalLayout = this.getLayout();
        VisualGraphLayout newLayout = originalLayout.cloneLayout((VisualGraph)newGraph);
        newGraph.rootVertex = this.rootVertex;
        newGraph.setGraphLayout((FGLayout)newLayout);
        newLayout.setSize(originalLayout.getSize());
        newGraph.setOptions(this.getOptions());
        return newGraph;
    }

    public Set<FGEdge> createDummySources() {
        HashSet<FGEdge> dummyEdges = new HashSet<FGEdge>();
        Set<FGVertex> entries = this.getEntryPoints();
        for (FGVertex entry : entries) {
            AbstractFunctionGraphVertex abstractVertex = (AbstractFunctionGraphVertex)entry;
            FGController controller = abstractVertex.getController();
            DummyListingFGVertex newEntry = new DummyListingFGVertex(controller, abstractVertex.getAddresses(), RefType.UNCONDITIONAL_JUMP, true);
            newEntry.setVertexType(FGVertexType.ENTRY);
            FGVertex groupVertex = this.getVertexForAddress(entry.getVertexAddress());
            FGEdgeImpl edge = new FGEdgeImpl(newEntry, groupVertex, RefType.UNCONDITIONAL_JUMP, this.options);
            dummyEdges.add(edge);
        }
        return dummyEdges;
    }

    public Set<FGEdge> createDummySinks() {
        HashSet<FGEdge> dummyEdges = new HashSet<FGEdge>();
        Set<FGVertex> exits = this.getExitPoints();
        for (FGVertex exit : exits) {
            AbstractFunctionGraphVertex abstractVertex = (AbstractFunctionGraphVertex)exit;
            FGController controller = abstractVertex.getController();
            ListingFunctionGraphVertex newExit = new ListingFunctionGraphVertex(controller, abstractVertex.getAddresses(), RefType.UNCONDITIONAL_JUMP, true);
            newExit.setVertexType(FGVertexType.EXIT);
            FGVertex groupVertex = this.getVertexForAddress(exit.getVertexAddress());
            FGEdgeImpl edge = new FGEdgeImpl(groupVertex, newExit, RefType.UNCONDITIONAL_JUMP, this.options);
            dummyEdges.add(edge);
        }
        return dummyEdges;
    }

    public GDirectedGraph<FGVertex, FGEdge> emptyCopy() {
        return new FunctionGraph(this.function, this.settings);
    }
}

