/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.util;

import db.DBRecord;
import db.RecordIterator;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.util.AddressRangeMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.Lock;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

class AddressRangeMapIterator
implements AddressRangeIterator {
    private AddressRangeMapDB rangeMap;
    private AddressMap addressMap;
    private Lock lock;
    private int expectedModCount;
    private DBRecord nextRecord;
    private RecordIterator recordIterator;
    private AddressRange startRange;
    private Address iteratorStart;
    private Address iteratorEnd;

    AddressRangeMapIterator(AddressRangeMapDB rangeMap) throws IOException {
        this.rangeMap = rangeMap;
        this.lock = rangeMap.getLock();
        this.addressMap = rangeMap.getAddressMap();
        this.expectedModCount = rangeMap.getModCount();
        this.recordIterator = new AddressKeyRecordIterator(rangeMap.getTable(), this.addressMap);
        this.startRange = this.checkForStartRangeFromWrappingAddressRecord();
    }

    AddressRangeMapIterator(AddressRangeMapDB rangeMap, Address start) throws IOException {
        this(rangeMap, start, null);
    }

    AddressRangeMapIterator(AddressRangeMapDB rangeMap, Address start, Address end) throws IOException {
        this.rangeMap = rangeMap;
        this.lock = rangeMap.getLock();
        this.addressMap = rangeMap.getAddressMap();
        this.expectedModCount = rangeMap.getModCount();
        this.iteratorStart = start;
        this.iteratorEnd = this.getIteratorEnd(end);
        AddressRange range = rangeMap.getAddressRangeContaining(this.iteratorStart);
        this.recordIterator = new AddressKeyRecordIterator(rangeMap.getTable(), this.addressMap, range.getMinAddress(), this.iteratorEnd, range.getMinAddress(), true);
        this.startRange = this.trimRange(this.checkForStartRangeFromWrappingAddressRecord());
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean hasNext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public AddressRange next() {
        this.lock.acquire();
        try {
            if (this.expectedModCount != this.rangeMap.getModCount()) {
                throw new ConcurrentModificationException();
            }
            if (this.nextRecord != null) {
                DBRecord record = this.nextRecord;
                this.nextRecord = null;
                AddressRange addressRange = this.getAddressRange(record);
                return addressRange;
            }
            if (this.recordIterator == null || !this.recordIterator.hasNext()) {
                if (this.startRange != null) {
                    AddressRange range = this.startRange;
                    this.startRange = null;
                    AddressRange addressRange = range;
                    return addressRange;
                }
                AddressRange range = null;
                return range;
            }
            AddressRange range = this.getAddressRange(this.recordIterator.next());
            return range;
        }
        catch (IOException e) {
            this.rangeMap.dbError(e);
            AddressRange addressRange = null;
            return addressRange;
        }
        finally {
            this.lock.release();
        }
    }

    private AddressRange getAddressRange(DBRecord record) {
        List<AddressRange> ranges = this.rangeMap.getRangesForRecord(record);
        if (ranges.isEmpty()) {
            return null;
        }
        AddressRange range = ranges.get(ranges.size() - 1);
        if (this.startRange != null && this.hasSameSpace(this.startRange.getMinAddress(), range.getMinAddress())) {
            range = this.startRange;
            this.startRange = null;
            this.nextRecord = record;
        }
        return this.trimRange(range);
    }

    private boolean hasSameSpace(Address address1, Address address2) {
        AddressSpace space1 = address1.getAddressSpace();
        AddressSpace space2 = address2.getAddressSpace();
        return space1.equals(space2);
    }

    private AddressRange checkForStartRangeFromWrappingAddressRecord() throws IOException {
        DBRecord record = this.rangeMap.getAddressWrappingRecord();
        if (record == null) {
            return null;
        }
        List<AddressRange> ranges = this.rangeMap.getRangesForRecord(record);
        return ranges.get(0);
    }

    private Address getIteratorEnd(Address end) {
        if (end != null) {
            return end;
        }
        AddressFactory factory = this.addressMap.getAddressFactory();
        AddressSet allAddresses = factory.getAddressSet();
        return allAddresses.getMaxAddress();
    }

    private AddressRange trimRange(AddressRange range) {
        Address end;
        if (range == null) {
            return null;
        }
        if (this.iteratorStart == null) {
            return range;
        }
        if (range.compareTo(this.iteratorStart) > 0 && range.compareTo(this.iteratorEnd) < 0) {
            return range;
        }
        Address start = Address.max(range.getMinAddress(), this.iteratorStart);
        if (start.compareTo(end = Address.min(range.getMaxAddress(), this.iteratorEnd)) <= 0) {
            return new AddressRangeImpl(start, end);
        }
        return null;
    }
}

