/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.widgets.OptionDialog;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompile.actions.RetypeFieldTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;

public class RetypeStructFieldTask
extends RetypeFieldTask {
    private DataTypeComponent component;
    private int offset;
    private boolean disablePacking = false;

    public RetypeStructFieldTask(PluginTool tool, Program program, DecompilerProvider provider, ClangToken token, Composite composite) {
        super(tool, program, provider, token, composite);
    }

    @Override
    public String getTransactionName() {
        return "Retype Structure Field";
    }

    @Override
    public boolean isValidBefore() {
        if (!(this.composite instanceof Structure)) {
            this.errorMsg = "Could not identify structure at cursor";
            return false;
        }
        Structure struct = (Structure)this.composite;
        this.offset = ((ClangFieldToken)this.tokenAtCursor).getOffset();
        if (this.offset < 0 || this.offset >= struct.getLength()) {
            this.errorMsg = "Bad offset (" + this.offset + ") specified";
            return false;
        }
        this.component = struct.getComponentContaining(this.offset);
        if (this.component != null && this.component.getOffset() != this.offset) {
            this.errorMsg = "Offset does not correspond to start of field";
            return false;
        }
        DataType dataType = this.oldType = this.component != null ? this.component.getDataType() : DataType.DEFAULT;
        if (this.oldType instanceof BitFieldDataType) {
            this.errorMsg = "Retype of defined bit-field is not supported.";
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidAfter() {
        int newDtLength = this.newType.getLength();
        if (this.newType instanceof FactoryDataType || newDtLength <= 0) {
            this.errorMsg = "Field of type '" + this.newType.getName() + "' - is not allowed.";
            return false;
        }
        if (DataTypeComponent.usesZeroLengthComponent((DataType)this.newType)) {
            this.errorMsg = "Zero-length component is not allowed.";
            return false;
        }
        if (this.oldType == DataType.DEFAULT || newDtLength == this.oldType.getLength()) {
            return true;
        }
        int nextOffset = this.component == null ? this.offset + 1 : this.component.getEndOffset() + 1;
        int available = nextOffset - this.offset;
        if (newDtLength > available) {
            int endOffset;
            Structure struct = (Structure)this.composite;
            DataTypeComponent nextComp = struct.getDefinedComponentAtOrAfterOffset(nextOffset);
            int n = endOffset = nextComp == null ? struct.getLength() : nextComp.getOffset();
            if (newDtLength > (available += endOffset - nextOffset)) {
                this.errorMsg = "Datatype will not fit";
                return false;
            }
        }
        return this.verifyPacking();
    }

    @Override
    public void commit() throws IllegalArgumentException {
        Structure struct = (Structure)this.composite;
        String fieldName = null;
        String comment = null;
        if (this.component != null) {
            fieldName = this.component.getFieldName();
            comment = this.component.getComment();
        }
        if (this.oldType != DataType.DEFAULT && this.newType.getLength() == this.oldType.getLength()) {
            struct.replace(this.component.getOrdinal(), this.newType, -1, fieldName, comment);
            return;
        }
        if (this.disablePacking) {
            int alignment = struct.getAlignment();
            struct.setPackingEnabled(false);
            struct.setExplicitMinimumAlignment(alignment);
        }
        struct.replaceAtOffset(this.offset, this.newType, -1, fieldName, comment);
    }

    private boolean verifyPacking() {
        Structure struct = (Structure)this.composite;
        if (!struct.isPackingEnabled()) {
            return true;
        }
        if (this.isAlignmentMaintained()) {
            return true;
        }
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Disable Structure Packing", (String)"Containing structure currently has packing enabled.  Packing will be disabled if you continue.", (String)"Continue", (int)2);
        if (choice != 1) {
            return false;
        }
        this.disablePacking = true;
        return true;
    }

    private boolean isAlignmentMaintained() {
        if (this.component == null) {
            return false;
        }
        int align = this.component.getDataType().getAlignment();
        if (align != this.newType.getAlignment()) {
            return false;
        }
        return this.offset % align == 0;
    }
}

