/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.features.bsim.gui.search.results.ExecutableResult;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class BSimExecutablesSummaryModel
extends GhidraProgramTableModel<ExecutableResult> {
    private Collection<ExecutableResult> results;

    BSimExecutablesSummaryModel(PluginTool tool, DatabaseInformation info) {
        super("Executable Sum", (ServiceProvider)tool, null, null);
        this.addCustomColumns(info);
    }

    private void addCustomColumns(DatabaseInformation info) {
        if (info == null) {
            return;
        }
        if (info.execats != null) {
            for (int i = 0; i < info.execats.size(); ++i) {
                this.addTableColumn((DynamicTableColumn)new ExecutableCategoryMatchColumn(info.execats.get(i)));
            }
        }
        if (info.dateColumnName != null) {
            this.addTableColumn((DynamicTableColumn)new ExecutableDateMatchColumn(info.dateColumnName));
        } else {
            this.addTableColumn((DynamicTableColumn)new ExecutableDateMatchColumn("Ingest Date"));
        }
    }

    protected TableColumnDescriptor<ExecutableResult> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new ExecutableNameMatchColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ArchitectureMatchColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new CompilerMatchColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new CountColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new SignificanceColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new RepoColumn());
        return descriptor;
    }

    protected void doLoad(Accumulator<ExecutableResult> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.results == null || this.results.isEmpty()) {
            return;
        }
        Iterator<ExecutableResult> iter = this.results.iterator();
        while (iter.hasNext()) {
            accumulator.add((Object)iter.next());
        }
    }

    public ProgramLocation getProgramLocation(int row, int column) {
        return null;
    }

    public ProgramSelection getProgramSelection(int[] rows) {
        return new ProgramSelection();
    }

    void reload(Program newProgram, Collection<ExecutableResult> set) {
        this.setProgram(newProgram);
        this.results = set;
        this.reload();
    }

    void clear() {
        this.clearData();
    }

    private static class ExecutableCategoryMatchColumn
    extends AbstractProgramBasedDynamicTableColumn<ExecutableResult, String> {
        private String columnName;

        public ExecutableCategoryMatchColumn(String name) {
            super("ExecutableCategoryMatchColumn: " + name);
            this.columnName = name;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getValue(ExecutableResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getExecutableRecord().getExeCategoryAlphabetic(this.columnName);
        }
    }

    private static class ExecutableDateMatchColumn
    extends AbstractProgramBasedDynamicTableColumn<ExecutableResult, Date> {
        private String columnName;

        public ExecutableDateMatchColumn(String name) {
            this.columnName = name;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Date getValue(ExecutableResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getExecutableRecord().getDate();
        }
    }

    private static class ExecutableNameMatchColumn
    extends AbstractProgramBasedDynamicTableColumn<ExecutableResult, String> {
        private ExecutableNameMatchColumn() {
        }

        public String getColumnName() {
            return "Exe Name";
        }

        public String getValue(ExecutableResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getExecutableRecord().getNameExec();
        }
    }

    private static class ArchitectureMatchColumn
    extends AbstractProgramBasedDynamicTableColumn<ExecutableResult, String> {
        private ArchitectureMatchColumn() {
        }

        public String getColumnName() {
            return "Architecture";
        }

        public String getValue(ExecutableResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getExecutableRecord().getArchitecture();
        }
    }

    private static class CompilerMatchColumn
    extends AbstractProgramBasedDynamicTableColumn<ExecutableResult, String> {
        private CompilerMatchColumn() {
        }

        public String getColumnName() {
            return "Compiler";
        }

        public String getValue(ExecutableResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getExecutableRecord().getNameCompiler();
        }
    }

    private static class CountColumn
    extends AbstractProgramBasedDynamicTableColumn<ExecutableResult, Integer> {
        private CountColumn() {
        }

        public String getColumnName() {
            return "Function Count";
        }

        public Integer getValue(ExecutableResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getFunctionCount();
        }
    }

    private static class SignificanceColumn
    extends AbstractProgramBasedDynamicTableColumn<ExecutableResult, Double> {
        private SignificanceColumn() {
        }

        public String getColumnName() {
            return "Confidence";
        }

        public Double getValue(ExecutableResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSignificanceSum();
        }
    }

    private static class RepoColumn
    extends AbstractProgramBasedDynamicTableColumn<ExecutableResult, String> {
        private RepoColumn() {
        }

        public String getColumnName() {
            return "URL";
        }

        public String getValue(ExecutableResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            String urlstring = rowObject.getExecutableRecord().getURLString();
            if (urlstring == null) {
                return "none";
            }
            return urlstring;
        }
    }
}

