/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import ghidra.net.ApplicationKeyManagerFactory;
import java.io.IOException;
import java.net.http.HttpClient;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;

public class HttpClients {
    private static HttpClient client;

    public static HttpClient.Builder newHttpClientBuilder() throws IOException {
        if (!ApplicationKeyManagerFactory.initialize() && ApplicationKeyManagerFactory.getKeyStore() != null) {
            throw new IOException("Failed to initialize PKI certificate keystore");
        }
        try {
            return HttpClient.newBuilder().sslContext(SSLContext.getDefault()).followRedirects(HttpClient.Redirect.NORMAL);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException("Missing algorithm", nsae);
        }
    }

    public static synchronized HttpClient getHttpClient() throws IOException {
        if (client == null) {
            client = HttpClients.newHttpClientBuilder().build();
        }
        return client;
    }

    public static synchronized void clearHttpClient() {
        client = null;
    }
}

