/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rcp;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.properties.PropertyBucket;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.fs.DBFResourceAdapter;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFile;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFolder;
import org.jkiss.dbeaver.model.impl.app.BaseProjectImpl;
import org.jkiss.dbeaver.model.impl.app.BaseWorkspaceImpl;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.rcp.DesktopApplicationImpl;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.task.TaskManagerImpl;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DesktopProjectImpl
extends BaseProjectImpl
implements RCPProject,
DBFResourceAdapter {
    private static final Log log = Log.getLog(DesktopProjectImpl.class);
    private static final String SETTINGS_FOLDER = ".settings";
    private static final String EMPTY_PROJECT_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n<name>${project-name}</name>\n<comment></comment>\n<projects>\n</projects>\n<buildSpec>\n</buildSpec>\n<natures>\n</natures>\n</projectDescription>";
    @NotNull
    private final IProject project;
    protected volatile DBTTaskManager taskManager;
    private volatile boolean projectInvalidated;

    public DesktopProjectImpl(@NotNull BaseWorkspaceImpl workspace, @NotNull IProject project, @Nullable SMSessionContext sessionContext) {
        super((DBPWorkspace)workspace, sessionContext);
        this.project = project;
    }

    public boolean isVirtual() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.project.getName();
    }

    @NotNull
    public Path getAbsolutePath() {
        if (this.project.getLocation() == null) {
            throw new IllegalStateException("Can't determine the workspace path for project " + this.project.getName());
        }
        return this.project.getLocation().toFile().toPath();
    }

    @Override
    @Nullable
    public IProject getEclipseProject() {
        return this.project;
    }

    @Override
    @Nullable
    public IContainer getRootResource() {
        return this.getEclipseProject();
    }

    @Override
    @NotNull
    public String getResourcePath(@NotNull IResource resource) {
        return resource.getProjectRelativePath().toString();
    }

    public boolean isOpen() {
        return this.project.isOpen();
    }

    public void ensureOpen() throws IllegalStateException {
        block15: {
            if (!this.project.isOpen()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                try {
                    this.project.open((IProgressMonitor)monitor);
                    if (!DBWorkbench.isDistributed()) {
                        this.project.refreshLocal(1, (IProgressMonitor)monitor);
                    }
                }
                catch (CoreException e) {
                    if (!this.getWorkspace().getPlatform().getApplication().isStandalone() || !e.getMessage().contains(".project")) break block15;
                    try {
                        this.recoverProjectDescription();
                        this.project.open((IProgressMonitor)monitor);
                        this.hideConfigurationFiles();
                        this.project.refreshLocal(1, (IProgressMonitor)monitor);
                    }
                    catch (Exception e2) {
                        log.error((Object)"Error opening project", (Throwable)e2);
                        return;
                    }
                }
            }
        }
        if (!this.projectInvalidated) {
            try {
                if (this.isInMemory()) {
                    this.setFormat(BaseProjectImpl.ProjectFormat.MODERN);
                    return;
                }
                if (DBWorkbench.getPlatform().getApplication() instanceof DesktopApplicationImpl && !DBWorkbench.isDistributed()) {
                    Path mdFolder = this.getMetadataFolder(false);
                    Path dsConfig = this.getAbsolutePath().resolve(".dbeaver-data-sources.xml");
                    if (!Files.exists(mdFolder, new LinkOption[0]) && Files.exists(dsConfig, new LinkOption[0])) {
                        this.setFormat(BaseProjectImpl.ProjectFormat.LEGACY);
                    } else {
                        this.setFormat(BaseProjectImpl.ProjectFormat.MODERN);
                    }
                    this.checkAndUpdateProjectStructure();
                }
                this.setFormat(BaseProjectImpl.ProjectFormat.MODERN);
            }
            finally {
                this.projectInvalidated = true;
            }
        }
    }

    public boolean isUseSecretStorage() {
        return false;
    }

    @NotNull
    protected DBPDataSourceRegistry createDataSourceRegistry() {
        return new DataSourceRegistry((DBPProject)this);
    }

    @Nullable
    public <T> T adaptResource(DBFVirtualFileSystemRoot fsRoot, Path path, Class<T> adapter) {
        if (adapter == IResource.class) {
            return adapter.cast(this.createResourceFromPath(fsRoot, path));
        }
        return null;
    }

    @NotNull
    private IResource createResourceFromPath(DBFVirtualFileSystemRoot fsRoot, Path path) {
        EFSNIOFileSystemRoot root = new EFSNIOFileSystemRoot(this.getEclipseProject(), fsRoot, fsRoot.getFileSystem().getType() + "/" + fsRoot.getFileSystem().getId() + "/" + fsRoot.getRootId());
        if (fsRoot.getFileSystem().isDirectory(path)) {
            return new EFSNIOFolder(root, path);
        }
        return new EFSNIOFile(root, path);
    }

    @Nullable
    public DBNModel getNavigatorModel() {
        return this.getWorkspace().getPlatform().getNavigatorModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBTTaskManager getTaskManager() {
        this.ensureOpen();
        if (this.taskManager == null) {
            Object object = this.metadataSync;
            synchronized (object) {
                if (this.taskManager == null) {
                    this.taskManager = this.createTaskManager();
                }
            }
        }
        return this.taskManager;
    }

    @Nullable
    public DBTTaskManager getTaskManager(boolean create) {
        if (this.taskManager != null) {
            return this.taskManager;
        }
        return create ? this.getTaskManager() : null;
    }

    @NotNull
    protected DBTTaskManager createTaskManager() {
        return new TaskManagerImpl((BaseProjectImpl)this, this.getWorkspace().getMetadataFolder().resolve("task-stats"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateProjectStructure() {
        if (this.getFormat() == BaseProjectImpl.ProjectFormat.UNKNOWN || this.getFormat() == BaseProjectImpl.ProjectFormat.MODERN) {
            return;
        }
        Path mdConfig = this.getMetadataPath().resolve("project-metadata.json");
        if (!Files.exists(mdConfig, new LinkOption[0])) {
            Map<String, Map<String, Object>> projectResourceProperties = this.extractProjectResourceProperties();
            Object object = this.metadataSync;
            synchronized (object) {
                this.setResourceProperties(projectResourceProperties);
            }
            this.flushMetadata();
        }
    }

    private Map<String, Map<String, Object>> extractProjectResourceProperties() {
        final LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        if (!(this.getWorkspace() instanceof DBPWorkspaceEclipse)) {
            return result;
        }
        DBPWorkspaceEclipse workspaceEclipse = (DBPWorkspaceEclipse)this.getWorkspace();
        try {
            BucketTree bucketTree = new BucketTree((Workspace)workspaceEclipse.getEclipseWorkspace(), (Bucket)new PropertyBucket());
            try {
                final IPath projectPath = this.project.getFullPath();
                bucketTree.accept(new Bucket.Visitor(){

                    public int visit(Bucket.Entry entry) {
                        Object value = entry.getValue();
                        if (value instanceof String[][]) {
                            String[][] bucketProps;
                            String[][] stringArray = bucketProps = (String[][])value;
                            int n = bucketProps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String[] resProps = stringArray[n2];
                                if (resProps.length == 3 && "org.jkiss.dbeaver".equals(resProps[0]) && !"sql-editor-project-id".equals(resProps[1])) {
                                    Map propsMap = result.computeIfAbsent(entry.getPath().makeRelativeTo(projectPath).toString(), s -> new LinkedHashMap());
                                    propsMap.put(resProps[1], resProps[2]);
                                }
                                ++n2;
                            }
                        }
                        return 0;
                    }
                }, projectPath, Integer.MAX_VALUE);
            }
            catch (CoreException e) {
                log.error((Object)e);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error extracting project metadata", e);
        }
        return result;
    }

    public void hideConfigurationFiles() {
        if (this.project.isOpen() && DBWorkbench.getPlatform().getApplication().isStandalone()) {
            IFolder metadataFolder = this.project.getFolder(".dbeaver");
            this.hideResource((IResource)metadataFolder);
            IFolder settingsFolder = this.project.getFolder(SETTINGS_FOLDER);
            this.hideResource((IResource)settingsFolder);
            IFile file = this.project.getFile(".project");
            this.hideResource((IResource)file);
        }
    }

    private void hideResource(IResource file) {
        if (file.exists() && !file.isHidden()) {
            try {
                file.setHidden(true);
            }
            catch (CoreException e) {
                log.error((Object)"Error hiding metadata folder", (Throwable)e);
            }
        }
    }

    public void recoverProjectDescription() throws IOException {
        Path mdFile = this.getAbsolutePath().resolve(".project");
        log.debug((Object)("Recovering project '" + this.project.getName() + "' metadata " + String.valueOf(mdFile.toAbsolutePath())));
        IOUtils.writeFileFromString((File)mdFile.toFile(), (String)EMPTY_PROJECT_TEMPLATE.replace("${project-name}", this.project.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, Map<String, Object>> getAllResourceProperties() {
        this.loadMetadata();
        Object object = this.resourcesSync;
        synchronized (object) {
            return new TreeMap<String, Map<String, Object>>(this.resourceProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResourceFromCache(IPath path) {
        boolean cacheChanged = false;
        Object object = this.resourcesSync;
        synchronized (object) {
            if (this.resourceProperties != null) {
                String resPath = CommonUtils.normalizeResourcePath((String)path.toString());
                cacheChanged = this.resourceProperties.remove(resPath) != null;
            }
        }
        if (cacheChanged) {
            this.flushMetadata();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveResourceCache(IPath oldPath, IPath newPath) {
        boolean cacheChanged = false;
        Object object = this.resourcesSync;
        synchronized (object) {
            String oldResPath;
            Map props;
            if (this.resourceProperties != null && (props = (Map)this.resourceProperties.remove(oldResPath = CommonUtils.normalizeResourcePath((String)oldPath.toString()))) != null) {
                String newResPath = CommonUtils.normalizeResourcePath((String)newPath.toString());
                this.resourceProperties.put(newResPath, props);
                cacheChanged = true;
            }
        }
        if (cacheChanged) {
            this.flushMetadata();
        }
    }

    public void updateProjectNature() {
        if (!this.isRegistryLoaded()) {
            return;
        }
        try {
            IProjectDescription description;
            IProject eclipseProject = this.getEclipseProject();
            if (eclipseProject != null && (description = eclipseProject.getDescription()) != null) {
                DataSourceRegistry dsr;
                Object[] natureIds = description.getNatureIds();
                DBPDataSourceRegistry dBPDataSourceRegistry = this.getDataSourceRegistry();
                if (dBPDataSourceRegistry instanceof DataSourceRegistry && (dsr = (DataSourceRegistry)dBPDataSourceRegistry).getDataSourceCount() > 0 && !ArrayUtils.contains((Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature")) {
                    description.setNatureIds((String[])ArrayUtils.add(String.class, (Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature"));
                    try {
                        eclipseProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        log.debug((Object)"Can't set project nature", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }
}

