﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/voice-id/VoiceID_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace VoiceID {
namespace Model {

/**
 * <p>The configuration containing output file information for a batch
 * job.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/OutputDataConfig">AWS
 * API Reference</a></p>
 */
class OutputDataConfig {
 public:
  AWS_VOICEID_API OutputDataConfig() = default;
  AWS_VOICEID_API OutputDataConfig(Aws::Utils::Json::JsonView jsonValue);
  AWS_VOICEID_API OutputDataConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_VOICEID_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the KMS key you want Voice ID to use to encrypt the output
   * file of a speaker enrollment job/fraudster registration job. </p>
   */
  inline const Aws::String& GetKmsKeyId() const { return m_kmsKeyId; }
  inline bool KmsKeyIdHasBeenSet() const { return m_kmsKeyIdHasBeenSet; }
  template <typename KmsKeyIdT = Aws::String>
  void SetKmsKeyId(KmsKeyIdT&& value) {
    m_kmsKeyIdHasBeenSet = true;
    m_kmsKeyId = std::forward<KmsKeyIdT>(value);
  }
  template <typename KmsKeyIdT = Aws::String>
  OutputDataConfig& WithKmsKeyId(KmsKeyIdT&& value) {
    SetKmsKeyId(std::forward<KmsKeyIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The S3 path of the folder where Voice ID writes the job output file. It has a
   * <code>*.out</code> extension. For example, if the input file name is
   * <code>input-file.json</code> and the output folder path is
   * <code>s3://output-bucket/output-folder</code>, the full output file path is
   * <code>s3://output-bucket/output-folder/job-Id/input-file.json.out</code>.</p>
   */
  inline const Aws::String& GetS3Uri() const { return m_s3Uri; }
  inline bool S3UriHasBeenSet() const { return m_s3UriHasBeenSet; }
  template <typename S3UriT = Aws::String>
  void SetS3Uri(S3UriT&& value) {
    m_s3UriHasBeenSet = true;
    m_s3Uri = std::forward<S3UriT>(value);
  }
  template <typename S3UriT = Aws::String>
  OutputDataConfig& WithS3Uri(S3UriT&& value) {
    SetS3Uri(std::forward<S3UriT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_kmsKeyId;
  bool m_kmsKeyIdHasBeenSet = false;

  Aws::String m_s3Uri;
  bool m_s3UriHasBeenSet = false;
};

}  // namespace Model
}  // namespace VoiceID
}  // namespace Aws
