#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or
# https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import (absolute_import, division, print_function)
__metaclass__ = type
from ansible.plugins.action import ActionBase
try:
    from ansible_collections.ansible.utils.plugins.module_utils.common.argspec_validate import (
        AnsibleArgSpecValidator, )
except ImportError:
    ANSIBLE_UTILS_IS_INSTALLED = False
else:
    ANSIBLE_UTILS_IS_INSTALLED = True
from ansible.errors import AnsibleActionFail
from ansible_collections.cisco.meraki.plugins.plugin_utils.meraki import (
    MERAKI,
    meraki_argument_spec,
    meraki_compare_equality,
    get_dict_result,
)
from ansible_collections.cisco.meraki.plugins.plugin_utils.exceptions import (
    InconsistentParameters,
)

# Get common arguments specification
argument_spec = meraki_argument_spec()
# Add arguments specific for this module
argument_spec.update(dict(
    state=dict(type="str", default="present", choices=["present", "absent"]),
    serials=dict(type="list"),
    name=dict(type="str"),
    outputType=dict(type="str"),
    destination=dict(type="str"),
    ports=dict(type="str"),
    notes=dict(type="str"),
    duration=dict(type="int"),
    filterExpression=dict(type="str"),
    interface=dict(type="str"),
    advanced=dict(type="dict"),
    organizationId=dict(type="str"),
    captureId=dict(type="str"),
))

required_if = [
    ("state", "present", ["captureId", "name", "organizationId"], True),
    ("state", "absent", ["captureId", "name", "organizationId"], True),
]
required_one_of = []
mutually_exclusive = []
required_together = []


class OrganizationsDevicesPacketCaptureCaptures(object):
    def __init__(self, params, meraki):
        self.meraki = meraki
        self.new_object = dict(
            serials=params.get("serials"),
            name=params.get("name"),
            outputType=params.get("outputType"),
            destination=params.get("destination"),
            ports=params.get("ports"),
            notes=params.get("notes"),
            duration=params.get("duration"),
            filterExpression=params.get("filterExpression"),
            interface=params.get("interface"),
            advanced=params.get("advanced"),
            organization_id=params.get("organizationId"),
            capture_id=params.get("captureId"),
        )

    def get_all_params(self, name=None, id=None):
        new_object_params = {}
        if self.new_object.get('captureIds') is not None or self.new_object.get(
                'capture_ids') is not None:
            new_object_params['captureIds'] = self.new_object.get(
                'captureIds') or self.new_object.get('capture_ids')
        if self.new_object.get('networkIds') is not None or self.new_object.get(
                'network_ids') is not None:
            new_object_params['networkIds'] = self.new_object.get(
                'networkIds') or self.new_object.get('network_ids')
        if self.new_object.get('serials') is not None or self.new_object.get(
                'serials') is not None:
            new_object_params['serials'] = self.new_object.get('serials')
        if self.new_object.get('process') is not None or self.new_object.get(
                'process') is not None:
            new_object_params['process'] = self.new_object.get('process')
        if self.new_object.get('captureStatus') is not None or self.new_object.get(
                'capture_status') is not None:
            new_object_params['captureStatus'] = self.new_object.get(
                'captureStatus') or self.new_object.get('capture_status')
        new_object_params['name'] = name or self.new_object.get('name')
        if self.new_object.get('clientMac') is not None or self.new_object.get(
                'client_mac') is not None:
            new_object_params['clientMac'] = self.new_object.get(
                'clientMac') or self.new_object.get('client_mac')
        if self.new_object.get('notes') is not None or self.new_object.get(
                'notes') is not None:
            new_object_params['notes'] = self.new_object.get('notes')
        if self.new_object.get('deviceName') is not None or self.new_object.get(
                'device_name') is not None:
            new_object_params['deviceName'] = self.new_object.get(
                'deviceName') or self.new_object.get('device_name')
        if self.new_object.get('adminName') is not None or self.new_object.get(
                'admin_name') is not None:
            new_object_params['adminName'] = self.new_object.get(
                'adminName') or self.new_object.get('admin_name')
        if self.new_object.get(
                't0') is not None or self.new_object.get('t0') is not None:
            new_object_params['t0'] = self.new_object.get('t0')
        if self.new_object.get(
                't1') is not None or self.new_object.get('t1') is not None:
            new_object_params['t1'] = self.new_object.get('t1')
        if self.new_object.get('timespan') is not None or self.new_object.get(
                'timespan') is not None:
            new_object_params['timespan'] = self.new_object.get('timespan')
        if self.new_object.get('perPage') is not None or self.new_object.get(
                'per_page') is not None:
            new_object_params['perPage'] = self.new_object.get('perPage') or \
                self.new_object.get('per_page')
        new_object_params['total_pages'] = -1
        if self.new_object.get('startingAfter') is not None or self.new_object.get(
                'starting_after') is not None:
            new_object_params['startingAfter'] = self.new_object.get(
                'startingAfter') or self.new_object.get('starting_after')
        if self.new_object.get('endingBefore') is not None or self.new_object.get(
                'ending_before') is not None:
            new_object_params['endingBefore'] = self.new_object.get(
                'endingBefore') or self.new_object.get('ending_before')
        if self.new_object.get('sortOrder') is not None or self.new_object.get(
                'sort_order') is not None:
            new_object_params['sortOrder'] = self.new_object.get(
                'sortOrder') or self.new_object.get('sort_order')
        if self.new_object.get('organizationId') is not None or self.new_object.get(
                'organization_id') is not None:
            new_object_params['organizationId'] = self.new_object.get(
                'organizationId') or self.new_object.get('organization_id')
        return new_object_params

    def create_params(self):
        new_object_params = {}
        if self.new_object.get('serials') is not None or self.new_object.get(
                'serials') is not None:
            new_object_params['serials'] = self.new_object.get('serials') or \
                self.new_object.get('serials')
        if self.new_object.get('name') is not None or self.new_object.get(
                'name') is not None:
            new_object_params['name'] = self.new_object.get('name') or \
                self.new_object.get('name')
        if self.new_object.get('outputType') is not None or self.new_object.get(
                'output_type') is not None:
            new_object_params['outputType'] = self.new_object.get(
                'outputType') or self.new_object.get('output_type')
        if self.new_object.get('destination') is not None or self.new_object.get(
                'destination') is not None:
            new_object_params['destination'] = self.new_object.get(
                'destination') or self.new_object.get('destination')
        if self.new_object.get('ports') is not None or self.new_object.get(
                'ports') is not None:
            new_object_params['ports'] = self.new_object.get('ports') or \
                self.new_object.get('ports')
        if self.new_object.get('notes') is not None or self.new_object.get(
                'notes') is not None:
            new_object_params['notes'] = self.new_object.get('notes') or \
                self.new_object.get('notes')
        if self.new_object.get('duration') is not None or self.new_object.get(
                'duration') is not None:
            new_object_params['duration'] = self.new_object.get(
                'duration') or self.new_object.get('duration')
        if self.new_object.get('filterExpression') is not None or self.new_object.get(
                'filter_expression') is not None:
            new_object_params['filterExpression'] = self.new_object.get(
                'filterExpression') or self.new_object.get('filter_expression')
        if self.new_object.get('interface') is not None or self.new_object.get(
                'interface') is not None:
            new_object_params['interface'] = self.new_object.get(
                'interface') or self.new_object.get('interface')
        if self.new_object.get('advanced') is not None or self.new_object.get(
                'advanced') is not None:
            new_object_params['advanced'] = self.new_object.get(
                'advanced') or self.new_object.get('advanced')
        if self.new_object.get('organizationId') is not None or self.new_object.get(
                'organization_id') is not None:
            new_object_params['organizationId'] = self.new_object.get(
                'organizationId') or self.new_object.get('organization_id')
        return new_object_params

    def delete_by_id_params(self):
        new_object_params = {}
        if self.new_object.get('organizationId') is not None or self.new_object.get(
                'organization_id') is not None:
            new_object_params['organizationId'] = self.new_object.get(
                'organizationId') or self.new_object.get('organization_id')
        if self.new_object.get('captureId') is not None or self.new_object.get(
                'capture_id') is not None:
            new_object_params['captureId'] = self.new_object.get(
                'captureId') or self.new_object.get('capture_id')
        return new_object_params

    def get_object_by_name(self, name):
        result = None
        # NOTE: Does not have a get by name method, using get all
        try:
            items = self.meraki.exec_meraki(
                family="organizations",
                function="getOrganizationDevicesPacketCaptureCaptures",
                params=self.get_all_params(name=name),
            )
            if isinstance(items, dict):
                if 'response' in items:
                    items = items.get('response')
            result = get_dict_result(items, 'name', name)
            if result is None:
                result = items
        except Exception as e:
            print("Error: ", e)
            result = None
        return result

    def get_object_by_id(self, id):
        result = None
        # NOTE: Does not have a get by id method or it is in another action
        return result

    def exists(self):
        prev_obj = None
        id_exists = False
        name_exists = False
        o_id = self.new_object.get("id")  # review it
        o_id = o_id or self.new_object.get(
            "capture_id") or self.new_object.get("captureId")
        name = self.new_object.get("name")
        if o_id:
            prev_obj = self.get_object_by_name(o_id)
            id_exists = prev_obj is not None and isinstance(prev_obj, dict)
        if not id_exists and name:
            prev_obj = self.get_object_by_name(name)
            name_exists = prev_obj is not None and isinstance(prev_obj, dict)
        if name_exists:
            _id = prev_obj.get("id")
            _id = _id or prev_obj.get("captureId")
            if id_exists and name_exists and o_id != _id:
                raise InconsistentParameters(
                    "The 'id' and 'name' params don't refer to the same object")
            if _id:
                self.new_object.update(dict(id=_id))
                self.new_object.update(dict(captureId=_id))
        it_exists = prev_obj is not None and isinstance(prev_obj, dict)
        return (it_exists, prev_obj)

    def requires_update(self, current_obj):
        requested_obj = self.new_object

        obj_params = [
            ("serials", "serials"),
            ("name", "name"),
            ("outputType", "outputType"),
            ("destination", "destination"),
            ("ports", "ports"),
            ("notes", "notes"),
            ("duration", "duration"),
            ("filterExpression", "filterExpression"),
            ("interface", "interface"),
            ("advanced", "advanced"),
            ("organizationId", "organizationId"),
            ("captureId", "captureId"),
        ]
        # Method 1. Params present in request (Ansible) obj are the same as the current (ISE) params
        # If any does not have eq params, it requires update
        return any(
            not meraki_compare_equality(
                current_obj.get(meraki_param),
                requested_obj.get(ansible_param)) for (
                meraki_param,
                ansible_param) in obj_params)

    def create(self):
        result = self.meraki.exec_meraki(
            family="organizations",
            function="createOrganizationDevicesPacketCaptureCapture",
            params=self.create_params(),
            op_modifies=True,
        )
        return result

    def delete(self):
        id = self.new_object.get("id")
        id = id or self.new_object.get("captureId")
        name = self.new_object.get("name")
        result = None
        if not id:
            prev_obj_name = self.get_object_by_name(name)
            id_ = None
            if prev_obj_name:
                id_ = prev_obj_name.get("id")
                id_ = id_ or prev_obj_name.get("captureId")
            if id_:
                self.new_object.update(dict(captureid=id_))
        result = self.meraki.exec_meraki(
            family="organizations",
            function="deleteOrganizationDevicesPacketCaptureCapture",
            params=self.delete_by_id_params(),
        )
        return result


class ActionModule(ActionBase):
    def __init__(self, *args, **kwargs):
        if not ANSIBLE_UTILS_IS_INSTALLED:
            raise AnsibleActionFail(
                "ansible.utils is not installed. Execute 'ansible-galaxy collection install ansible.utils'")
        super(ActionModule, self).__init__(*args, **kwargs)
        self._supports_async = False
        self._supports_check_mode = False
        self._result = None

    # Checks the supplied parameters against the argument spec for this module
    def _check_argspec(self):
        aav = AnsibleArgSpecValidator(
            data=self._task.args,
            schema=dict(argument_spec=argument_spec),
            schema_format="argspec",
            schema_conditionals=dict(
                required_if=required_if,
                required_one_of=required_one_of,
                mutually_exclusive=mutually_exclusive,
                required_together=required_together,
            ),
            name=self._task.action,
        )
        valid, errors, self._task.args = aav.validate()
        if not valid:
            raise AnsibleActionFail(errors)

    def run(self, tmp=None, task_vars=None):
        self._task.diff = False
        self._result = super(ActionModule, self).run(tmp, task_vars)
        self._result["changed"] = False
        self._check_argspec()

        meraki = MERAKI(self._task.args)
        obj = OrganizationsDevicesPacketCaptureCaptures(
            self._task.args, meraki)

        state = self._task.args.get("state")

        response = None
        if state == "present":
            (obj_exists, prev_obj) = obj.exists()
            if obj_exists:
                if obj.requires_update(prev_obj):
                    response = prev_obj
                    meraki.object_present_and_different()
                else:
                    response = prev_obj
                    meraki.object_already_present()
            else:
                response = obj.create()
                meraki.object_created()
        elif state == "absent":
            (obj_exists, prev_obj) = obj.exists()
            if obj_exists:
                response = obj.delete()
                meraki.object_deleted()
            else:
                meraki.object_already_absent()

        self._result.update(dict(meraki_response=response))
        self._result.update(meraki.exit_json())
        return self._result
