/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.TimeFrame;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlOperandHandler;
import org.apache.calcite.sql.validate.SqlValidator;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class OperandHandlers {
    public static final SqlOperandHandler DEFAULT = new SqlOperandHandler(){};
    public static final SqlOperandHandler OPERAND_1_MIGHT_BE_TIME_FRAME = new TimeFrameOperandHandler(1);

    public static SqlOperandHandler of(final BiFunction<SqlValidator, SqlCall, SqlCall> fn) {
        return new SqlOperandHandler(){

            @Override
            public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
                return (SqlNode)fn.apply(validator, call);
            }
        };
    }

    private static class TimeFrameOperandHandler
    implements SqlOperandHandler {
        private final int timeFrameOperand;

        TimeFrameOperandHandler(int timeFrameOperand) {
            this.timeFrameOperand = timeFrameOperand;
        }

        private SqlNode getOperand(int i, SqlNode operand, Function<String, @Nullable TimeFrame> timeFrameResolver) {
            String name;
            TimeFrame timeFrame;
            if (i == this.timeFrameOperand && operand instanceof SqlIdentifier && ((SqlIdentifier)operand).isSimple() && (timeFrame = timeFrameResolver.apply(name = ((SqlIdentifier)operand).getSimple())) != null) {
                return new SqlIntervalQualifier(name, operand.getParserPosition());
            }
            return operand;
        }

        @Override
        public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
            ArrayList newOperandList = new ArrayList();
            Ord.forEach(call.getOperandList(), (operand, i) -> newOperandList.add(this.getOperand(i, (SqlNode)operand, name -> validator.getTimeFrameSet().getOpt((String)name))));
            if (newOperandList.equals(call.getOperandList())) {
                return call;
            }
            return call.getOperator().createCall(call.getFunctionQuantifier(), call.getParserPosition(), newOperandList);
        }
    }
}

